/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide;

import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.entry.EntryItemStack;
import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.modcompat.guide.GuideHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfoBuilder {
    private final ItemStack stack;
    private final boolean block;
    private String name;
    private Object[] formats = new Object[0];
    private Object[] links = null;
    private boolean ignoreMissingRecipes = false;
    private boolean customName;
    private List<Pair<ItemStack, GuideHelper.RECIPE_TYPE>> craftableStacks = null;

    public ItemInfoBuilder(ItemStack stack, boolean block) {
        assert (!stack.func_190926_b());
        this.stack = stack;
        this.block = block;
        this.name = stack.func_77973_b().getRegistryName().func_110623_a();
    }

    public ItemInfoBuilder(Item item) {
        this(new ItemStack(item), false);
    }

    public ItemInfoBuilder(Block block) {
        this(new ItemStack(block), true);
    }

    public void build(Map<ResourceLocation, EntryAbstract> entries) {
        ArrayList<IPage> pages = new ArrayList<IPage>();
        String base = "guide.vampirism." + (this.block ? "blocks" : "items") + "." + this.name;
        pages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + ".text", this.formats), this.stack));
        if (this.craftableStacks != null) {
            for (Pair<ItemStack, GuideHelper.RECIPE_TYPE> craft : this.craftableStacks) {
                IPage p = GuideHelper.getRecipePage((ItemStack)craft.getLeft(), (GuideHelper.RECIPE_TYPE)((Object)craft.getRight()));
                if (p != null) {
                    pages.add(p);
                    continue;
                }
                if (this.ignoreMissingRecipes) continue;
                VampirismMod.log.e("GuideBook", "Failed to find %s recipe for %s", craft.getRight(), craft.getLeft());
            }
        }
        if (this.links != null) {
            GuideHelper.addLinks(pages, this.links);
        }
        entries.put(new ResourceLocation(base), (EntryAbstract)new EntryItemStack(pages, this.customName ? base : this.stack.func_77977_a() + ".name", this.stack, true));
    }

    public ItemInfoBuilder craftable(GuideHelper.RECIPE_TYPE type) {
        this.craftableStacks = Collections.singletonList(ImmutablePair.of((Object)this.stack, (Object)((Object)type)));
        return this;
    }

    public ItemInfoBuilder craftableStacks(List<Object> list) {
        int length = list.size();
        if (length % 2 != 0) {
            VampirismMod.log.w("GuideBook", "Arguments: %s", list);
            throw new IllegalArgumentException("You have to provide a recipe type after each craftable");
        }
        this.craftableStacks = Lists.newArrayList();
        Iterator<Object> it = list.iterator();
        while (it.hasNext()) {
            ItemStack stack;
            Object craftable = it.next();
            if (craftable instanceof ItemStack) {
                stack = (ItemStack)craftable;
            } else if (craftable instanceof Item) {
                stack = new ItemStack((Item)craftable);
            } else if (craftable instanceof Block) {
                stack = new ItemStack((Block)craftable);
            } else {
                VampirismMod.log.w("GuideBook", "Arguments: %s", list);
                throw new IllegalArgumentException("Inputs have to be items or blocks or stacks");
            }
            Object type = it.next();
            if (!(type instanceof GuideHelper.RECIPE_TYPE)) {
                VampirismMod.log.w("GuideBook", "Arguments: %s", list);
                throw new IllegalArgumentException("You have to provide a recipe type after each craftable");
            }
            this.craftableStacks.add((Pair<ItemStack, GuideHelper.RECIPE_TYPE>)ImmutablePair.of((Object)stack, (Object)((Object)((GuideHelper.RECIPE_TYPE)((Object)type)))));
        }
        return this;
    }

    public ItemInfoBuilder craftableStacks(Object ... stacks) {
        return this.craftableStacks(Arrays.asList(stacks));
    }

    public ItemInfoBuilder customName() {
        this.customName = true;
        return this;
    }

    public ItemInfoBuilder ignoreMissingRecipes() {
        this.ignoreMissingRecipes = true;
        return this;
    }

    public ItemInfoBuilder setFormats(Object ... formats) {
        this.formats = formats;
        return this;
    }

    public ItemInfoBuilder setLinks(Object ... links) {
        this.links = links;
        return this;
    }

    public ItemInfoBuilder setName(String name) {
        this.name = name;
        return this;
    }
}

