/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.VampirismRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.BloodPotionTableContainer;
import de.teamlapen.vampirism.inventory.HunterBasicContainer;
import de.teamlapen.vampirism.inventory.HunterTrainerContainer;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import de.teamlapen.vampirism.network.AbstractServerMessageHandler;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.StringUtils;

public class InputEventPacket
implements IMessage {
    public static final String SUCKBLOOD = "sb";
    public static final String ENDSUCKBLOOD = "esb";
    public static final String TOGGLEACTION = "ta";
    public static final String UNLOCKSKILL = "us";
    public static final String RESETSKILL = "rs";
    public static final String TRAINERLEVELUP = "tl";
    public static final String REVERTBACK = "rb";
    public static final String WAKEUP = "wu";
    public static final String VAMPIRE_VISION_TOGGLE = "vvt";
    public static final String CRAFT_BLOOD_POTION = "cb";
    public static final String OPEN_BLOOD_POTION = "ob";
    public static final String BASICHUNTERLEVELUP = "bl";
    public static final String DRINK_BLOOD_BLOCK = "db";
    public static final String NAME_ITEM = "ni";
    private static final String TAG = "InputEventPacket";
    private final String SPLIT = "&";
    private String param;
    private String action;

    public InputEventPacket() {
    }

    public InputEventPacket(String action, String param) {
        this.action = action;
        this.param = param;
    }

    public void fromBytes(ByteBuf buf) {
        String[] s = ByteBufUtils.readUTF8String((ByteBuf)buf).split("&");
        this.action = s[0];
        this.param = s.length > 1 ? s[1] : "";
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.action + "&" + this.param));
    }

    public static class Handler
    extends AbstractServerMessageHandler<InputEventPacket> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, InputEventPacket message, MessageContext ctx) {
            if (message.action == null) {
                return null;
            }
            IFactionPlayer factionPlayer = FactionPlayerHandler.get(player).getCurrentFactionPlayer();
            if (message.action.equals(InputEventPacket.SUCKBLOOD)) {
                int id = 0;
                try {
                    id = Integer.parseInt(message.param);
                }
                catch (NumberFormatException e) {
                    VampirismMod.log.e(InputEventPacket.TAG, e, "Receiving invalid param for %s", message.action);
                }
                if (id != 0) {
                    VampirePlayer.get(player).biteEntity(id);
                }
            } else if (message.action.equals(InputEventPacket.ENDSUCKBLOOD)) {
                VampirePlayer.get(player).endFeeding(true);
            } else if (message.action.equals(InputEventPacket.TOGGLEACTION)) {
                ResourceLocation id = new ResourceLocation(message.param);
                if (factionPlayer != null) {
                    IActionHandler actionHandler = factionPlayer.getActionHandler();
                    IAction action = (IAction)VampirismRegistries.ACTIONS.getValue(id);
                    if (action != null) {
                        IAction.PERM r = actionHandler.toggleAction(action);
                        switch (r) {
                            case NOT_UNLOCKED: {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.action.not_unlocked", new Object[0]));
                                break;
                            }
                            case DISABLED: {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.action.deactivated_by_serveradmin", new Object[0]));
                                break;
                            }
                            case COOLDOWN: {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.action.cooldown_not_over", new Object[0]));
                                break;
                            }
                            case DISALLOWED: {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.action.disallowed", new Object[0]));
                            }
                        }
                    } else {
                        VampirismMod.log.e(InputEventPacket.TAG, "Failed to find action with id %d", id);
                    }
                } else {
                    VampirismMod.log.e(InputEventPacket.TAG, "Player %s is in no faction, so he cannot use action %d", player, id);
                }
            } else if (message.action.equals(InputEventPacket.DRINK_BLOOD_BLOCK)) {
                String[] coords = message.param.split(":");
                if (coords.length == 3) {
                    BlockPos pos = new BlockPos(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
                    VampirePlayer.get(player).biteBlock(pos);
                } else {
                    VampirismMod.log.w(InputEventPacket.TAG, "Received invalid %s parameter", InputEventPacket.DRINK_BLOOD_BLOCK);
                }
            } else if (message.action.equals(InputEventPacket.UNLOCKSKILL)) {
                if (factionPlayer != null) {
                    ISkill skill = (ISkill)VampirismRegistries.SKILLS.getValue(new ResourceLocation(message.param));
                    if (skill != null) {
                        ISkillHandler skillHandler = factionPlayer.getSkillHandler();
                        ISkillHandler.Result result = skillHandler.canSkillBeEnabled(skill);
                        if (result == ISkillHandler.Result.OK) {
                            skillHandler.enableSkill(skill);
                            if (factionPlayer instanceof ISyncable.ISyncableEntityCapabilityInst && skillHandler instanceof SkillHandler) {
                                NBTTagCompound sync = new NBTTagCompound();
                                ((SkillHandler)skillHandler).writeUpdateForClient(sync);
                                HelperLib.sync((ISyncable.ISyncableEntityCapabilityInst)((Object)factionPlayer), sync, (Entity)factionPlayer.getRepresentingPlayer(), false);
                            }
                        } else {
                            VampirismMod.log.w(InputEventPacket.TAG, "Skill %s cannot be activated for %s (%s)", new Object[]{skill, player, result});
                        }
                    } else {
                        VampirismMod.log.w(InputEventPacket.TAG, "Skill %s was not found so %s cannot activate it", message.param, player);
                    }
                } else {
                    VampirismMod.log.e(InputEventPacket.TAG, "Player %s is in no faction, so he cannot unlock skills", new Object[0]);
                }
            } else if (message.action.equals(InputEventPacket.RESETSKILL)) {
                if (factionPlayer != null) {
                    int l;
                    ISkillHandler skillHandler = factionPlayer.getSkillHandler();
                    skillHandler.resetSkills();
                    if (!VampirismMod.inDev && !VampirismMod.instance.getVersionInfo().getCurrentVersion().isTestVersion() && (l = factionPlayer.getLevel()) > 1) {
                        FactionPlayerHandler.get(player).setFactionLevel((IPlayableFaction)factionPlayer.getFaction(), l - 1);
                    }
                    if (factionPlayer instanceof ISyncable.ISyncableEntityCapabilityInst && skillHandler instanceof SkillHandler) {
                        NBTTagCompound sync = new NBTTagCompound();
                        ((SkillHandler)skillHandler).writeUpdateForClient(sync);
                        HelperLib.sync((ISyncable.ISyncableEntityCapabilityInst)((Object)factionPlayer), sync, (Entity)factionPlayer.getRepresentingPlayer(), false);
                    }
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.skill.skills_reset", new Object[0]));
                } else {
                    VampirismMod.log.e(InputEventPacket.TAG, "Player %s is in no faction, so he cannot reset skills", new Object[0]);
                }
            } else if (message.action.equals(InputEventPacket.TRAINERLEVELUP)) {
                if (player.field_71070_bA instanceof HunterTrainerContainer) {
                    ((HunterTrainerContainer)player.field_71070_bA).onLevelupClicked();
                }
            } else if (message.action.equals(InputEventPacket.REVERTBACK)) {
                FactionPlayerHandler.get(player).setFactionAndLevel(null, 0);
                VampirismMod.log.d(InputEventPacket.TAG, "Player %s left faction", player);
                if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_71199_h()) {
                    player.func_70097_a(DamageSource.field_76376_m, 1000.0f);
                }
            } else if (message.action.equals(InputEventPacket.WAKEUP)) {
                VampirePlayer.get(player).wakeUpPlayer(false, true, true);
            } else if (message.action.equals(InputEventPacket.VAMPIRE_VISION_TOGGLE)) {
                VampirePlayer.get(player).switchVision();
            } else if (message.action.equals(InputEventPacket.CRAFT_BLOOD_POTION)) {
                if (player.field_71070_bA != null && player.field_71070_bA instanceof BloodPotionTableContainer) {
                    ((BloodPotionTableContainer)player.field_71070_bA).onCraftingClicked();
                }
            } else if (message.action.equals(InputEventPacket.OPEN_BLOOD_POTION)) {
                HunterPlayer hunter = HunterPlayer.get(player);
                if (hunter.getLevel() > 0) {
                    if (hunter.getSkillHandler().isSkillEnabled(HunterSkills.blood_potion_portable_crafting)) {
                        player.openGui((Object)VampirismMod.instance, 7, player.func_130014_f_(), player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.can_only_be_used_with_skill", new Object[]{new TextComponentTranslation(HunterSkills.blood_potion_portable_crafting.getUnlocalizedName(), new Object[0])}));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.can_only_be_used_by", new Object[]{new TextComponentTranslation(VReference.HUNTER_FACTION.getUnlocalizedName(), new Object[0])}));
                }
            } else if (message.action.equals(InputEventPacket.BASICHUNTERLEVELUP)) {
                if (player.field_71070_bA instanceof HunterBasicContainer) {
                    ((HunterBasicContainer)player.field_71070_bA).onLevelUpClicked();
                }
            } else if (message.action.equals(InputEventPacket.NAME_ITEM)) {
                String name = message.param;
                if ("DO_NOT_NAME".equals(name)) {
                    ItemStack stack = player.func_184614_ca();
                    if (stack.func_77973_b() instanceof VampirismVampireSword) {
                        ((VampirismVampireSword)stack.func_77973_b()).doNotName(stack);
                    }
                } else if (!StringUtils.isBlank((CharSequence)name)) {
                    ItemStack stack = player.func_184614_ca();
                    stack.func_151001_c(name);
                }
            }
            return null;
        }

        @Override
        protected boolean handleOnMainThread() {
            return true;
        }
    }
}

