/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.hunter;

import de.teamlapen.vampirism.VampirismMod;

public class HunterLevelingConf {
    private static HunterLevelingConf instance;
    public final int BASIC_HUNTER_MIN_LEVEL = 2;
    public final int BASIC_HUNTER_MAX_LEVEL = 4;
    public final int TABLE_MIN_LEVEL = 5;
    public final int TABLE_MAX_LEVEL = 15;
    public final int HUNTER_INTEL_COUNT = 11;

    public static HunterLevelingConf instance() {
        if (instance == null) {
            instance = new HunterLevelingConf();
        }
        return instance;
    }

    public int getHunterIntelMetaForLevel(int level) {
        return this.isLevelValidForTable(level) ? level - 5 : -1;
    }

    public int[] getItemRequirementsForTable(int targetLevel) {
        if (!this.isLevelValidForTable(targetLevel)) {
            throw new IllegalArgumentException("Cannot use the table with the given target level " + targetLevel);
        }
        switch (targetLevel) {
            case 5: {
                return new int[]{10, 0, 0, 1};
            }
            case 6: {
                return new int[]{0, 1, 0, 1};
            }
            case 7: {
                return new int[]{10, 1, 0, 1};
            }
            case 8: {
                return new int[]{0, 1, 1, 1};
            }
            case 9: {
                return new int[]{15, 1, 1, 1};
            }
            case 10: {
                return new int[]{20, 1, 2, 1};
            }
            case 11: {
                return new int[]{20, 1, 2, 1};
            }
            case 12: {
                return new int[]{20, 1, 3, 1};
            }
            case 13: {
                return new int[]{25, 2, 3, 1};
            }
            case 14: {
                return new int[]{25, 2, 4, 1};
            }
            case 15: {
                return new int[]{64, 1, 5, 1};
            }
        }
        return null;
    }

    public int[] getItemRequirementsForTrainer(int targetLevel) {
        if (!this.isLevelValidForTrainer(targetLevel)) {
            throw new IllegalArgumentException("Cannot use the trainer with the given target level " + targetLevel);
        }
        switch (targetLevel) {
            case 5: {
                return new int[]{5, 0};
            }
            case 6: {
                return new int[]{10, 0};
            }
            case 7: {
                return new int[]{15, 0};
            }
            case 8: {
                return new int[]{40, 0};
            }
            case 9: {
                return new int[]{20, 10};
            }
            case 10: {
                return new int[]{20, 20};
            }
            case 11: {
                return new int[]{20, 10};
            }
            case 12: {
                return new int[]{30, 10};
            }
            case 13: {
                return new int[]{40, 20};
            }
            case 14: {
                return new int[]{40, 40};
            }
            case 15: {
                return new int[]{64, 64};
            }
        }
        VampirismMod.log.w("HunterLevelingConf", "Something is wrong with the hunter levels", new Object[0]);
        return null;
    }

    public int getLevelForHunterIntelMeta(int meta) {
        return Math.min(meta + 5, 15);
    }

    public int getVampireBloodCountForBasicHunter(int targetLevel) {
        if (!this.isLevelValidForBasicHunter(targetLevel)) {
            throw new IllegalArgumentException("Cannot use the table with the given target level " + targetLevel);
        }
        switch (targetLevel) {
            case 2: {
                return 1;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 12;
            }
        }
        return 100000;
    }

    public boolean isLevelValidForBasicHunter(int targetLevel) {
        return targetLevel >= 2 && targetLevel <= 4;
    }

    public boolean isLevelValidForTable(int targetLevel) {
        return targetLevel >= 5 && targetLevel <= 15;
    }

    public boolean isLevelValidForTrainer(int targetLevel) {
        return targetLevel >= 5 && targetLevel <= 15;
    }
}

