/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.blocks.BlockGarlicBeacon;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileGarlicBeacon
extends TileEntity
implements ITickable {
    private int id;
    private EnumStrength strength = EnumStrength.MEDIUM;
    private EnumStrength defaultStrength = EnumStrength.MEDIUM;
    private int r = 1;
    private boolean registered = false;
    private int fueled = 0;

    public int getFuelTime() {
        return this.fueled;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.unregister();
    }

    public void func_70296_d() {
        super.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    public void onFueled() {
        this.setFueledTime(1200);
        this.func_70296_d();
    }

    public void onTouched(EntityPlayer player) {
        VampirePlayer vampire = VampirePlayer.get(player);
        if (vampire.getLevel() > 0) {
            DamageHandler.affectVampireGarlicDirect(vampire, this.strength);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.r = compound.func_74762_e("radius");
        this.defaultStrength = EnumStrength.getFromStrenght(compound.func_74762_e("strength"));
        this.setFueledTime(compound.func_74762_e("fueled"));
    }

    public void setType(BlockGarlicBeacon.Type type) {
        switch (type) {
            case WEAK: {
                this.r = Balance.hps.GARLIC_DIFFUSOR_WEAK_DISTANCE;
                this.defaultStrength = EnumStrength.WEAK;
                break;
            }
            case NORMAL: {
                this.r = Balance.hps.GARLIC_DIFFUSOR_NORMAL_DISTANCE;
                this.defaultStrength = EnumStrength.MEDIUM;
                break;
            }
            case IMPROVED: {
                this.defaultStrength = EnumStrength.MEDIUM;
                this.r = Balance.hps.GARLIC_DIFFUSOR_ENHANCED_DISTANCE;
            }
        }
        this.strength = this.defaultStrength;
    }

    public void func_73660_a() {
        if (this.fueled > 0) {
            if (this.fueled == 1) {
                this.setFueledTime(0);
                this.func_70296_d();
            } else {
                --this.fueled;
            }
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.register();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("radius", this.r);
        compound.func_74768_a("strength", this.defaultStrength.getStrength());
        compound.func_74768_a("fueled", this.fueled);
        return compound;
    }

    protected void func_190201_b(World world) {
        this.func_145834_a(world);
    }

    private void register() {
        if (this.registered) {
            return;
        }
        int baseX = this.func_174877_v().func_177958_n() >> 4;
        int baseZ = this.func_174877_v().func_177952_p() >> 4;
        ChunkPos[] chunks = new ChunkPos[(2 * this.r + 1) * (2 * this.r + 1)];
        int i = 0;
        for (int x = -this.r; x <= this.r; ++x) {
            for (int z = -this.r; z <= this.r; ++z) {
                chunks[i++] = new ChunkPos(x + baseX, z + baseZ);
            }
        }
        this.id = VampirismAPI.getGarlicChunkHandler(this.func_145831_w()).registerGarlicBlock(this.strength, chunks);
        this.registered = true;
    }

    private void setFueledTime(int time) {
        int old = this.fueled;
        this.fueled = time;
        this.strength = this.fueled > 0 ? EnumStrength.STRONG : this.defaultStrength;
        if ((time > 0 && old == 0 || time == 0 && old > 0) && !this.func_145837_r()) {
            this.unregister();
            this.register();
        }
    }

    private void unregister() {
        if (this.registered) {
            VampirismAPI.getGarlicChunkHandler(this.func_145831_w()).removeGarlicBlock(this.id);
            this.registered = false;
        }
    }
}

