/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class DifficultyCalculator {
    @Nullable
    private static Difficulty calculateDifficulty(List<? extends EntityPlayer> playerList) {
        if (playerList == null || playerList.isEmpty()) {
            return null;
        }
        int min = Integer.MAX_VALUE;
        int max = 0;
        int sum = 0;
        for (EntityPlayer entityPlayer : playerList) {
            FactionPlayerHandler handler = FactionPlayerHandler.get(entityPlayer);
            if (handler.getCurrentLevel() == 0) {
                min = 0;
                continue;
            }
            int level = (int)((float)handler.getCurrentLevel() / (float)handler.getCurrentFaction().getHighestReachableLevel() * 100.0f);
            if (level < min) {
                min = level;
            }
            if (level > max) {
                max = level;
            }
            sum += max;
        }
        return new Difficulty(min, max, Math.round((float)sum / (float)playerList.size()));
    }

    public static Difficulty getWorldDifficulty(World w) {
        return DifficultyCalculator.calculateDifficulty(w.field_73010_i);
    }

    public static Difficulty getLocalDifficulty(World w, BlockPos center, int radius) {
        List list = w.func_72872_a(EntityPlayer.class, UtilLib.createBB(center, radius, true));
        return DifficultyCalculator.calculateDifficulty(list);
    }

    public static Difficulty getGlobalDifficulty() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            throw new IllegalStateException("You can only use this method on server side");
        }
        return DifficultyCalculator.calculateDifficulty(FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v());
    }

    @Nonnull
    public static Difficulty findDifficultyForPos(World world, BlockPos pos, int radius) {
        Difficulty d = DifficultyCalculator.getLocalDifficulty(world, pos, radius);
        if (d == null && (d = DifficultyCalculator.getWorldDifficulty(world)) == null && (d = DifficultyCalculator.getGlobalDifficulty()) == null) {
            d = new Difficulty(0, 0, 0);
        }
        return d;
    }
}

