/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.EntityVampireBase;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.util.Logger;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;

public class ModPotion
extends Potion {
    public static Potion sunscreen;
    public static Potion thirst;
    public static Potion saturation;
    public static Potion sanguinare;
    public static Potion garlic;
    @SideOnly(value=Side.CLIENT)
    private final ResourceLocation potionTexture = new ResourceLocation("vampirism", "textures/misc/potions.png");

    private static void increasePotionArraySize() {
        Potion[] potionTypes = null;
        for (Field f : Potion.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
                Field modfield = Field.class.getDeclaredField("modifiers");
                modfield.setAccessible(true);
                modfield.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                potionTypes = (Potion[])f.get(null);
                Potion[] newPotionTypes = new Potion[256];
                System.arraycopy(potionTypes, 0, newPotionTypes, 0, potionTypes.length);
                f.set(null, newPotionTypes);
            }
            catch (Exception e) {
                Logger.e("ModPotion", e, "COULDN'T INCREASE POTION ARRAY SIZE", new Object[0]);
            }
        }
    }

    public static void init() {
        ModPotion.increasePotionArraySize();
        sunscreen = new ModPotion(Configs.potion_id_sunscreen, false, 345345).func_76399_b(0, 0).func_76390_b("potion.vampirism.sunscreen");
        thirst = new ModPotion(Configs.potion_id_thirst, false, 859494).func_76399_b(1, 0).func_76390_b("potion.vampirism.thirst");
        saturation = new ModPotion(Configs.potion_id_saturation, false, 850484).func_76399_b(2, 0).func_76390_b("potion.vampirism.saturation");
        sanguinare = new ModPotion(Configs.potion_id_sanguinare, false, 6949000).func_76399_b(3, 0).func_76390_b("potion.vampirism.sanguinare").func_111184_a(SharedMonsterAttributes.field_111264_e, "22663B89-116E-49DC-9B6B-9971489B5BE5", 2.0, 0);
        garlic = new ModPotion(Configs.potion_id_garlic, false, 0xFFFFCC).func_76399_b(4, 0).func_76390_b("potion.vampirism.garlic");
    }

    public ModPotion(int id, boolean full_effectiv, int color) {
        super(id, full_effectiv, color);
    }

    public boolean func_76397_a(int duration, int amplifier) {
        if (this.field_76415_H == ModPotion.thirst.field_76415_H) {
            return true;
        }
        return this.field_76415_H == ModPotion.garlic.field_76415_H;
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        if (this.field_76415_H == ModPotion.thirst.field_76415_H && entity instanceof EntityPlayer) {
            VampirePlayer.get((EntityPlayer)entity).getBloodStats().addExhaustion(0.01f * (float)(amplifier + 1));
        }
        if (this.field_76415_H == ModPotion.garlic.field_76415_H) {
            boolean b = false;
            b = entity instanceof EntityPlayer ? VampirePlayer.get((EntityPlayer)entity).getLevel() > 0 : entity instanceof EntityVampireBase;
            if (b) {
                entity.func_70097_a(VampirismMod.garlicDamage, 1.0f + (float)amplifier / 2.0f);
            }
        }
    }

    public static String checkPotions() {
        String r = "";
        if (!sunscreen.equals(Potion.field_76425_a[ModPotion.sunscreen.field_76415_H])) {
            r = r + "sunscreen, ";
        }
        if (!thirst.equals(Potion.field_76425_a[ModPotion.thirst.field_76415_H])) {
            r = r + "thirst, ";
        }
        if (!saturation.equals(Potion.field_76425_a[ModPotion.saturation.field_76415_H])) {
            r = r + "saturation, ";
        }
        if (!sanguinare.equals(Potion.field_76425_a[ModPotion.sanguinare.field_76415_H])) {
            r = r + "sanguinare, ";
        }
        if (!garlic.equals(Potion.field_76425_a[ModPotion.garlic.field_76415_H])) {
            r = r + "garlic, ";
        }
        if (r.isEmpty()) {
            return null;
        }
        return r;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76392_e() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.potionTexture);
        return super.func_76392_e();
    }
}

