/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.generation.WorldGenVampirism;
import de.teamlapen.vampirism.util.BasicCommand;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.util.VampireLordData;
import de.teamlapen.vampirism.util.VersionChecker;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;

public class VampirismCommand
extends BasicCommand {
    public VampirismCommand() {
        if (VampirismMod.inDev) {
            this.aliases.add("v");
        }
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public boolean canCommandSenderUseCommand(ICommandSender var1) {
                return VampirismCommand.this.isSenderCreative(var1);
            }

            @Override
            public String getCommandName() {
                return "resetVampireLords";
            }

            @Override
            public void processCommand(ICommandSender var1, String[] var2) {
                if (var1 instanceof EntityPlayer) {
                    VampireLordData.get(((EntityPlayer)var1).field_70170_p).reset();
                }
            }

            @Override
            public String getCommandUsage(ICommandSender var1) {
                return this.getCommandName();
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public boolean canCommandSenderUseCommand(ICommandSender var1) {
                return true;
            }

            @Override
            public String getCommandName() {
                return "checkForVampireBiome";
            }

            @Override
            public void processCommand(ICommandSender var1, String[] var2) {
                if (!(var1 instanceof EntityPlayer)) {
                    return;
                }
                EntityPlayer p = (EntityPlayer)var1;
                if (Configs.disable_vampire_biome) {
                    p.func_146105_b((IChatComponent)new ChatComponentText("The Vampire Biome is disabled in the config file"));
                } else {
                    int maxDist = 5000;
                    if (var2.length > 0) {
                        try {
                            maxDist = Integer.parseInt(var2[0]);
                        }
                        catch (NumberFormatException e) {
                            Logger.w("CheckVampireBiome", "Failed to parse max dist %s", var2[0]);
                        }
                        if (!(maxDist <= 10000 || var2.length > 1 && "yes".equals(var2[1]))) {
                            p.func_145747_a((IChatComponent)new ChatComponentText("This will take a looong time. Please use '/" + this.getCommandUsage(var1) + " yes', if you are sure"));
                            return;
                        }
                    }
                    p.func_146105_b((IChatComponent)new ChatComponentTranslation("text.vampirism.biome.looking_for_biome", new Object[0]));
                    ChunkCoordIntPair pos = WorldGenVampirism.castleGenerator.findNearVampireBiome(p.field_70170_p, MathHelper.func_76128_c((double)p.field_70165_t), MathHelper.func_76128_c((double)p.field_70161_v), maxDist, var1);
                    if (pos == null) {
                        p.func_146105_b((IChatComponent)new ChatComponentTranslation("text.vampirism.biome.not_found", new Object[0]));
                    } else if (p.field_71075_bZ.field_75098_d) {
                        p.func_146105_b(new ChatComponentTranslation("text.vampirism.biome.found", new Object[0]).func_150257_a((IChatComponent)new ChatComponentText("[" + (pos.field_77276_a << 4) + "," + (pos.field_77275_b << 4) + "]")));
                    } else {
                        p.func_146105_b((IChatComponent)new ChatComponentTranslation("text.vampirism.biome.found", new Object[0]));
                    }
                }
            }

            @Override
            public String getCommandUsage(ICommandSender var1) {
                return this.getCommandName() + " <maxRadius>";
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public boolean canCommandSenderUseCommand(ICommandSender var1) {
                return true;
            }

            @Override
            public String getCommandName() {
                return "changelog";
            }

            @Override
            public void processCommand(ICommandSender var1, String[] var2) {
                if (VersionChecker.newVersion == null) {
                    var1.func_145747_a((IChatComponent)new ChatComponentText("There is no new version available"));
                    return;
                }
                List<String> changes = VersionChecker.newVersion.getChangeLog();
                var1.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Vampirism " + VersionChecker.newVersion.getModVersion() + "(" + VersionChecker.newVersion.getMcVersion() + ")"));
                for (String c : changes) {
                    var1.func_145747_a((IChatComponent)new ChatComponentText("-" + c));
                }
                var1.func_145747_a((IChatComponent)new ChatComponentText(""));
                IChatComponent component = IChatComponent.Serializer.func_150699_a((String)VersionChecker.addVersionInfo(StatCollector.func_74838_a((String)"text.vampirism.update_message")));
                var1.func_145747_a(component);
            }

            @Override
            public String getCommandUsage(ICommandSender var1) {
                return this.getCommandName();
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public boolean canCommandSenderUseCommand(ICommandSender var1) {
                return VampirismCommand.this.isSenderCreative(var1);
            }

            @Override
            public String getCommandName() {
                return "lord_offline_time";
            }

            @Override
            public void processCommand(ICommandSender var1, String[] var2) {
                var1.func_145747_a((IChatComponent)new ChatComponentText("Current lord has been offline for " + VampireLordData.get(var1.func_130014_f_()).getCurrentLordOfflineTime() + " ticks"));
            }

            @Override
            public String getCommandUsage(ICommandSender var1) {
                return this.getCommandName();
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public boolean canCommandSenderUseCommand(ICommandSender var1) {
                return true;
            }

            @Override
            public String getCommandName() {
                return "currentDimension";
            }

            @Override
            public void processCommand(ICommandSender var1, String[] var2) {
                if (var1 instanceof EntityPlayer) {
                    EntityPlayer p = (EntityPlayer)var1;
                    if (p.field_70170_p != null) {
                        var1.func_145747_a((IChatComponent)new ChatComponentText("Dimension ID: " + p.field_70170_p.field_73011_w.field_76574_g));
                    }
                }
            }

            @Override
            public String getCommandUsage(ICommandSender var1) {
                return this.getCommandName();
            }
        });
    }

    public String func_71517_b() {
        return "vampirism";
    }

    public boolean isSenderCreative(ICommandSender sender) {
        if (VampirismMod.inDev) {
            return true;
        }
        return sender.func_70003_b(2, this.func_71517_b());
    }
}

