/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.teamlapen.vampirism.Achievements;
import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.GuiHandler;
import de.teamlapen.vampirism.ModBiomes;
import de.teamlapen.vampirism.ModBlocks;
import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.ModPotion;
import de.teamlapen.vampirism.SummonCommand;
import de.teamlapen.vampirism.TestCommand;
import de.teamlapen.vampirism.VampirismCommand;
import de.teamlapen.vampirism.castleDim.WorldProviderCastle;
import de.teamlapen.vampirism.entity.convertible.BiteableRegistry;
import de.teamlapen.vampirism.entity.player.skills.Skills;
import de.teamlapen.vampirism.generation.WorldGenVampirism;
import de.teamlapen.vampirism.generation.castle.CastleGenerator;
import de.teamlapen.vampirism.generation.villages.VillageBiomes;
import de.teamlapen.vampirism.generation.villages.VillageCreationHandler;
import de.teamlapen.vampirism.generation.villages.VillageGenReplacer;
import de.teamlapen.vampirism.generation.villages.VillageModChurchPiece;
import de.teamlapen.vampirism.guide.VampirismGuide;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.network.RenderScreenRedPacket;
import de.teamlapen.vampirism.network.RequestEntityUpdatePacket;
import de.teamlapen.vampirism.network.SpawnCustomParticlePacket;
import de.teamlapen.vampirism.network.SpawnParticlePacket;
import de.teamlapen.vampirism.network.UpdateEntityPacket;
import de.teamlapen.vampirism.proxy.IProxy;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.util.SunDmgHelper;
import de.teamlapen.vampirism.util.SupporterManager;
import de.teamlapen.vampirism.util.VersionChecker;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.DamageSource;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="vampirism", name="Vampirism", version="0.7.9", acceptedMinecraftVersions="[1.7.10]", dependencies="required-after:Forge@[10.13.4.1448,)", guiFactory="de.teamlapen.vampirism.client.gui.ModGuiFactory")
public class VampirismMod {
    @Mod.Instance(value="vampirism")
    public static VampirismMod instance;
    @SidedProxy(clientSide="de.teamlapen.vampirism.proxy.ClientProxy", serverSide="de.teamlapen.vampirism.proxy.ServerProxy")
    public static IProxy proxy;
    public static SimpleNetworkWrapper modChannel;
    public static boolean inDev;
    public static boolean potionFail;
    public static boolean vampireCastleFail;
    public static int castleDimensionId;
    public static CreativeTabs tabVampirism;
    public static DamageSource sunDamage;
    public static DamageSource garlicDamage;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        castleDimensionId = DimensionManager.getNextFreeDimId();
        DimensionManager.registerProviderType((int)castleDimensionId, WorldProviderCastle.class, (boolean)false);
        DimensionManager.registerDimension((int)castleDimensionId, (int)castleDimensionId);
        SunDmgHelper.specifySundamageForDim(castleDimensionId, false);
        proxy.registerEntitys();
        proxy.registerRenderer();
        Achievements.registerAchievements();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenVampirism(), (int)1000);
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageCreationHandler());
        MapGenStructureIO.func_143031_a(VillageModChurchPiece.class, (String)"ViVMC");
        proxy.registerSubscriptions();
        FMLCommonHandler.instance().bus().register((Object)new Configs());
        WeightedRandomChestContent garlicChest = new WeightedRandomChestContent(new ItemStack((Item)ModItems.garlic), 1, 15, 100);
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)garlicChest);
        ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)garlicChest);
        ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)garlicChest);
        if (Configs.village_gen_enabled) {
            Logger.i("Init", "Registering replacer for village generation.", new Object[0]);
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new VillageGenReplacer());
        }
        if (!Loader.isModLoaded((String)"VersionChecker")) {
            VersionChecker.execute();
        }
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"de.teamlapen.vampirism.WailaDataProvider.callbackRegister");
        SupporterManager.getInstance().initAsync();
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new TestCommand());
        e.registerServerCommand((ICommand)new SummonCommand());
        e.registerServerCommand((ICommand)new VampirismCommand());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        VillageBiomes.postInit(event);
        BiteableRegistry.finishRegistration();
        String potion = ModPotion.checkPotions();
        if (potion != null) {
            Logger.e("PostInit", "Not all potions were successfully added {%s}", potion);
            potionFail = true;
        }
        if (Loader.isModLoaded((String)"guideapi")) {
            Logger.d("PostInit", "Found Guide-API -> Registering guide book", new Object[0]);
            VampirismMod.registerGuideBook();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            inDev = true;
            Logger.inDev = true;
        }
        Configs.init(event.getModConfigurationDirectory(), inDev);
        Helper.Obfuscation.fillMap();
        ModPotion.init();
        ModBlocks.init();
        ModItems.init();
        ModBiomes.init();
        ModBlocks.registerRecipes();
        ModItems.registerRecipes();
        proxy.registerKeyBindings();
        this.setupNetwork();
        VillageBiomes.preInit(event);
        CastleGenerator.loadTiles();
        Skills.registerDefaultSkills();
        FMLInterModComms.sendRuntimeMessage((Object)"vampirism", (String)"VersionChecker", (String)"addVersionCheck", (String)"http://maxanier.de/projects/vampirism/versions.json");
    }

    private void setupNetwork() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        modChannel = NetworkRegistry.INSTANCE.newSimpleChannel("vampirism");
        int id = 0;
        modChannel.registerMessage(InputEventPacket.Handler.class, InputEventPacket.class, id++, Side.SERVER);
        modChannel.registerMessage(SpawnParticlePacket.Handler.class, SpawnParticlePacket.class, id++, Side.CLIENT);
        modChannel.registerMessage(SpawnCustomParticlePacket.Handler.class, SpawnCustomParticlePacket.class, id++, Side.CLIENT);
        modChannel.registerMessage(RenderScreenRedPacket.Handler.class, RenderScreenRedPacket.class, id++, Side.CLIENT);
        modChannel.registerMessage(UpdateEntityPacket.Handler.class, UpdateEntityPacket.class, id++, Side.CLIENT);
        modChannel.registerMessage(RequestEntityUpdatePacket.Handler.class, RequestEntityUpdatePacket.class, id++, Side.SERVER);
    }

    @Optional.Method(modid="guideapi")
    private static void registerGuideBook() {
        VampirismGuide.registerGuide();
    }

    static {
        inDev = false;
        potionFail = false;
        vampireCastleFail = false;
        tabVampirism = new CreativeTabs("vampirism"){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return ModItems.leechSword;
            }
        };
        sunDamage = new DamageSource("sun").func_76348_h().func_82726_p();
        garlicDamage = new DamageSource("garlic").func_76348_h().func_82726_p();
    }
}

