/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.entity.EntityDefaultVampire;
import de.teamlapen.vampirism.entity.EntityHunterBase;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeGarlic;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeSun;
import de.teamlapen.vampirism.entity.ai.VampireAIMoveToBiteable;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.util.BALANCE;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityVampire
extends EntityDefaultVampire {
    private boolean inCastle = false;
    private int bloodtimer = 100;

    public EntityVampire(World par1World) {
        super(par1World);
        this.hasArms = true;
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityHunterBase.class, (float)BALANCE.MOBPROP.VAMPIRE_DISTANCE_HUNTER, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new VampireAIFleeSun(this, (double)0.9f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new VampireAIFleeGarlic(this, (double)0.9f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new VampireAIMoveToBiteable(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityHunterBase.class, 8.0f));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                if (entity instanceof EntityPlayer) {
                    return VampirePlayer.get((EntityPlayer)entity).getLevel() <= BALANCE.VAMPIRE_FRIENDLY_LEVEL || !EntityVampire.this.isInCastle() && VampirePlayer.get((EntityPlayer)entity).isVampireLord();
                }
                return false;
            }
        }));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(BALANCE.MOBPROP.VAMPIRE_MAX_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(BALANCE.MOBPROP.VAMPIRE_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BALANCE.MOBPROP.VAMPIRE_MOVEMENT_SPEED);
    }

    public void func_70645_a(DamageSource s) {
        if (s.func_76346_g() != null && s.func_76346_g() instanceof EntityPlayer) {
            this.func_145779_a(ModItems.vampireFang, 1);
        }
    }

    public void makeCastleVampire() {
        this.inCastle = true;
    }

    public boolean isInCastle() {
        return this.inCastle;
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodtimer == 0;
    }

    @Override
    public void addBlood(int amt) {
        super.addBlood(amt);
        this.bloodtimer += amt * 40 + this.field_70146_Z.nextInt(10) * 20;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.bloodtimer > 0) {
            --this.bloodtimer;
        }
    }
}

