/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.entity.EntityGarlicBomb;
import de.teamlapen.vampirism.entity.EntityHunterBase;
import de.teamlapen.vampirism.entity.EntityVampireBase;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.network.ISyncable;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.SupporterManager;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityVampireHunter2
extends EntityHunterBase
implements ISyncable,
IRangedAttackMob {
    private String textureName;
    private int type;
    private final int MAX_TYPES = 3;
    private static final String TAG = "Hunter2";
    private String senderName;
    private int outfit;
    private boolean renderDefaultWeapons = true;
    private EntityAIBase arrowAttackTask = new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 60, 13.0f);
    private EntityAIBase collideAttackTask = new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.1, false);
    private EntityAIAvoidEntity fleeTask = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 16.0f, 0.8, 1.5);

    public String getSenderName() {
        return this.senderName;
    }

    public String getTextureName() {
        return this.textureName;
    }

    public boolean shouldRenderDefaultWeapons() {
        return this.renderDefaultWeapons;
    }

    public EntityVampireHunter2(World world) {
        super(world);
        this.hasArms = true;
        this.func_70661_as().func_75498_b(true);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 14.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityVampireBase.class, 12.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                if (entity instanceof EntityPlayer) {
                    return VampirePlayer.get((EntityPlayer)entity).getLevel() > BALANCE.VAMPIRE_HUNTER_ATTACK_LEVEL;
                }
                return false;
            }
        }));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVampireBase.class, 0, true));
        this.outfit = this.func_70681_au().nextInt(64);
        SupporterManager.Supporter s = SupporterManager.getInstance().getRandom(this.func_70681_au());
        this.textureName = s.textureName;
        this.senderName = s.senderName;
        if (Configs.disable_supporter_hunter_names) {
            this.senderName = null;
        }
        this.updateType(this.func_70681_au().nextInt(3));
        this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 10000, 1));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70718_bc > 0 && this.func_70681_au().nextInt(100) == 0 && this.func_70638_az() != null) {
            Helper.spawnEntityBehindEntity(this.func_70638_az(), "vampirism.vampireHunter");
        }
    }

    @Override
    protected void attackedEntityAsMob(EntityLivingBase entity) {
        super.attackedEntityAsMob(entity);
        if (this.func_70681_au().nextBoolean()) {
            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 40, 10));
            if (this.func_70681_au().nextBoolean()) {
                entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 50));
            }
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateEntityAttributes();
    }

    protected void updateEntityAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(BALANCE.MOBPROP.VAMPIRE_HUNTER2_MAX_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(BALANCE.MOBPROP.VAMPIRE_HUNTER2_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(BALANCE.MOBPROP.VAMPIRE_HUNTER2_MOVEMENT_SPEED);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("textureName", this.textureName);
        nbt.func_74778_a("senderName", this.senderName == null ? "null" : this.senderName);
        nbt.func_74768_a("outfit", this.outfit);
        nbt.func_74768_a("type", this.type);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.loadUpdateFromNBT(nbt);
    }

    protected void updateType(int type) {
        this.field_70714_bg.func_85156_a(this.arrowAttackTask);
        this.field_70714_bg.func_85156_a(this.collideAttackTask);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.fleeTask);
        this.func_70062_b(0, null);
        this.renderDefaultWeapons = false;
        if (type == 0) {
            this.renderDefaultWeapons = true;
            this.field_70714_bg.func_75776_a(2, this.collideAttackTask);
        } else if (type == 1) {
            this.func_70062_b(0, new ItemStack((Item)ModItems.garlicBomb));
            this.field_70714_bg.func_75776_a(2, this.arrowAttackTask);
        } else if (type == 2) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.fleeTask);
        }
        this.type = type;
    }

    public boolean func_94059_bO() {
        return true;
    }

    protected Item func_146068_u() {
        return null;
    }

    @Override
    public void loadUpdateFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("textureName")) {
            this.textureName = nbt.func_74779_i("textureName");
        }
        if (nbt.func_74764_b("senderName")) {
            this.senderName = nbt.func_74779_i("senderName");
            if (this.senderName.equals("null")) {
                this.senderName = null;
            }
        }
        if (nbt.func_74764_b("type")) {
            this.updateType(nbt.func_74762_e("type"));
        }
        if (nbt.func_74764_b("outfit")) {
            this.outfit = nbt.func_74762_e("outfit");
        }
    }

    public int getOutfit(int part) {
        return this.outfit >> part * 3;
    }

    @Override
    public void writeFullUpdateToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("senderName", this.senderName == null ? "null" : this.senderName);
        nbt.func_74778_a("textureName", this.textureName);
        nbt.func_74768_a("type", this.type);
        nbt.func_74768_a("outfit", this.outfit);
    }

    public String func_70005_c_() {
        return this.senderName == null ? super.func_70005_c_() : this.senderName;
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        EntityGarlicBomb garlicBomb = new EntityGarlicBomb(this.field_70170_p, (EntityLivingBase)this);
        garlicBomb.field_70125_A -= -20.0f;
        double d0 = p_82196_1_.field_70165_t + p_82196_1_.field_70159_w - this.field_70165_t;
        double d1 = p_82196_1_.field_70163_u + (double)p_82196_1_.func_70047_e() - (double)1.1f - this.field_70163_u;
        double d2 = p_82196_1_.field_70161_v + p_82196_1_.field_70179_y - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        garlicBomb.func_70186_c(d0, d1 + (double)(f1 * 0.2f), d2, 0.75f, 8.0f);
        this.field_70170_p.func_72838_d((Entity)garlicBomb);
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

