/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.util.Helper;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class EntityVampirism
extends EntityCreature {
    protected boolean hasArms = false;
    protected boolean peaceful = false;
    private AxisAlignedBB home;
    protected boolean saveHome = false;

    public EntityVampirism(World p_i1595_1_) {
        super(p_i1595_1_);
    }

    public boolean func_110175_bO() {
        return this.home != null;
    }

    protected void attackedEntityAsMob(EntityLivingBase entity) {
    }

    public void func_70636_d() {
        if (this.hasArms) {
            this.func_82168_bl();
        }
        super.func_70636_d();
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && type == EnumCreatureType.monster) {
            return true;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.peaceful && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void setHome(AxisAlignedBB home) {
        this.home = home;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (super.func_70097_a(p_70097_1_, p_70097_2_)) {
            Entity entity = p_70097_1_.func_76346_g();
            if (entity instanceof EntityLivingBase) {
                this.func_70784_b(entity);
            }
            return true;
        }
        return false;
    }

    protected String func_145776_H() {
        return "game.hostile.swim";
    }

    protected String func_145777_O() {
        return "game.hostile.swim.splash";
    }

    protected String func_70621_aR() {
        return "game.hostile.hurt";
    }

    protected String func_70673_aS() {
        return "game.hostile.die";
    }

    protected String func_146067_o(int p_146067_1_) {
        return p_146067_1_ > 4 ? "game.hostile.hurt.fall.big" : "game.hostile.hurt.fall.small";
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            i += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entity.func_70015_d(j * 4);
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
            if (entity instanceof EntityLivingBase) {
                this.attackedEntityAsMob((EntityLivingBase)entity);
            }
        }
        return flag;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70601_bi() {
        return (this.peaceful || this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) && super.func_70601_bi();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected boolean func_146066_aG() {
        return true;
    }

    protected void teleportAway() {
        this.func_82142_c(true);
        Helper.spawnParticlesAroundEntity((EntityLivingBase)this, "portal", 5.0, 64);
        this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        this.func_70106_y();
    }

    public boolean isWithinHomeDistance(double x, double y, double z) {
        if (this.home != null) {
            return this.home.func_72318_a(Vec3.func_72443_a((double)x, (double)y, (double)z));
        }
        return true;
    }

    public boolean func_110173_bK() {
        return this.isWithinHomeDistance(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_110176_b(int p_110176_1_, int p_110176_2_, int p_110176_3_) {
        return this.isWithinHomeDistance(p_110176_1_, p_110176_2_, p_110176_3_);
    }

    public void func_110171_b(int x, int y, int z, int r) {
        this.setHome(AxisAlignedBB.func_72330_a((double)(x - r), (double)(y - r), (double)(z - r), (double)(x + r), (double)(y + r), (double)(z + r)));
    }

    public ChunkCoordinates func_110172_bL() {
        if (!this.func_110175_bO()) {
            return new ChunkCoordinates(0, 0, 0);
        }
        ChunkCoordinates center = new ChunkCoordinates(0, 0, 0);
        center.field_71574_a = (int)(this.home.field_72340_a + (this.home.field_72336_d - this.home.field_72340_a) / 2.0);
        center.field_71572_b = (int)(this.home.field_72338_b + (this.home.field_72337_e - this.home.field_72338_b) / 2.0);
        center.field_71573_c = (int)(this.home.field_72339_c + (this.home.field_72334_f - this.home.field_72339_c) / 2.0);
        return center;
    }

    public void func_110177_bN() {
        this.home = null;
    }

    protected void func_70626_be() {
    }

    public AxisAlignedBB getHome() {
        return this.home;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.saveHome && this.func_110175_bO()) {
            int[] h = new int[]{(int)this.home.field_72340_a, (int)this.home.field_72338_b, (int)this.home.field_72339_c, (int)this.home.field_72336_d, (int)this.home.field_72337_e, (int)this.home.field_72334_f};
            nbt.func_74783_a("home", h);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("home")) {
            this.saveHome = true;
            int[] h = nbt.func_74759_k("home");
            this.home = AxisAlignedBB.func_72330_a((double)h[0], (double)h[1], (double)h[2], (double)h[3], (double)h[4], (double)h[5]);
        }
    }
}

