/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai;

import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.entity.minions.EntityRemoteVampireMinion;
import de.teamlapen.vampirism.entity.minions.IMinion;
import de.teamlapen.vampirism.entity.minions.IMinionLord;
import de.teamlapen.vampirism.entity.minions.MinionHelper;
import de.teamlapen.vampirism.item.ItemBloodBottle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MinionAIMoveToLord
extends EntityAIBase {
    public static final int TELEPORT_SQ_DISTANCE = 25;
    private final IMinion minion;
    private EntityLivingBase lord;
    private boolean avoidWater;
    private int updateTicks;

    public MinionAIMoveToLord(IMinion m) {
        this.minion = m;
        this.func_75248_a(1);
    }

    protected boolean canTeleport() {
        return false;
    }

    public boolean func_75253_b() {
        if (!this.canTeleport() && this.minion.getRepresentingEntity().func_70661_as().func_75500_f()) {
            return false;
        }
        if (this.minion.getRepresentingEntity().func_70068_e((Entity)this.lord) < 25.0) {
            return false;
        }
        return !this.lord.field_70128_L && MinionHelper.isLordSafe(this.minion, (Entity)this.lord);
    }

    public void func_75251_c() {
        this.lord = null;
        this.minion.getRepresentingEntity().func_70661_as().func_75491_a(this.avoidWater);
    }

    public boolean func_75250_a() {
        IMinionLord l = this.minion.getLord();
        if (l != null && this.minion.getRepresentingEntity().func_70068_e((Entity)l.getRepresentingEntity()) > 25.0 && this.shouldMove(this.minion)) {
            this.lord = l.getRepresentingEntity();
            return true;
        }
        return false;
    }

    protected boolean shouldMove(IMinion m) {
        return true;
    }

    public void func_75249_e() {
        this.minion.getRepresentingEntity().func_70661_as().func_75497_a((Entity)this.lord, 1.0);
        this.avoidWater = this.minion.getRepresentingEntity().func_70661_as().func_75486_a();
        this.minion.getRepresentingEntity().func_70661_as().func_75491_a(false);
    }

    public void func_75246_d() {
        this.minion.getRepresentingEntity().func_70671_ap().func_75651_a((Entity)this.lord, 10.0f, (float)this.minion.getRepresentingEntity().func_70646_bf());
        if (--this.updateTicks <= 0) {
            this.updateTicks = 10;
            if (!this.minion.getRepresentingEntity().func_70661_as().func_75497_a((Entity)this.lord, 1.0) && this.minion.getRepresentingEntity().func_70068_e((Entity)this.lord) > 25.0) {
                int x = MathHelper.func_76128_c((double)this.lord.field_70165_t) - 2;
                int z = MathHelper.func_76128_c((double)this.lord.field_70161_v) - 2;
                int y = MathHelper.func_76128_c((double)this.lord.field_70121_D.field_72338_b);
                for (int dx = 0; dx <= 4; ++dx) {
                    for (int dz = 0; dz <= 4; ++dz) {
                        if (dx >= 1 && dz >= 1 && dx <= 3 && dz <= 3 || !World.func_147466_a((IBlockAccess)this.lord.field_70170_p, (int)(x + dx), (int)(y - 1), (int)(z + dz)) || this.lord.field_70170_p.func_147439_a(x + dx, y, z + dz).func_149721_r() || this.lord.field_70170_p.func_147439_a(x + dx, y + 1, z + dz).func_149721_r()) continue;
                        this.minion.getRepresentingEntity().func_70012_b((double)((float)(x + dx) + 0.5f), (double)y, (double)((float)(z + dz) + 0.5f), MathHelper.func_76142_g((float)(this.lord.field_70177_z + 180.0f)), MathHelper.func_76142_g((float)(this.lord.field_70125_A + 180.0f)));
                        this.minion.getRepresentingEntity().func_70661_as().func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    public static class MinionAIBringBottle
    extends MinionAIMoveToLord {
        public MinionAIBringBottle(EntityRemoteVampireMinion minion) {
            super(minion);
        }

        @Override
        public boolean canTeleport() {
            return true;
        }

        @Override
        protected boolean shouldMove(IMinion m) {
            ItemStack stack = m.getRepresentingEntity().func_71124_b(0);
            if (stack != null && stack.func_77973_b().equals((Object)ModItems.bloodBottle)) {
                return ItemBloodBottle.getBlood(stack) == 19;
            }
            return stack == null;
        }
    }
}

