/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.convertible;

import cpw.mods.fml.common.FMLCommonHandler;
import de.teamlapen.vampirism.client.render.TextureHelper;
import de.teamlapen.vampirism.entity.convertible.BiteableEntry;
import de.teamlapen.vampirism.entity.convertible.ConvertingHandler;
import de.teamlapen.vampirism.entity.convertible.EntityConvertedCreature;
import de.teamlapen.vampirism.util.Logger;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import org.eclipse.jdt.annotation.Nullable;

public class BiteableRegistry {
    private static final Map<String, Integer> bloodValues = new HashMap<String, Integer>();
    private static final Map<String, Integer> overridingValues = new HashMap<String, Integer>();
    private static final Map<Class<? extends EntityCreature>, ConvertingHandler> convertibles = new HashMap<Class<? extends EntityCreature>, ConvertingHandler>();
    private static boolean finished = false;
    private static final String TAG = "BiteableRegistry";
    private static final Map<String, BiteableEntry> biteables = new HashMap<String, BiteableEntry>();

    public static void addBloodValues(Map<String, Integer> values) {
        bloodValues.putAll(values);
    }

    public static void overrideBloodValues(Map<String, Integer> values) {
        overridingValues.putAll(values);
    }

    public static void addConvertible(Class<? extends EntityCreature> clazz, String overlay_loc) {
        BiteableRegistry.addConvertible(clazz, overlay_loc, null);
    }

    public static void addConvertible(Class<? extends EntityCreature> clazz, String overlay_loc, ConvertingHandler handler) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            TextureHelper.registerConvertedOverlay(clazz, overlay_loc);
        }
        convertibles.put(clazz, handler);
    }

    @Nullable
    public static EntityConvertedCreature convert(EntityCreature entity) {
        String s = EntityList.func_75621_b((Entity)entity);
        BiteableEntry b = biteables.get(s);
        if (b != null && b.convertible) {
            return b.convertingHandler.createFrom(entity);
        }
        Logger.e(TAG, "Failed to find convertible entry for %s", entity);
        return null;
    }

    public static BiteableEntry getEntry(EntityCreature creature) {
        return BiteableRegistry.getEntry(EntityList.func_75621_b((Entity)creature));
    }

    public static BiteableEntry getEntry(String entity_name) {
        return biteables.get(entity_name);
    }

    public static void finishRegistration() {
        if (finished) {
            return;
        }
        bloodValues.putAll(overridingValues);
        float bloodValueMultiplier = 1.0f;
        Integer i = bloodValues.get("multiplier");
        if (i != null) {
            bloodValueMultiplier = (float)i.intValue() / 10.0f;
        }
        ConvertingHandler defaultHandler = new ConvertingHandler();
        for (Map.Entry<Class<? extends EntityCreature>, ConvertingHandler> entry : convertibles.entrySet()) {
            String entity_name = (String)EntityList.field_75626_c.get(entry.getKey());
            if (entity_name == null) {
                Logger.w(TAG, "Cannot register convertible %s since there is no EntityString for it", entry.getKey());
                continue;
            }
            Integer blood = bloodValues.remove(entity_name);
            if (blood == null) {
                Logger.w(TAG, "Missing blood value for convertible creature %s (%s)", entry.getKey().getName(), entity_name);
                continue;
            }
            blood = Math.round((float)blood.intValue() * bloodValueMultiplier);
            Logger.t("Registering convertible %s with blood %d and handler %s", entry.getKey().getName(), blood, entry.getValue());
            BiteableEntry biteEntry = new BiteableEntry(blood, entry.getValue() == null ? defaultHandler : entry.getValue());
            biteables.put(entity_name, biteEntry);
        }
        for (Map.Entry<Object, Object> entry : bloodValues.entrySet()) {
            biteables.put((String)entry.getKey(), new BiteableEntry(Math.abs(Math.round((float)((Integer)entry.getValue()).intValue() * bloodValueMultiplier))));
        }
        bloodValues.clear();
        convertibles.clear();
        finished = true;
    }
}

