/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.convertible;

import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.entity.ai.VVillagerAILookAtCustomer;
import de.teamlapen.vampirism.entity.ai.VVillagerAITrade;
import de.teamlapen.vampirism.entity.ai.VampireAIMoveIndoors;
import de.teamlapen.vampirism.entity.convertible.ConvertingHandler;
import de.teamlapen.vampirism.entity.convertible.EntityConvertedCreature;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import java.util.Collections;
import java.util.Random;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class EntityConvertedVillager
extends EntityConvertedCreature
implements IMerchant {
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitilization;

    public EntityConvertedVillager(World world) {
        super(world);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new VVillagerAILookAtCustomer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new VVillagerAITrade(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new VampireAIMoveIndoors(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, false));
    }

    protected String func_70639_aQ() {
        return this.isTrading() ? "mob.villager.haggle" : "mob.villager.idle";
    }

    @Override
    protected String func_70621_aR() {
        return "mob.villager.hit";
    }

    @Override
    protected String func_70673_aS() {
        return "mob.villager.death";
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public void func_70932_a_(EntityPlayer player) {
        this.buyingPlayer = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    if (this.buyingList.size() > 1) {
                        for (MerchantRecipe merchantrecipe : this.buyingList) {
                            if (!merchantrecipe.func_82784_g()) continue;
                            merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                        }
                    }
                    this.addDefaultEquipmentAndRecipies(1);
                    this.needsInitilization = false;
                }
                this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 200, 0));
            }
        }
    }

    public MerchantRecipeList func_70934_b(EntityPlayer p_70934_1_) {
        if (this.buyingList == null) {
            this.addDefaultEquipmentAndRecipies(1);
        }
        return this.buyingList;
    }

    private void addDefaultEquipmentAndRecipies(int i) {
        MerchantRecipeList merchantRecipeList = new MerchantRecipeList();
        EntityConvertedVillager.addRecipe(merchantRecipeList, new ItemStack((Item)ModItems.humanHeart, 9), 2, this.func_70681_au(), 0.5f);
        EntityConvertedVillager.addRecipe(merchantRecipeList, 3, new ItemStack((Item)ModItems.humanHeart, 9), this.func_70681_au(), 0.5f);
        EntityConvertedVillager.addRecipe(merchantRecipeList, 1, new ItemStack((Item)ModItems.leechSword, 1), this.func_70681_au(), 0.3f);
        EntityConvertedVillager.addRecipe(merchantRecipeList, 1, new ItemStack((Item)ModItems.bloodBottle, 3, 19), this.field_70146_Z, 0.9f);
        Collections.shuffle(merchantRecipeList);
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        for (int l = 0; l < i && l < merchantRecipeList.size(); ++l) {
            this.buyingList.func_77205_a((MerchantRecipe)merchantRecipeList.get(l));
        }
    }

    public void func_70930_a(MerchantRecipeList p_70930_1_) {
    }

    public static void addRecipe(MerchantRecipeList list, ItemStack item, int emeralds, Random rnd, float prop) {
        if (rnd.nextFloat() < prop) {
            list.add((Object)new MerchantRecipe(item, new ItemStack(Items.field_151166_bC, emeralds)));
        }
    }

    public static void addRecipe(MerchantRecipeList list, int emeralds, ItemStack item, Random rnd, float prop) {
        if (rnd.nextFloat() < prop) {
            list.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, emeralds), item));
        }
    }

    public void func_70933_a(MerchantRecipe p_70933_1_) {
        p_70933_1_.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_85030_a("mob.villager.yes", this.func_70599_aP(), this.func_70647_i());
        if (p_70933_1_.func_77393_a((MerchantRecipe)this.buyingList.get(this.buyingList.size() - 1))) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
        }
    }

    public void func_110297_a_(ItemStack p_110297_1_) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            if (p_110297_1_ != null) {
                this.func_85030_a("mob.villager.yes", this.func_70599_aP(), this.func_70647_i());
            } else {
                this.func_85030_a("mob.villager.no", this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    public boolean func_70085_c(EntityPlayer p_70085_1_) {
        boolean flag;
        ItemStack itemstack = p_70085_1_.field_71071_by.func_70448_g();
        boolean bl = flag = itemstack != null && itemstack.func_77973_b() == Items.field_151063_bx;
        if (!(flag || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || p_70085_1_.func_70093_af() || VampirePlayer.get(p_70085_1_).getLevel() <= 0)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(p_70085_1_);
                p_70085_1_.func_71030_a((IMerchant)this, this.func_94057_bL());
            }
            return true;
        }
        return super.func_70085_c(p_70085_1_);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("Offers", 10)) {
            NBTTagCompound list = nbt.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(list);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.buyingList != null) {
            nbt.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
    }

    public static class VillagerConvertingHandler
    extends ConvertingHandler<EntityVillager> {
        @Override
        public EntityConvertedCreature createFrom(EntityVillager entity) {
            EntityConvertedVillager convertedCreature = new EntityConvertedVillager(entity.field_70170_p);
            this.copyImportantStuff(convertedCreature, entity);
            return convertedCreature;
        }

        @Override
        public double getConvertedSpeed(EntityVillager entity) {
            return 0.295;
        }

        @Override
        public void dropConvertedItems(EntityVillager entity, boolean recentlyHit, int looting) {
            entity.func_145779_a((Item)ModItems.weakVampireFang, 1);
        }
    }
}

