/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minions;

import de.teamlapen.vampirism.ModItems;
import de.teamlapen.vampirism.entity.ai.EntityAIMoveAround;
import de.teamlapen.vampirism.entity.ai.EntityAIWaitForBottle;
import de.teamlapen.vampirism.entity.ai.MinionAIMoveToLord;
import de.teamlapen.vampirism.entity.ai.VampireAIBiteNearbyEntity2;
import de.teamlapen.vampirism.entity.ai.VampireAIMoveToBiteable;
import de.teamlapen.vampirism.entity.minions.DefaultMinionCommand;
import de.teamlapen.vampirism.entity.minions.EntityRemoteVampireMinion;
import de.teamlapen.vampirism.entity.minions.IMinionLord;
import de.teamlapen.vampirism.item.ItemBloodBottle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.eclipse.jdt.annotation.NonNull;

public class CollectBloodCommand
extends DefaultMinionCommand {
    protected final EntityRemoteVampireMinion minion;
    protected final EntityAIBase runAround;
    protected final EntityAIBase runToPlayer;
    protected final EntityAIBase bite;
    protected final EntityAIBase moveToBiteable;
    protected final EntityAIBase waitForBottle;

    public CollectBloodCommand(int id, EntityRemoteVampireMinion m) {
        super(id);
        this.minion = m;
        this.runAround = new EntityAIMoveAround(m.getRepresentingEntity(), 1.0, false);
        this.runToPlayer = new MinionAIMoveToLord.MinionAIBringBottle(m);
        this.bite = new VampireAIBiteNearbyEntity2(m);
        this.moveToBiteable = new VampireAIMoveToBiteable(m);
        this.waitForBottle = new EntityAIWaitForBottle(m);
    }

    @Override
    public int getMinU() {
        return 48;
    }

    @Override
    public int getMinV() {
        return 0;
    }

    @Override
    public String getUnlocalizedName() {
        return "minioncommand.vampirism.collectblood";
    }

    @Override
    public void onActivated() {
        this.minion.setWantsBlood(true);
        this.minion.field_70714_bg.func_75776_a(9, this.runToPlayer);
        this.minion.field_70714_bg.func_75776_a(10, this.waitForBottle);
        this.minion.field_70714_bg.func_75776_a(11, this.bite);
        this.minion.field_70714_bg.func_75776_a(11, this.moveToBiteable);
        this.minion.field_70714_bg.func_75776_a(12, this.runAround);
    }

    @Override
    public void onDeactivated() {
        ItemStack item;
        IMinionLord l = this.minion.getLord();
        if (l != null && l.getRepresentingEntity().func_70068_e((Entity)this.minion) < 16.0 && (item = this.minion.getRepresentingEntity().func_71124_b(0)) != null && (item.func_77973_b().equals((Object)ModItems.bloodBottle) || item.func_77973_b().equals(Items.field_151069_bo))) {
            this.minion.getRepresentingEntity().func_70099_a(item, 0.1f);
            this.minion.getRepresentingEntity().func_70062_b(0, null);
        }
        this.minion.setWantsBlood(false);
        this.minion.field_70714_bg.func_85156_a(this.runToPlayer);
        this.minion.field_70714_bg.func_85156_a(this.bite);
        this.minion.field_70714_bg.func_85156_a(this.runAround);
        this.minion.field_70714_bg.func_85156_a(this.runToPlayer);
    }

    @Override
    public boolean shouldPickupItem(@NonNull ItemStack item) {
        if (item.func_77973_b().equals((Object)ModItems.bloodBottle) || item.func_77973_b().equals(Items.field_151069_bo)) {
            ItemStack old = this.minion.getRepresentingEntity().func_71124_b(0);
            if (old == null) {
                return true;
            }
            if (ItemBloodBottle.getBlood(item) < ItemBloodBottle.getBlood(old)) {
                return true;
            }
        }
        return false;
    }
}

