/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minions;

import de.teamlapen.vampirism.entity.ai.MinionAIFollowBoss;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeGarlic;
import de.teamlapen.vampirism.entity.minions.AttackHostileExceptPlayer;
import de.teamlapen.vampirism.entity.minions.AttackHostileIncludingPlayer;
import de.teamlapen.vampirism.entity.minions.DefendLordCommand;
import de.teamlapen.vampirism.entity.minions.EntityRemoteVampireMinion;
import de.teamlapen.vampirism.entity.minions.EntityVampireMinion;
import de.teamlapen.vampirism.entity.minions.IMinionCommand;
import de.teamlapen.vampirism.entity.minions.IMinionLord;
import de.teamlapen.vampirism.entity.minions.JustFollowCommand;
import de.teamlapen.vampirism.entity.minions.SaveableMinionHandler;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.util.Logger;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.eclipse.jdt.annotation.NonNull;

public class EntitySaveableVampireMinion
extends EntityVampireMinion {
    private static final String TAG = "SVampireMinion";
    protected IMinionLord lord;
    private final ArrayList<IMinionCommand> commands;

    public EntitySaveableVampireMinion(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new MinionAIFollowBoss(this, 1.0));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, (double)0.9f));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new VampireAIFleeGarlic(this, (double)0.9f));
        this.commands = new ArrayList();
        this.commands.add(this.getActiveCommand());
        this.commands.add(new AttackHostileExceptPlayer(1, this));
        this.commands.add(new AttackHostileIncludingPlayer(2, this));
        this.commands.add(new JustFollowCommand(3));
    }

    @Override
    public boolean func_70097_a(DamageSource src, float value) {
        if (DamageSource.field_76368_d.equals(src)) {
            return false;
        }
        return super.func_70097_a(src, value);
    }

    public void convertToRemote() {
        EntityRemoteVampireMinion remote = (EntityRemoteVampireMinion)EntityList.func_75620_a((String)"vampirism.vampireMinionR", (World)this.field_70170_p);
        remote.copyDataFromMinion(this);
        remote.func_70606_j(this.func_110143_aJ());
        remote.func_82149_j((Entity)this);
        IMinionLord lord = this.getLord();
        if (lord != null) {
            if (lord instanceof VampirePlayer) {
                lord.getMinionHandler().unregisterMinion(this);
                remote.setLord(lord);
            } else {
                Logger.w(TAG, "The converted minion %s cannot be controlled by this lord %s", remote, lord);
            }
        }
        this.field_70170_p.func_72838_d((Entity)remote);
        this.func_70106_y();
    }

    @Override
    public void func_82141_a(Entity from, boolean p) {
        super.func_82141_a(from, p);
        if (from instanceof EntitySaveableVampireMinion) {
            EntitySaveableVampireMinion m = (EntitySaveableVampireMinion)from;
            this.setLord(m.getLord());
            this.activateMinionCommand(m.getActiveCommand());
        }
    }

    @Override
    public ArrayList<IMinionCommand> getAvailableCommands() {
        return this.commands;
    }

    @Override
    public IMinionCommand getCommand(int id) {
        if (id < this.commands.size()) {
            return this.commands.get(id);
        }
        return null;
    }

    @Override
    @NonNull
    protected IMinionCommand getDefaultCommand() {
        return new DefendLordCommand(0, this);
    }

    @Override
    @Nullable
    public IMinionLord getLord() {
        return this.lord;
    }

    @Override
    protected void loadPartialUpdateFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("eid")) {
            Entity e = this.field_70170_p.func_73045_a(nbt.func_74762_e("eid"));
            if (e instanceof EntityPlayer) {
                this.lord = VampirePlayer.get((EntityPlayer)e);
                this.lord.getMinionHandler().registerMinion(this, true);
            } else if (e instanceof IMinionLord) {
                this.lord = (IMinionLord)e;
                this.lord.getMinionHandler().registerMinion(this, true);
            } else {
                Logger.w("EntityVampireMinion", "PartialUpdate: The given id(" + nbt.func_74762_e("eid") + ")[" + e + "] is no Minion Lord", new Object[0]);
                return;
            }
        }
    }

    public void onCall(SaveableMinionHandler.Call c) {
        switch (c) {
            case DEFEND_LORD: {
                this.activateMinionCommand(this.getCommand(0));
                break;
            }
            case ATTACK: {
                this.activateMinionCommand(this.getCommand(2));
                break;
            }
            case ATTACK_NON_PLAYER: {
                this.activateMinionCommand(this.getCommand(1));
                break;
            }
            case FOLLOW: {
                this.activateMinionCommand(this.getCommand(3));
            }
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.lord != null && !this.lord.isTheEntityAlive()) {
            this.lord = null;
            this.func_70097_a(DamageSource.field_76376_m, 1000.0f);
        }
        super.func_70636_d();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    public void func_70063_aa() {
    }

    @Override
    public void setLord(IMinionLord lord) {
        if (!lord.equals(this.lord)) {
            lord.getMinionHandler().registerMinion(this, true);
            this.lord = lord;
        }
    }

    @Override
    public boolean shouldBeSavedWithLord() {
        return true;
    }

    @Override
    protected void writeUpdateToNBT(NBTTagCompound nbt) {
        if (this.lord != null) {
            nbt.func_74768_a("eid", this.lord.getRepresentingEntity().func_145782_y());
        }
    }
}

