/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minions;

import de.teamlapen.vampirism.entity.EntityVampire;
import de.teamlapen.vampirism.entity.VampireMob;
import de.teamlapen.vampirism.entity.minions.EntityVampireMinion;
import de.teamlapen.vampirism.entity.minions.IMinion;
import de.teamlapen.vampirism.entity.minions.IMinionLord;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MinionHelper {
    public static IEntitySelector getEntitySelectorForMinion(final IMinion minion, final Class<? extends Entity> targetClass, final boolean selectPlayer, final boolean excludeVampires) {
        return new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                IMinion m = MinionHelper.getMinionFromEntity(entity);
                if (selectPlayer) {
                    if (MinionHelper.isLordSafe(m, minion.getLord())) {
                        return false;
                    }
                    if (MinionHelper.isLordSafe(minion, entity)) {
                        return false;
                    }
                    if (entity instanceof EntityPlayer) {
                        return true;
                    }
                } else {
                    if (entity instanceof EntityPlayer) {
                        return false;
                    }
                    if (MinionHelper.isLordPlayer(m)) {
                        return false;
                    }
                }
                if (excludeVampires && entity instanceof EntityVampire) {
                    IMinionLord l = minion.getLord();
                    return l != null && l instanceof VampirePlayer && ((VampirePlayer)l).isVampireLord();
                }
                return targetClass.isAssignableFrom(entity.getClass());
            }
        };
    }

    @Nullable
    public static IMinion getMinionFromEntity(Entity e) {
        VampireMob m;
        if (e instanceof IMinion) {
            return (IMinion)e;
        }
        if (e instanceof EntityCreature && (m = VampireMob.get((EntityCreature)e)).isMinion()) {
            return m;
        }
        return null;
    }

    public static List<VampireMob> getNearMobMinions(IMinionLord lord, int distance) {
        ArrayList<VampireMob> list = new ArrayList<VampireMob>();
        List list2 = lord.getRepresentingEntity().field_70170_p.func_72872_a(EntityCreature.class, lord.getRepresentingEntity().field_70121_D.func_72314_b((double)distance, (double)distance, (double)distance));
        for (Object o : list2) {
            VampireMob m = VampireMob.get((EntityCreature)o);
            if (!m.isMinion() || !MinionHelper.isLordSafe((IMinion)m, lord)) continue;
            list.add(m);
        }
        return list;
    }

    public static boolean isLordPlayer(@Nullable IMinion m) {
        return m != null && m.getLord() instanceof VampirePlayer;
    }

    public static boolean isLordSafe(@NonNull IMinion m, @Nullable Entity e) {
        IMinionLord l = m.getLord();
        return l != null && l.getRepresentingEntity().equals((Object)e);
    }

    public static boolean isLordSafe(@Nullable EntityLivingBase e, @NonNull IMinionLord l) {
        if (e == null) {
            return false;
        }
        if (e instanceof EntityVampireMinion) {
            return l.equals(((EntityVampireMinion)e).getLord());
        }
        if (e instanceof EntityCreature) {
            VampireMob m = VampireMob.get((EntityCreature)e);
            return m.isMinion() && l.equals(m.getLord());
        }
        return false;
    }

    public static boolean isLordSafe(@Nullable IMinion m, @Nullable IMinionLord l) {
        if (m == null || l == null) {
            return false;
        }
        return l.equals(m.getLord());
    }

    public static void sendMessageToLord(IMinion m, String ... message) {
        if (message == null || message.length < 1) {
            return;
        }
        IMinionLord l = m.getLord();
        if (l != null && l.getRepresentingEntity() instanceof EntityPlayer) {
            Object c1 = m.getRepresentingEntity().func_94056_bM() ? new ChatComponentText(m.getRepresentingEntity().func_94057_bL()) : new ChatComponentTranslation("text.vampirism.minion", new Object[0]);
            c1.func_150258_a(": ");
            c1.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
            Object c2 = message[0].startsWith("\\") ? new ChatComponentText(message[0].replace("\\", "")) : new ChatComponentTranslation(message[0], new Object[0]);
            for (int i = 1; i < message.length; ++i) {
                if (message[i].startsWith("\\")) {
                    c2.func_150257_a((IChatComponent)new ChatComponentText(message[i].replace("\\", "")));
                    continue;
                }
                c2.func_150257_a((IChatComponent)new ChatComponentTranslation(message[i], new Object[0]));
            }
            c1.func_150257_a((IChatComponent)c2);
            c2.func_150256_b().func_150238_a(EnumChatFormatting.WHITE);
            ((EntityPlayer)l.getRepresentingEntity()).func_146105_b((IChatComponent)c1);
        }
    }
}

