/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.castleDim.ChunkProviderCastle;
import de.teamlapen.vampirism.entity.player.PlayerModifiers;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.entity.player.skills.Skills;
import de.teamlapen.vampirism.item.GarlicHelper;
import de.teamlapen.vampirism.network.RequestEntityUpdatePacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.BlockEvent;

public class VampirePlayerEventHandler {
    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        if (VampirePlayer.get(event.entityPlayer).isSkillActive(Skills.batMode)) {
            event.setCanceled(true);
        } else {
            GarlicHelper.onPlayerAttackedEntity(event.entityPlayer, event.target);
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        try {
            if (VampirePlayer.get(event.player).isSkillActive(Skills.batMode) || event.player.field_70170_p.field_73011_w.field_76574_g == VampirismMod.castleDimensionId && !ChunkProviderCastle.allowedToBuildHere((Entity)event.player)) {
                event.setCanceled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (VampirePlayer.get(event.entityPlayer).isSkillActive(Skills.batMode) || event.entity.field_70170_p.field_73011_w.field_76574_g == VampirismMod.castleDimensionId && !ChunkProviderCastle.allowedToBuildHere(event.entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && VampirePlayer.get((EntityPlayer)event.entity) == null) {
            VampirePlayer.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            if (event.entity.field_70170_p.field_72995_K || event.entity.getClass().getName().equals("net.minecraft.client.entity.EntityClientPlayerMP")) {
                VampirismMod.modChannel.sendToServer((IMessage)new RequestEntityUpdatePacket(event.entity));
            } else {
                VampirePlayer.onPlayerJoinWorld((EntityPlayer)event.entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(PlayerUseItemEvent.Start event) {
        if (VampirePlayer.get(event.entityPlayer).isSkillActive(Skills.batMode)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.entityLiving instanceof EntityPlayer && VampirePlayer.get((EntityPlayer)event.entityLiving).onEntityAttacked(event.source, event.ammount)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayer) {
            VampirePlayer.get((EntityPlayer)event.entity).onDeath(event.source);
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)event.entity;
            PlayerModifiers.addJumpBoost(VampirePlayer.get(p).getLevel(), p);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            VampirePlayer.get((EntityPlayer)event.entity).onUpdate();
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        VampirePlayer.get(e.player).onChangedDimension(e.fromDim, e.toDim);
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        VampirePlayer.get(event.entityPlayer).copyFrom(event.original);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        VampirePlayer.get(e.player).onPlayerLoggedIn();
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        VampirePlayer.get(e.player).onPlayerLoggedOut();
    }

    @SubscribeEvent
    public void onPlayerName(PlayerEvent.NameFormat event) {
        if (event.entityPlayer != null && VampirePlayer.get(event.entityPlayer).isVampireLord()) {
            if (event.displayname == null) {
                event.displayname = event.username;
            }
            event.displayname = EnumChatFormatting.RED + StatCollector.func_74838_a((String)"text.vampirism.lord") + ": " + EnumChatFormatting.RESET + event.displayname;
        }
    }
}

