/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.entity.player.skills.BatSkill;
import de.teamlapen.vampirism.entity.player.skills.FreezeSkill;
import de.teamlapen.vampirism.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.player.skills.InvisibilitySkill;
import de.teamlapen.vampirism.entity.player.skills.RegenSkill;
import de.teamlapen.vampirism.entity.player.skills.ReviveFallenSkill;
import de.teamlapen.vampirism.entity.player.skills.SummonBatSkill;
import de.teamlapen.vampirism.entity.player.skills.TeleportSkill;
import de.teamlapen.vampirism.entity.player.skills.VampireRageSkill;
import de.teamlapen.vampirism.util.Logger;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;

public class Skills {
    public static ISkill vampireRage;
    public static ISkill batMode;
    private static final ArrayList<ISkill> skills;

    public static ArrayList<ISkill> getAvailableSkills(VampirePlayer player) {
        ArrayList<ISkill> sl = new ArrayList<ISkill>();
        for (ISkill s : skills) {
            if (1 != s.canUse(player, (EntityPlayer)player.getRepresentingEntity())) continue;
            sl.add(s);
        }
        return sl;
    }

    public static ISkill getSkill(int i) {
        try {
            return skills.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            Logger.e("Skills", "Skill with id " + i + " doesn't exist", new Object[0]);
            return null;
        }
    }

    public static int getSkillCount() {
        return skills.size();
    }

    public static void registerDefaultSkills() {
        vampireRage = Skills.registerSkill(new VampireRageSkill());
        Skills.registerSkill(new RegenSkill());
        Skills.registerSkill(new ReviveFallenSkill());
        batMode = Skills.registerSkill(new BatSkill());
        Skills.registerSkill(new SummonBatSkill());
        Skills.registerSkill(new InvisibilitySkill());
        Skills.registerSkill(new TeleportSkill());
        Skills.registerSkill(new FreezeSkill());
    }

    public static ISkill registerSkill(ISkill s) {
        int id = skills.size();
        s.setId(id);
        skills.add(s);
        return s;
    }

    static {
        skills = new ArrayList();
    }
}

