/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.generation.castle;

import de.teamlapen.vampirism.util.Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import org.eclipse.jdt.annotation.Nullable;

public class CastlePositionData
extends WorldSavedData {
    private static final String IDENTIFIER = "castle_positions";
    List<Position> positions = new LinkedList<Position>();
    List<Position> fullyGeneratedPositions = new LinkedList<Position>();
    boolean checked;
    private HashMap<ChunkCoordIntPair, Boolean> cachedChunks = new HashMap();

    public static CastlePositionData get(World world) {
        CastlePositionData data = (CastlePositionData)world.perWorldStorage.func_75742_a(CastlePositionData.class, IDENTIFIER);
        if (data == null) {
            data = new CastlePositionData(IDENTIFIER);
            world.perWorldStorage.func_75745_a(IDENTIFIER, (WorldSavedData)data);
        }
        return data;
    }

    public static void reset(World world) {
        CastlePositionData data = new CastlePositionData(IDENTIFIER);
        world.perWorldStorage.func_75745_a(IDENTIFIER, (WorldSavedData)data);
    }

    public CastlePositionData(String identifier) {
        super(identifier);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public Position findNearestCastle(int posX, int posZ) {
        int sd;
        int maxD = Integer.MAX_VALUE;
        Position pos = null;
        for (Position p : this.positions) {
            sd = (p.field_77276_a - (posX >> 4)) * (p.field_77276_a - (posX >> 4)) + (p.field_77275_b - (posZ >> 4)) * (p.field_77275_b - (posZ >> 4));
            if (sd >= maxD) continue;
            maxD = sd;
            pos = p;
        }
        for (Position p : this.fullyGeneratedPositions) {
            sd = (p.field_77276_a - (posX >> 4)) * (p.field_77276_a - (posX >> 4)) + (p.field_77275_b - (posZ >> 4)) * (p.field_77275_b - (posZ >> 4));
            if (sd >= maxD) continue;
            maxD = sd;
            pos = p;
        }
        return pos;
    }

    @Nullable
    public Position findPosAt(int coordX, int coordZ, boolean all) {
        return this.findPosAtChunk(coordX >> 4, coordZ >> 4, all);
    }

    public boolean isPosAt(int coordX, int coordZ) {
        return this.isPosAtChunk(coordX >> 4, coordZ >> 4);
    }

    public boolean isPosAtChunk(int chunkX, int chunkZ) {
        ChunkCoordIntPair p = new ChunkCoordIntPair(chunkX, chunkZ);
        Boolean b = this.cachedChunks.get(p);
        if (b == null) {
            Position pos = this.findPosAtChunk(chunkX, chunkZ, true);
            b = pos != null;
            this.cachedChunks.put(p, b);
        }
        return b;
    }

    @Nullable
    public Position findPosAtChunk(int chunkX, int chunkZ, boolean all) {
        for (Position p : this.positions) {
            if (!p.isChunkInPosition(chunkX, chunkZ)) continue;
            return p;
        }
        if (all) {
            for (Position p : this.fullyGeneratedPositions) {
                if (!p.isChunkInPosition(chunkX, chunkZ)) continue;
                return p;
            }
        }
        return null;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.checked = nbt.func_74767_n("checked");
        if (this.checked) {
            NBTTagList list;
            if (nbt.func_74764_b("positions")) {
                list = nbt.func_150295_c("positions", 10);
                while (list.func_74745_c() > 0) {
                    this.positions.add(this.createPositionFromNBT((NBTTagCompound)list.func_74744_a(0)));
                }
            }
            if (nbt.func_74764_b("fullpositions")) {
                list = nbt.func_150295_c("fullpositions", 10);
                while (list.func_74745_c() > 0) {
                    this.fullyGeneratedPositions.add(this.createPositionFromNBT((NBTTagCompound)list.func_74744_a(0)));
                }
            }
            Logger.d("Test", "Loaded %d fully generated and %d other positions", this.fullyGeneratedPositions.size(), this.positions.size());
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74757_a("checked", this.checked);
        if (this.checked && this.positions.size() > 0) {
            NBTTagList pos = new NBTTagList();
            NBTTagList fullPos = new NBTTagList();
            for (Position p : this.positions) {
                if (p.fullyGenerated()) {
                    fullPos.func_74742_a((NBTBase)p.toNBT());
                    continue;
                }
                pos.func_74742_a((NBTBase)p.toNBT());
            }
            nbt.func_74782_a("positions", (NBTBase)pos);
            nbt.func_74782_a("fullpositions", (NBTBase)fullPos);
        }
    }

    private Position createPositionFromNBT(NBTTagCompound nbt) {
        int[] pos = nbt.func_74759_k("pos");
        Position p = new Position(pos[0], pos[1]);
        p.setSize(pos[2], pos[3]);
        p.setHeight(pos[4]);
        p.generated = nbt.func_74762_e("generated");
        if (nbt.func_74764_b("draDim")) {
            p.setDraculasDim();
        }
        if (nbt.func_74764_b("tiles") && !p.fullyGenerated()) {
            p.loadTilesFromString(nbt.func_74779_i("tiles"));
        }
        if (nbt.func_74764_b("lmc")) {
            int[] lc = nbt.func_74759_k("lmc");
            int[] uc = nbt.func_74759_k("umc");
            p.setMainCastle(new ChunkCoordIntPair(lc[0], lc[1]), new ChunkCoordIntPair(uc[0], uc[1]));
        } else if (p.hasTiles()) {
            p.setMainCastle(new ChunkCoordIntPair(pos[0] + 1, pos[1] + 1), new ChunkCoordIntPair(pos[0] + 2, pos[1] + 2));
            Logger.w("CastlePos", "Creating fake main castle for compatibility reasons for Position (%d/%d)", pos[0], pos[1]);
        }
        return p;
    }

    public String toString() {
        return String.format("PosData(Checked %b, Positions %s, GenPositions %s)", this.checked, Arrays.toString(this.positions.toArray()), Arrays.toString(this.fullyGeneratedPositions.toArray()));
    }

    public static class Position
    extends ChunkCoordIntPair {
        private int sizeX;
        private int sizeZ;
        private boolean draculasDim = false;
        private ChunkCoordIntPair lowerMainCastle;
        private ChunkCoordIntPair upperMainCastle;
        private int tileCount;
        private String[][] tiles;
        private int generated;
        private int height = -1;

        public ChunkCoordIntPair getLowerMainCastle() {
            return this.lowerMainCastle;
        }

        public ChunkCoordIntPair getUpperMainCastle() {
            return this.upperMainCastle;
        }

        public String toString() {
            return super.toString() + "[" + this.sizeZ + "," + this.sizeZ + "]";
        }

        public void setMainCastle(ChunkCoordIntPair lowerMainCastle, ChunkCoordIntPair upperMainCastle) {
            this.lowerMainCastle = lowerMainCastle;
            this.upperMainCastle = upperMainCastle;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public Position(int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
        }

        public void setDraculasDim() {
            this.draculasDim = true;
        }

        public boolean isDraculasDim() {
            return this.draculasDim;
        }

        public void setSize(int x, int z) {
            this.sizeX = x;
            this.sizeZ = z;
            this.tileCount = x * z;
        }

        public int getSizeX() {
            return this.sizeX;
        }

        public int getSizeZ() {
            return this.sizeZ;
        }

        public boolean hasSize() {
            return this.sizeZ > 0 && this.sizeX > 0;
        }

        public boolean hasTiles() {
            return this.tiles != null;
        }

        public void setTiles(String[][] tiles) {
            this.tiles = tiles;
        }

        public void markGenerated(int cx, int cz) {
            ++this.generated;
        }

        public String getTileAt(int x, int z) {
            if (!this.hasTiles()) {
                return "";
            }
            return this.tiles[x][z];
        }

        public boolean fullyGenerated() {
            return this.generated == this.tileCount;
        }

        public boolean isChunkInPosition(int cx, int cz) {
            if (!this.hasSize()) {
                return false;
            }
            return cx >= this.field_77276_a && cx < this.field_77276_a + this.sizeX && cz >= this.field_77275_b && cz < this.field_77275_b + this.sizeZ;
        }

        private NBTTagCompound toNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74783_a("pos", new int[]{this.field_77276_a, this.field_77275_b, this.sizeX, this.sizeZ, this.height});
            if (this.hasTiles() && !this.fullyGenerated()) {
                String s = "";
                for (int x = 0; x < this.sizeX; ++x) {
                    for (int z = 0; z < this.sizeZ; ++z) {
                        s = s + this.tiles[x][z] + "/";
                    }
                }
                s.substring(0, s.length() - 1);
                nbt.func_74778_a("tiles", s);
            }
            if (this.hasTiles()) {
                nbt.func_74783_a("lmc", new int[]{this.lowerMainCastle.field_77276_a, this.lowerMainCastle.field_77275_b});
                nbt.func_74783_a("umc", new int[]{this.upperMainCastle.field_77276_a, this.upperMainCastle.field_77275_b});
            }
            nbt.func_74768_a("generated", this.generated);
            if (this.draculasDim) {
                nbt.func_74757_a("draDim", true);
            }
            return nbt;
        }

        private void loadTilesFromString(String s) {
            String[] parts = s.split("/");
            if (parts.length != this.tileCount) {
                Logger.w("CastlePos", "Cannot load tiles due to wrong size", new Object[0]);
            } else {
                this.tiles = new String[this.sizeX][this.sizeZ];
                for (int x = 0; x < this.sizeX; ++x) {
                    for (int z = 0; z < this.sizeZ; ++z) {
                        this.tiles[x][z] = parts[x * this.sizeZ + z];
                    }
                }
            }
        }
    }
}

