/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.generation.castle;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.registry.GameRegistry;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.EntityDracula;
import de.teamlapen.vampirism.generation.castle.BlockList;
import de.teamlapen.vampirism.tileEntity.TileEntityBloodAltar1;
import de.teamlapen.vampirism.tileEntity.TileEntityBloodAltar2;
import de.teamlapen.vampirism.tileEntity.TileEntityCoffin;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.util.TickRunnable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class Extra {
    public final TYPE type;
    public final BlockList.BlockPosition pos;
    private JsonObject extra;

    public Extra(TYPE t, BlockList.BlockPosition pos) {
        this.type = t;
        this.pos = pos;
    }

    public void applyExtra(final World world, int wx, int wy, int wz) {
        if (this.type == TYPE.SPAWN_ENTITY) {
            int c = this.extra.get("count").getAsInt();
            String entity = this.extra.get("entity").getAsString();
            if ("vampirism.dracula".equals(entity) && world.field_73011_w.field_76574_g != VampirismMod.castleDimensionId) {
                return;
            }
            for (int i = 0; i < c; ++i) {
                final Entity e = EntityList.func_75620_a((String)entity, (World)world);
                if (e != null) {
                    e.func_70107_b((double)wx, (double)wy + 0.19, (double)wz);
                    boolean success = world.func_72838_d(e);
                    if (e instanceof EntityDracula) {
                        Logger.d("Extra", "Spawned Dracula %s (%b)", e, success);
                    }
                    if (success) continue;
                    VampirismMod.proxy.addTickRunnable(new TickRunnable(){
                        int tick = 20;

                        @Override
                        public boolean shouldContinue() {
                            return this.tick > 0;
                        }

                        @Override
                        public void onTick() {
                            --this.tick;
                            if (this.tick == 0) {
                                world.func_72838_d(e);
                            }
                        }
                    });
                    continue;
                }
                MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText("Failed to spawn " + entity));
                Logger.w("Extra", "Failed to create %s in world %s", entity, world);
            }
        } else if (this.type == TYPE.PAINTING) {
            int dir = this.extra.get("dir").getAsInt();
            String title = this.extra.get("title").getAsString();
            EntityPainting.EnumArt art = null;
            for (EntityPainting.EnumArt a : EntityPainting.EnumArt.values()) {
                if (!a.field_75702_A.equals(title)) continue;
                art = a;
                break;
            }
            if (art == null) {
                art = EntityPainting.EnumArt.Alban;
            }
            EntityPainting p = new EntityPainting(world, wx, wy, wz, dir);
            p.field_70522_e = art;
            world.func_72838_d((Entity)p);
        } else {
            TileEntity tileEntity = world.func_147438_o(wx, wy, wz);
            switch (this.type) {
                case SPAWNER: {
                    ((TileEntityMobSpawner)tileEntity).func_145881_a().func_98272_a(this.extra.get("entity_name").getAsString());
                    break;
                }
                case CHEST: {
                    JsonArray items = this.extra.getAsJsonArray("items");
                    TileEntityChest chest = (TileEntityChest)tileEntity;
                    for (int i = 0; i < items.size(); ++i) {
                        JsonObject item = items.get(i).getAsJsonObject();
                        int slot = item.get("s").getAsInt();
                        if (slot < 0 || slot >= chest.func_70302_i_()) continue;
                        String[] part = item.get("name").getAsString().split(":");
                        Item it = GameRegistry.findItem((String)part[0], (String)part[1]);
                        ItemStack st = new ItemStack(it, item.get("count").getAsInt());
                        st.func_77964_b(item.get("damage").getAsInt());
                        chest.func_70299_a(slot, st);
                    }
                    break;
                }
                case COFFIN: {
                    TileEntityCoffin te = (TileEntityCoffin)tileEntity;
                    te.tryToFindOtherTile();
                    te.color = this.extra.get("color").getAsInt();
                    te.occupied = this.extra.get("closed").getAsBoolean();
                    break;
                }
                case WALL_SIGN: {
                    TileEntitySign sign2 = (TileEntitySign)tileEntity;
                    sign2.field_145915_a[0] = this.extra.get("t0").getAsString();
                    sign2.field_145915_a[1] = this.extra.get("t1").getAsString();
                    sign2.field_145915_a[2] = this.extra.get("t2").getAsString();
                    sign2.field_145915_a[3] = this.extra.get("t3").getAsString();
                    break;
                }
                case ALTAR_2: {
                    TileEntityBloodAltar2 altar2 = (TileEntityBloodAltar2)tileEntity;
                    altar2.addBlood(this.extra.get("blood").getAsInt());
                    break;
                }
                case ALTAR_1: {
                    TileEntityBloodAltar1 altar1 = (TileEntityBloodAltar1)tileEntity;
                    if (!this.extra.get("infinite").getAsBoolean()) break;
                    altar1.makeInfinite();
                }
            }
        }
    }

    public void retrieveExtra(TileEntity tileEntity) {
        this.extra = new JsonObject();
        switch (this.type) {
            case SPAWNER: {
                this.extra.addProperty("entity_name", ((TileEntityMobSpawner)tileEntity).func_145881_a().func_98276_e());
                break;
            }
            case CHEST: {
                JsonArray items = new JsonArray();
                TileEntityChest chest = (TileEntityChest)tileEntity;
                for (int i = 0; i < chest.func_70302_i_(); ++i) {
                    ItemStack stack = chest.func_70301_a(i);
                    if (stack == null) continue;
                    JsonObject item = new JsonObject();
                    item.addProperty("s", (Number)i);
                    GameRegistry.UniqueIdentifier un = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
                    if (un == null) continue;
                    item.addProperty("name", un.modId + ":" + un.name);
                    item.addProperty("count", (Number)stack.field_77994_a);
                    item.addProperty("damage", (Number)stack.func_77960_j());
                    items.add((JsonElement)item);
                }
                this.extra.add("items", (JsonElement)items);
                break;
            }
            case COFFIN: {
                this.extra.addProperty("color", (Number)((TileEntityCoffin)tileEntity).color);
                this.extra.addProperty("closed", Boolean.valueOf(((TileEntityCoffin)tileEntity).occupied));
                break;
            }
            case SPAWN_ENTITY: {
                TileEntitySign sign = (TileEntitySign)tileEntity;
                int count = Integer.parseInt(sign.field_145915_a[0]);
                String entity = sign.field_145915_a[1] + sign.field_145915_a[2] + sign.field_145915_a[3];
                this.extra.addProperty("count", (Number)count);
                this.extra.addProperty("entity", entity.trim());
                break;
            }
            case WALL_SIGN: {
                TileEntitySign sign2 = (TileEntitySign)tileEntity;
                this.extra.addProperty("t0", sign2.field_145915_a[0]);
                this.extra.addProperty("t1", sign2.field_145915_a[1]);
                this.extra.addProperty("t2", sign2.field_145915_a[2]);
                this.extra.addProperty("t3", sign2.field_145915_a[3]);
                break;
            }
            case ALTAR_2: {
                TileEntityBloodAltar2 altar2 = (TileEntityBloodAltar2)tileEntity;
                this.extra.addProperty("blood", (Number)altar2.getBloodAmount());
                break;
            }
            case ALTAR_1: {
                TileEntityBloodAltar1 altar1 = (TileEntityBloodAltar1)tileEntity;
                this.extra.addProperty("infinite", Boolean.valueOf(altar1.isInfinite()));
            }
        }
    }

    public void retrieveExtra(EntityPainting p) {
        this.extra = new JsonObject();
        this.extra.addProperty("dir", (Number)p.field_82332_a);
        this.extra.addProperty("title", p.field_70522_e.field_75702_A);
    }

    public static enum TYPE {
        SPAWNER,
        COFFIN,
        CHEST,
        SPAWN_ENTITY,
        PAINTING,
        WALL_SIGN,
        ALTAR_2,
        ALTAR_1;

    }
}

