/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.generation.villages;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import de.teamlapen.vampirism.generation.villages.ConfigHandler;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.BiomeEvent;

public class BiomeBlockReplacer
implements IEventListener {
    private Map<Block, List<Pair<String, Block>>> replacements = ConfigHandler.getReplacements();
    private Map<Block, List<Pair<String, Integer>>> metadata = ConfigHandler.getMetadata();

    private static boolean checkCondition(BiomeGenBase biome, String condition) {
        if (biome == null || condition == null) {
            return false;
        }
        try {
            if (condition.startsWith("b:")) {
                String identifier = condition.substring("b:".length());
                return identifier.equalsIgnoreCase(biome.field_76791_y) || identifier.equals(String.valueOf(biome.field_76756_M));
            }
            if (condition.startsWith("t:")) {
                String identifier = condition.substring("t:".length());
                BiomeDictionary.Type type = BiomeDictionary.Type.valueOf((String)identifier);
                return type != null && BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)type);
            }
            return false;
        }
        catch (NullPointerException e) {
            Logger.w("BiomeBlockReplacer", "NullPointerException when replacing blocks:", new Object[0]);
            e.printStackTrace();
            Logger.w("BiomeBlockReplacer", "Biome class: " + biome.getClass() + "; Condition: " + condition, new Object[0]);
            return false;
        }
    }

    @SubscribeEvent
    public void invoke(Event event) {
        BiomeEvent.GetVillageBlockID ev;
        if (event instanceof BiomeEvent.GetVillageBlockID) {
            ev = (BiomeEvent.GetVillageBlockID)event;
            if (this.replacements.containsKey(ev.original)) {
                for (Pair<String, Block> pair : this.replacements.get(ev.original)) {
                    if (!BiomeBlockReplacer.checkCondition(ev.biome, (String)pair.left)) continue;
                    ev.replacement = (Block)pair.right;
                    ev.setResult(Event.Result.DENY);
                }
            }
        }
        if (event instanceof BiomeEvent.GetVillageBlockMeta) {
            ev = (BiomeEvent.GetVillageBlockMeta)event;
            boolean replaced = false;
            if (this.metadata.containsKey(ev.original)) {
                for (Pair<String, Integer> pair : this.metadata.get(ev.original)) {
                    if (!BiomeBlockReplacer.checkCondition(ev.biome, (String)pair.left)) continue;
                    ev.replacement = (Integer)pair.right;
                    ev.setResult(Event.Result.DENY);
                    replaced = true;
                }
            }
            if (!replaced && this.replacements.containsKey(ev.original)) {
                for (Pair<String, Integer> pair : this.replacements.get(ev.original)) {
                    if (!BiomeBlockReplacer.checkCondition(ev.biome, (String)pair.left)) continue;
                    ev.setResult(Event.Result.ALLOW);
                }
            }
        }
    }
}

