/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.generation.villages;

import de.teamlapen.vampirism.generation.villages.VillageBiomes;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.util.Pair;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import org.apache.commons.io.IOUtils;

public class ConfigHandler {
    private static List<String> configLines = new ArrayList<String>();

    public static List<String> getAddBiomes() {
        return ConfigHandler.getAfterPrefix("+b:");
    }

    public static List<String> getAddTypes() {
        return ConfigHandler.getAfterPrefix("+t:");
    }

    private static List<String> getAfterPrefix(String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : configLines) {
            if (!line.startsWith(prefix)) continue;
            result.add(line.substring(prefix.length()));
        }
        return result;
    }

    public static Map<Block, List<Pair<String, Integer>>> getMetadata() {
        HashMap<Block, List<Pair<String, Integer>>> map = new HashMap<Block, List<Pair<String, Integer>>>();
        Pattern p = Pattern.compile("^~([\\w:]+),[\\w:]+?:(\\d+),([bt]:.+)");
        for (String line : configLines) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            Block b = Block.func_149684_b((String)m.group(1));
            Integer meta = Integer.valueOf(m.group(2));
            String condition = m.group(3);
            if (!map.containsKey(b)) {
                map.put(b, new ArrayList());
            }
            ((List)map.get(b)).add(new Pair<String, Integer>(condition, meta));
        }
        return map;
    }

    public static List<String> getRemoveBiomes() {
        return ConfigHandler.getAfterPrefix("-b:");
    }

    public static List<String> getRemoveTypes() {
        return ConfigHandler.getAfterPrefix("-t:");
    }

    public static Map<Block, List<Pair<String, Block>>> getReplacements() {
        HashMap<Block, List<Pair<String, Block>>> map = new HashMap<Block, List<Pair<String, Block>>>();
        Pattern p = Pattern.compile("^~([\\w:]+),([\\w:]+?)(?::\\d+)?,([bt]:.+)");
        for (String line : configLines) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            Block b = Block.func_149684_b((String)m.group(1));
            Block replacement = Block.func_149684_b((String)m.group(2));
            String condition = m.group(3);
            if (b.equals(replacement)) continue;
            if (b == null || replacement == null) {
                Logger.w("BiomeCfgHandler", "Cannot read replacements from line %s", line);
                continue;
            }
            if (!map.containsKey(b)) {
                map.put(b, new ArrayList());
            }
            ((List)map.get(b)).add(new Pair<String, Block>(condition, replacement));
        }
        return map;
    }

    public static void loadConfig(File file) {
        try {
            if (file.createNewFile()) {
                try {
                    InputStream defaultConf = VillageBiomes.class.getResourceAsStream("/VillageBiomesDefault.cfg");
                    FileWriter writer = new FileWriter(file);
                    IOUtils.copy((InputStream)defaultConf, (Writer)writer);
                    writer.close();
                    defaultConf.close();
                }
                catch (Exception e) {
                    Logger.e("ConfigHandler", e.getMessage(), new Object[0]);
                    e.printStackTrace();
                }
            }
            Scanner sc = new Scanner(file);
            while (sc.hasNextLine()) {
                configLines.add(sc.nextLine().trim());
            }
            sc.close();
        }
        catch (IOException e) {
            Logger.e("ConfigHandler", "[%s] Can't load or create its config in %s.", "vampirism", file.getAbsolutePath());
        }
    }
}

