/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.generation.villages;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.util.Logger;
import java.lang.reflect.Field;
import net.minecraftforge.event.terraingen.InitMapGenEvent;

public class VillageGenReplacer
implements IEventListener {
    @SubscribeEvent
    public void invoke(Event event) {
        if (event instanceof InitMapGenEvent) {
            InitMapGenEvent e = (InitMapGenEvent)event;
            if (e.type == InitMapGenEvent.EventType.VILLAGE) {
                if (e.newGen != e.originalGen) {
                    Logger.e("VillageGenReplacer", "The village map generator was overwritten by another mod. There might be crashes! \n The new generator class is " + e.getClass().getCanonicalName(), new Object[0]);
                }
                try {
                    Field[] fields;
                    Field type = null;
                    Field density = null;
                    Field minDist = null;
                    for (Field f : fields = e.newGen.getClass().getDeclaredFields()) {
                        String name = f.getName();
                        if (name.equals("terrainType")) {
                            type = f;
                            continue;
                        }
                        if (name.equals("field_82665_g")) {
                            density = f;
                            continue;
                        }
                        if (!name.equals("field_82666_h")) continue;
                        minDist = f;
                    }
                    if (type != null) {
                        type.setAccessible(true);
                        type.setInt(e.newGen, Configs.village_size);
                    }
                    if (density != null) {
                        density.setAccessible(true);
                        density.setInt(e.newGen, Configs.village_density);
                    }
                    if (minDist != null) {
                        minDist.setAccessible(true);
                        minDist.setInt(e.newGen, Configs.village_minDist);
                    }
                    Logger.d("VillageGenReplacer", "Modified MapGenVillage fields.", new Object[0]);
                }
                catch (Exception exc) {
                    Logger.e("VillageGenReplacer", "Could not modify MapGenVillage, consider disabling Village Density in VillageDensity.cfg", new Object[0]);
                    exc.printStackTrace();
                }
            }
        }
    }
}

