/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.guide;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.abstraction.IPage;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.util.GuiHelper;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.gui.GuiEntry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.teamlapen.vampirism.guide.VampirismGuide;
import de.teamlapen.vampirism.util.Logger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PageHolderWithLinks
implements IPage {
    private IPage page;
    private List<Link> links;
    private List<String> lateLinks;

    public PageHolderWithLinks addLink(EntryAbstract entry) {
        this.links.add(new Link(entry));
        return this;
    }

    public PageHolderWithLinks addLink(String identifier) {
        this.lateLinks.add(identifier);
        return this;
    }

    public PageHolderWithLinks(IPage wrappedPage) {
        this.page = wrappedPage;
        this.links = new ArrayList<Link>();
        this.lateLinks = new ArrayList<String>();
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, int i, int i1, int i2, int i3, GuiBase guiBase, FontRenderer fontRenderer) {
        this.page.draw(book, categoryAbstract, entryAbstract, i, i1, i2, i3, guiBase, fontRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawExtras(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRenderer) {
        int ll = guiLeft + guiBase.xSize - 5;
        int y = guiTop + 10;
        for (Link l : this.links) {
            fontRenderer.func_78261_a(l.entry.getLocalizedName(), ll, y, 0xFFFFFF);
            if (l.width == 0) {
                l.width = fontRenderer.func_78256_a(l.entry.getLocalizedName());
            }
            y += 20;
        }
        this.page.drawExtras(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canSee(Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, EntityPlayer entityPlayer, ItemStack itemStack, GuiEntry guiEntry) {
        return this.page.canSee(book, categoryAbstract, entryAbstract, entityPlayer, itemStack, guiEntry);
    }

    @SideOnly(value=Side.CLIENT)
    public void onLeftClicked(Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, int mouseX, int mouseY, EntityPlayer entityPlayer, GuiEntry guiEntry) {
        if (mouseX > guiEntry.guiLeft + guiEntry.xSize) {
            for (int i = 0; i < this.links.size(); ++i) {
                if (!GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)(guiEntry.guiLeft + guiEntry.xSize), (int)(guiEntry.guiTop + 10 + 20 * i), (int)this.links.get((int)i).width, (int)20)) continue;
                this.openLinkedEntry(book, categoryAbstract, this.links.get((int)i).entry, entityPlayer, guiEntry.bookStack, entryAbstract, guiEntry.pageNumber);
                return;
            }
        }
        this.page.onLeftClicked(book, categoryAbstract, entryAbstract, mouseX, mouseY, entityPlayer, guiEntry);
    }

    @SideOnly(value=Side.CLIENT)
    public void onRightClicked(Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, int i, int i1, EntityPlayer entityPlayer, GuiEntry guiEntry) {
        this.page.onRightClicked(book, categoryAbstract, entryAbstract, i, i1, entityPlayer, guiEntry);
    }

    @SideOnly(value=Side.CLIENT)
    public void openLinkedEntry(Book book, CategoryAbstract category, EntryAbstract entry, EntityPlayer player, ItemStack bookStack, EntryAbstract from, int fromPage) {
        GuiScreen screen = null;
        try {
            screen = Class.forName("de.teamlapen.vampirism.client.gui.GuiLinkedEntry").asSubclass(GuiScreen.class).getConstructor(Book.class, CategoryAbstract.class, EntryAbstract.class, EntityPlayer.class, ItemStack.class, EntryAbstract.class, Integer.TYPE).newInstance(book, category, entry, player, bookStack, from, fromPage);
        }
        catch (Exception e) {
            Logger.e("PHWithLink", e, "Failed to create a GuiLinkedEntry. This should not be impossible. But maybe the mod author has messed something up.", new Object[0]);
        }
        Minecraft.func_71410_x().func_147108_a(screen);
    }

    public void onInit(Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, EntityPlayer entityPlayer, ItemStack itemStack, GuiEntry guiEntry) {
        while (this.lateLinks.size() > 0) {
            String s = this.lateLinks.remove(0);
            EntryAbstract e = VampirismGuide.getLinkedEntry(s);
            if (e != null) {
                this.links.add(new Link(e));
                continue;
            }
            Logger.w("PageWithLinks", "Failed to find linked entry %s", s);
        }
        this.page.onInit(book, categoryAbstract, entryAbstract, entityPlayer, itemStack, guiEntry);
    }

    private class Link {
        public final EntryAbstract entry;
        public int width = 0;

        public Link(EntryAbstract entry) {
            this.entry = entry;
        }
    }
}

