/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileEntity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public abstract class InventoryTileEntity
extends TileEntity
implements IInventory {
    protected final int MAX_DIST_SQRT = 40;
    private Slot[] slots;

    public InventoryTileEntity(Slot[] slots) {
        this.slots = slots;
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
            return stack;
        }
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public Container getNewInventoryContainer(InventoryPlayer inv) {
        return new InventoryContainer(inv, this);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.slots[slot].stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
            return stack;
        }
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.slots[slot].itemSelector != null) {
            return this.slots[slot].itemSelector.isItemAllowed(stack);
        }
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 40.0;
    }

    public void func_70295_k_() {
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i].stack = null;
        }
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.slots.length) continue;
            this.slots[slot].stack = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.slots[slot].stack = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            ItemStack stack = this.slots[i].stack;
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
    }

    public static class Slot {
        public final IItemSelector itemSelector;
        public final int xDisplay;
        public final int yDisplay;
        public ItemStack stack;

        public Slot(final Class<? extends Item> cls, int xDisplay, int yDisplay) {
            this(new IItemSelector(){

                @Override
                public boolean isItemAllowed(ItemStack item) {
                    return cls.isInstance(item.func_77973_b());
                }
            }, xDisplay, yDisplay);
        }

        public Slot(IItemSelector selector, int xDisplay, int yDisplay) {
            this.itemSelector = selector;
            this.xDisplay = xDisplay;
            this.yDisplay = yDisplay;
        }

        public Slot(int xDisplay, int yDisplay) {
            this((IItemSelector)null, xDisplay, yDisplay);
        }

        public Slot(final Item item, int xDisplay, int yDisplay) {
            this(new IItemSelector(){

                @Override
                public boolean isItemAllowed(ItemStack stack) {
                    return item.equals(stack.func_77973_b());
                }
            }, xDisplay, yDisplay);
        }
    }

    public static class InventoryContainer
    extends Container {
        private InventoryTileEntity tile;

        public InventoryContainer(InventoryPlayer invPlayer, InventoryTileEntity te) {
            int i;
            this.tile = te;
            for (i = 0; i < this.tile.slots.length; ++i) {
                this.func_75146_a(new FilterSlot(this.tile, i, ((InventoryTileEntity)this.tile).slots[i].xDisplay, ((InventoryTileEntity)this.tile).slots[i].yDisplay, ((InventoryTileEntity)this.tile).slots[i].itemSelector));
            }
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.func_75146_a(new net.minecraft.inventory.Slot((IInventory)invPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.func_75146_a(new net.minecraft.inventory.Slot((IInventory)invPlayer, i, 8 + i * 18, 142));
            }
        }

        public boolean func_75145_c(EntityPlayer p_75145_1_) {
            return this.tile.func_70300_a(p_75145_1_);
        }

        public ItemStack func_82846_b(EntityPlayer player, int slot) {
            ItemStack stack = null;
            net.minecraft.inventory.Slot slotObject = (net.minecraft.inventory.Slot)this.field_75151_b.get(slot);
            if (slotObject != null && slotObject.func_75216_d()) {
                ItemStack stackInSlot = slotObject.func_75211_c();
                stack = stackInSlot.func_77946_l();
                if (slot < this.tile.slots.length ? !this.func_75135_a(stackInSlot, this.tile.slots.length, this.tile.slots.length + 36, true) : !this.func_75135_a(stackInSlot, 0, this.tile.slots.length, false)) {
                    return null;
                }
                if (stackInSlot.field_77994_a == 0) {
                    slotObject.func_75215_d(null);
                } else {
                    slotObject.func_75218_e();
                }
                if (stackInSlot.field_77994_a == stack.field_77994_a) {
                    return null;
                }
                slotObject.func_82870_a(player, stackInSlot);
            }
            return stack;
        }
    }

    public static interface IItemSelector {
        public boolean isItemAllowed(ItemStack var1);
    }

    public static class FilterSlot
    extends net.minecraft.inventory.Slot {
        IItemSelector selector;

        public FilterSlot(IInventory p_i1824_1_, int p_i1824_2_, int p_i1824_3_, int p_i1824_4_, IItemSelector selector) {
            super(p_i1824_1_, p_i1824_2_, p_i1824_3_, p_i1824_4_);
            this.selector = selector;
        }

        public boolean func_75214_a(ItemStack stack) {
            if (this.selector != null) {
                return this.selector.isItemAllowed(stack);
            }
            return true;
        }
    }
}

