/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileEntity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.teamlapen.vampirism.ModBlocks;
import de.teamlapen.vampirism.block.BlockBloodAltar1;
import de.teamlapen.vampirism.block.BlockBloodAltar2;
import de.teamlapen.vampirism.block.BlockCoffin;
import de.teamlapen.vampirism.generation.castle.BlockList;
import de.teamlapen.vampirism.generation.castle.BuildingTile;
import de.teamlapen.vampirism.generation.castle.Extra;
import de.teamlapen.vampirism.util.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.chunk.Chunk;

public class TileEntityTemplateGenerator
extends TileEntity {
    private List<BlockList> blockLists;
    private List<Extra> extraList;
    private final String TAG = "TETemplateGenerator";

    public void onActivated(int minY) {
        Logger.i("TETemplateGenerator", "Activated with minY %d", minY);
        this.blockLists = new LinkedList<BlockList>();
        this.extraList = new LinkedList<Extra>();
        Chunk chunk = this.func_145831_w().func_72938_d(this.field_145851_c, this.field_145849_e);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = this.field_145848_d + minY; y < this.field_145850_b.func_72940_L(); ++y) {
                    TileEntity t;
                    Block block = chunk.func_150810_a(x, y, z);
                    if (block.equals((Object)ModBlocks.templateGenerator) || block.equals(Blocks.field_150354_m) || block.equals(Blocks.field_150322_A) || block.func_149688_o() == Material.field_151579_a && y >= this.field_145848_d) continue;
                    if (block.equals(Blocks.field_150472_an)) {
                        TileEntitySign sign = (TileEntitySign)chunk.getTileEntityUnsafe(x, y, z);
                        if (sign != null) {
                            Extra e = new Extra(Extra.TYPE.SPAWN_ENTITY, new BlockList.BlockPosition(x, y - this.field_145848_d, z));
                            e.retrieveExtra((TileEntity)sign);
                            this.extraList.add(e);
                        }
                        if (y >= this.field_145848_d) continue;
                        this.addBlock(Blocks.field_150350_a, new int[]{0, 0, 0, 0}, x, y - this.field_145848_d, z);
                        continue;
                    }
                    int m = chunk.func_76628_c(x, y, z);
                    int[] meta = this.guessMetaForBlock(block, m);
                    this.addBlock(block, meta, x, y - this.field_145848_d, z);
                    Extra.TYPE extraType = null;
                    if (block instanceof BlockMobSpawner) {
                        extraType = Extra.TYPE.SPAWNER;
                    } else if (block instanceof BlockChest) {
                        extraType = Extra.TYPE.CHEST;
                    } else if (block instanceof BlockCoffin) {
                        extraType = Extra.TYPE.COFFIN;
                    } else if (block.equals(Blocks.field_150444_as)) {
                        extraType = Extra.TYPE.WALL_SIGN;
                    } else if (block instanceof BlockBloodAltar2) {
                        extraType = Extra.TYPE.ALTAR_2;
                    } else if (block instanceof BlockBloodAltar1) {
                        extraType = Extra.TYPE.ALTAR_1;
                    }
                    if (extraType == null || (t = chunk.getTileEntityUnsafe(x, y, z)) == null) continue;
                    Extra e = new Extra(extraType, new BlockList.BlockPosition(x, y - this.field_145848_d, z));
                    e.retrieveExtra(t);
                    this.extraList.add(e);
                }
            }
        }
        ArrayList paintings = new ArrayList();
        chunk.func_76618_a(EntityPainting.class, AxisAlignedBB.func_72330_a((double)-2.147483648E9, (double)(this.field_145848_d + minY), (double)-2.147483648E9, (double)2.147483647E9, (double)this.field_145850_b.func_72940_L(), (double)2.147483647E9), paintings, null);
        for (EntityPainting p : paintings) {
            Extra extra = new Extra(Extra.TYPE.PAINTING, new BlockList.BlockPosition(p.field_146063_b - (chunk.field_76635_g << 4), p.field_146064_c - this.field_145848_d, p.field_146062_d - (chunk.field_76647_h << 4)));
            extra.retrieveExtra(p);
            this.extraList.add(extra);
        }
        this.save();
        this.blockLists = null;
        this.extraList = null;
    }

    private void save() {
        Logger.i("TETemplateGenerator", "Saving template", new Object[0]);
        for (BlockList bl : this.blockLists) {
            bl.prepareForSave();
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)new BuildingTile(this.blockLists, this.extraList));
        try {
            File f = new File("vampirism/" + new Random().nextInt() + ".json");
            f.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(f);
            writer.write(json);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addBlock(Block b, int[] meta, int x, int y, int z) {
        BlockList bl2;
        for (BlockList bl2 : this.blockLists) {
            if (!bl2.equals(b, meta)) continue;
            bl2.addPosition(x, y, z);
            return;
        }
        bl2 = new BlockList(b, meta);
        bl2.addPosition(x, y, z);
        this.blockLists.add(bl2);
    }

    private int[] rotate(int[] data, int rot) {
        if (rot == 0) {
            return data;
        }
        if (rot == 1) {
            return new int[]{data[1], data[2], data[3], data[0]};
        }
        if (rot == 2) {
            return new int[]{data[2], data[3], data[0], data[1]};
        }
        return new int[]{data[3], data[0], data[1], data[2]};
    }

    private int[] guessMetaForBlock(Block block, int meta) {
        int[] metadata = null;
        try {
            if (block instanceof BlockStairs) {
                int[] rotSet = new int[]{3, 1, 0, 2};
                int[] normalSet = new int[]{2, 1, 3, 0};
                int[] upSet = new int[]{6, 5, 7, 4};
                metadata = meta > 3 ? this.rotate(upSet, rotSet[meta - 4]) : this.rotate(normalSet, rotSet[meta]);
            } else if (block instanceof BlockLadder) {
                int[] rotSet = new int[]{0, 0, 0, 2, 3, 1};
                int[] set = new int[]{2, 5, 3, 4};
                metadata = this.rotate(set, rotSet[meta]);
            } else if (block instanceof BlockTrapDoor) {
                int[] rotSet = new int[]{0, 2, 3, 1};
                int[] normalSet = new int[]{0, 3, 1, 2};
                int[] upSet = new int[]{8, 11, 9, 10};
                metadata = meta > 7 ? this.rotate(upSet, rotSet[meta - 8]) : this.rotate(normalSet, rotSet[meta]);
            } else if (block instanceof BlockTorch) {
                int[] rotSet = new int[]{1, 3, 2, 0};
                int[] set = new int[]{4, 1, 3, 2};
                if (meta != 5) {
                    metadata = this.rotate(set, rotSet[meta - 1]);
                }
            } else if (block instanceof BlockDoor) {
                int[] rotSet = new int[]{3, 0, 1, 2};
                int[] set = new int[]{1, 2, 3, 0};
                int[] openSet = new int[]{5, 6, 7, 4};
                if (meta < 4) {
                    metadata = this.rotate(set, rotSet[meta]);
                } else if (meta < 8) {
                    metadata = this.rotate(openSet, rotSet[meta - 4]);
                }
            } else if (block instanceof BlockCoffin) {
                int[] set = new int[]{8, 9, 10, 11};
                if (meta > 0) {
                    metadata = this.rotate(set, meta % 4);
                }
            } else if (block instanceof BlockChest) {
                int[] rotSet = new int[]{0, 2, 3, 1};
                int[] set = new int[]{2, 5, 3, 4};
                metadata = this.rotate(set, rotSet[meta - 2]);
            } else if (block instanceof BlockFenceGate) {
                int[] set = new int[]{0, 1, 2, 3};
                int[] setOpen = new int[]{4, 5, 6, 7};
                metadata = meta > 3 ? this.rotate(setOpen, meta - 4) : this.rotate(set, meta);
            } else if (block instanceof BlockFurnace) {
                int[] set = new int[]{2, 5, 3, 4};
                int[] rotSet = new int[]{0, 2, 3, 1};
                metadata = this.rotate(set, rotSet[meta - 2]);
            } else if (Blocks.field_150444_as.equals(block)) {
                int[] set = new int[]{2, 5, 3, 4};
                int[] rotSet = new int[]{0, 2, 3, 1};
                metadata = this.rotate(set, rotSet[meta - 2]);
            } else if (block instanceof BlockFenceGate) {
                int[] set = new int[]{0, 1, 2, 3};
                int[] openSet = new int[]{4, 5, 6, 7};
                metadata = this.rotate(meta > 3 ? openSet : set, meta);
            } else if (block instanceof BlockButton && meta > 0 && meta < 5) {
                int[] set = new int[]{3, 2, 4, 1};
                int[] rotSet = new int[]{3, 1, 0, 2};
                metadata = this.rotate(set, rotSet[meta - 1]);
            }
            if (metadata != null) {
                return metadata;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Logger.w("TETemplateGenerator", "Failed to guess the right metadata for %s %d.", block, meta);
        }
        return new int[]{meta, meta, meta, meta};
    }
}

