/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.util.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class SupporterManager {
    private static SupporterManager instance;
    private static final String TAG = "SupporterManager";
    private Supporter[] supporters = new Supporter[]{new Supporter("Steve", "steve")};

    protected SupporterManager() {
    }

    public static SupporterManager getInstance() {
        if (instance == null) {
            instance = new SupporterManager();
        }
        return instance;
    }

    public void initAsync() {
        Thread thread = new Thread("vampirism:SupporterManager"){

            @Override
            public void run() {
                SupporterManager.this.init();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private void init() {
        Supporter[] supporters = null;
        InputStream inputStream = null;
        try {
            inputStream = new URL("https://raw.githubusercontent.com/TeamLapen/Vampirism/1.7.10/src/main/resources/supporters.txt").openStream();
            supporters = this.retrieveSupporter(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            Logger.e(TAG, e, "Failed to retrieve supporters from url", new Object[0]);
        }
        if (supporters == null) {
            try {
                inputStream = VampirismMod.class.getResourceAsStream("/supporters.txt");
                supporters = this.retrieveSupporter(inputStream);
                inputStream.close();
            }
            catch (IOException e) {
                Logger.e(TAG, "Failed to retrieve supporters from resources", new Object[0]);
            }
        }
        if (supporters != null) {
            this.supporters = supporters;
        }
    }

    public String getSupporterString() {
        return Arrays.toString(this.supporters);
    }

    public Supporter getRandom(Random rnd) {
        return this.supporters[rnd.nextInt(this.supporters.length)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Supporter[] retrieveSupporter(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        ArrayList<Supporter> supporters = new ArrayList<Supporter>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                String[] parts = line.split(":");
                if (parts.length != 2) {
                    Logger.w(TAG, "Cannot understand line '%s' -> Skipping", line);
                    continue;
                }
                supporters.add(new Supporter(parts[0], parts[1]));
            }
            reader.close();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return supporters.toArray(new Supporter[supporters.size()]);
    }

    public class Supporter {
        public final String textureName;
        public final String senderName;

        public Supporter(String senderName, String textureName) {
            if (senderName.equals("null")) {
                senderName = null;
            }
            this.textureName = textureName;
            this.senderName = senderName;
        }

        public String toString() {
            return "[" + this.textureName + " as '" + this.senderName + "']";
        }
    }
}

