/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.gson.Gson;
import cpw.mods.fml.common.Loader;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.util.Logger;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;

public class VersionChecker
implements Runnable {
    private static VersionChecker instance = new VersionChecker();
    private static final String TAG = "VersionChecker";
    @Nullable
    public static VersionContainer.Version newVersion = null;

    public static void execute() {
        new Thread(instance).start();
    }

    public static String addVersionInfo(String template) {
        return template.replaceAll("@download@", newVersion.getUpdateURL()).replaceAll("@forum@", "http://teamlapen.de/projects/vampirism");
    }

    @Override
    public void run() {
        try {
            Gson gson = new Gson();
            String json = IOUtils.toString((URL)new URL("http://maxanier.de/projects/vampirism/versions.json"));
            VersionContainer versionContainer = (VersionContainer)gson.fromJson(json, VersionContainer.class);
            VersionContainer.Version latest = versionContainer.getLatestFromMcVersion(Loader.instance().getMCVersionString());
            if (latest != null) {
                if (latest.getModVersion().equalsIgnoreCase("0.7.9")) {
                    Logger.d(TAG, "%s is up-to-date", "vampirism");
                } else if (VampirismMod.inDev) {
                    Logger.d(TAG, "In dev, but the newest official version of %s is %s", "vampirism", latest.getModVersion());
                } else if ("0.7.9".contains("Alpha")) {
                    Logger.d(TAG, "In alpha, the newest official version of %s is %s", "vampirism", latest.getModVersion());
                } else {
                    Logger.d(TAG, "%s (%s) is out-of-date. A new version (%s) is available", "vampirism", "0.7.9", latest.getModVersion());
                    newVersion = latest;
                }
            } else {
                Logger.d(TAG, "Did not find a %s version for this Minecraft Version (%s)", "vampirism", Loader.instance().getMCVersionString());
            }
        }
        catch (Exception e) {
            Logger.e(TAG, e, "Failed to retrieve the newest version of %s", "vampirism");
        }
    }

    public class VersionContainer {
        public List<Version> versionList;

        public VersionContainer(List<Version> versionList) {
            this.versionList = versionList;
        }

        public Version getLatestFromMcVersion(String McVersion) {
            for (Version version : this.versionList) {
                if (!this.doStringsMatch(McVersion, version.getMcVersion())) continue;
                return version;
            }
            return null;
        }

        private boolean doStringsMatch(String first, String second) {
            String[] leastTokens;
            String[] secondTokens;
            if (first.startsWith("Minecraft ")) {
                first = first.substring("Minecraft ".length());
            }
            if (second.startsWith("Minecraft ")) {
                second = second.substring("Minecraft ".length());
            }
            if (first.equals(second)) {
                return true;
            }
            String[] firstTokens = first.split("\\.");
            String[] mostTokens = firstTokens.length > (secondTokens = second.split("\\.")).length ? firstTokens : secondTokens;
            String[] stringArray = leastTokens = mostTokens == firstTokens ? secondTokens : firstTokens;
            if (firstTokens.length != secondTokens.length && !this.isVersionWildcardPattern(leastTokens[leastTokens.length - 1])) {
                return false;
            }
            for (int i = 0; i < leastTokens.length; ++i) {
                if (leastTokens[i].equals(mostTokens[i]) || this.isVersionWildcardPattern(leastTokens[i]) || this.isVersionWildcardPattern(mostTokens[i])) continue;
                return false;
            }
            return true;
        }

        private boolean isVersionWildcardPattern(String str) {
            return str.equals("*") || str.equals("x");
        }

        public class Version {
            private String mcVersion;
            private String modVersion;
            private List<String> changeLog;
            private String updateURL;
            private boolean isDirectLink;
            private String newFileName;

            private Version(String mcVersion, String modVersion, List<String> changeLog, String updateURL, boolean isDirectLink, String newFileName) {
                this.mcVersion = mcVersion;
                this.modVersion = modVersion;
                this.changeLog = changeLog;
                this.updateURL = updateURL;
                this.isDirectLink = isDirectLink;
                this.newFileName = newFileName;
            }

            public String getMcVersion() {
                return this.mcVersion;
            }

            public String getModVersion() {
                return this.modVersion;
            }

            public List<String> getChangeLog() {
                return this.changeLog;
            }

            public String getUpdateURL() {
                return this.updateURL;
            }
        }
    }
}

