/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.villages;

import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.entity.EntityVampireHunter;
import de.teamlapen.vampirism.util.BALANCE;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.Logger;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.village.Village;
import net.minecraft.world.World;

public class VillageVampire {
    private final String TAG = "VillageVampire";
    private World world;
    private final ChunkCoordinates center = new ChunkCoordinates(0, 0, 0);
    private int recentlyBitten;
    private int recentlyConverted;
    private boolean agressive;
    private boolean dirty;

    public static AxisAlignedBB getBoundingBox(Village v) {
        int r = v.func_75568_b();
        ChunkCoordinates cc = v.func_75577_a();
        return AxisAlignedBB.func_72330_a((double)(cc.field_71574_a - r), (double)(cc.field_71572_b - 10), (double)(cc.field_71573_c - r), (double)(cc.field_71574_a + r), (double)(cc.field_71572_b + 10), (double)(cc.field_71573_c + r));
    }

    private void checkHunterCount(Village v) {
        int count = this.getHunter(v).size();
        if (!Configs.disable_hunter && count < BALANCE.MOBPROP.VAMPIRE_HUNTER_MAX_PER_VILLAGE || this.agressive && (double)count < (double)BALANCE.MOBPROP.VAMPIRE_HUNTER_MAX_PER_VILLAGE * 1.4) {
            for (Entity e : Helper.spawnEntityInVillage(v, 2, "vampirism.vampireHunter", this.world)) {
                ((EntityVampireHunter)e).setVillageArea(v.func_75577_a().field_71574_a, v.func_75577_a().field_71572_b, v.func_75577_a().field_71573_c, v.func_75568_b());
                if (((EntityVampireHunter)e).func_70681_au().nextBoolean()) {
                    ((EntityVampireHunter)e).setLevel(1, true);
                    continue;
                }
                if (!this.agressive) continue;
                ((EntityVampireHunter)e).setLevel(3, true);
            }
        }
    }

    public AxisAlignedBB getBoundingBox() {
        return VillageVampire.getBoundingBox(this.getVillage());
    }

    public ChunkCoordinates getCenter() {
        return this.center;
    }

    private List<EntityVampireHunter> getHunter(Village v) {
        return this.world.func_72872_a(EntityVampireHunter.class, VillageVampire.getBoundingBox(v));
    }

    public Village getVillage() {
        Village v = this.world.field_72982_D.func_75550_a(this.center.field_71574_a, this.center.field_71572_b, this.center.field_71573_c, 0);
        if (v == null) {
            return null;
        }
        if (!v.func_75577_a().equals((Object)this.center)) {
            Logger.w("VillageVampire", "There is no village at this position: " + this.center.toString(), new Object[0]);
            return null;
        }
        return v;
    }

    private List<EntityVillager> getVillager(Village v) {
        return this.world.func_72872_a(EntityVillager.class, VillageVampire.getBoundingBox(v));
    }

    public int isAnnihilated() {
        Village v = this.world.field_72982_D.func_75550_a(this.center.field_71574_a, this.center.field_71572_b, this.center.field_71573_c, 0);
        if (v == null) {
            Logger.i("VillageVampire", "Can't find village at " + this.center.toString(), new Object[0]);
            return -1;
        }
        if (!this.getCenter().equals((Object)v.func_75577_a())) {
            this.setCenter(v.func_75577_a());
            return 0;
        }
        return 1;
    }

    private void makeAgressive(Village v) {
        Logger.d("VillageVampire", "Making agressive", new Object[0]);
        this.agressive = true;
        for (EntityVillager e : this.getVillager(v)) {
            if (this.world.field_73012_v.nextInt(4) != 0) continue;
            EntityVampireHunter h = (EntityVampireHunter)EntityList.func_75620_a((String)"vampirism.vampireHunter", (World)this.world);
            h.func_82149_j((Entity)e);
            this.world.func_72838_d((Entity)h);
            h.setLevel(1, true);
            e.func_70106_y();
        }
        this.dirty = true;
    }

    private void makeCalm(Village v) {
        Logger.d("VillageVampire", "Making calm", new Object[0]);
        this.agressive = false;
        for (EntityVampireHunter e : this.getHunter(v)) {
            if (e.getLevel() != 1) continue;
            Entity ev = EntityList.func_75620_a((String)"Villager", (World)this.world);
            ev.func_82149_j((Entity)e);
            this.world.func_72838_d(ev);
            e.func_70106_y();
        }
        this.dirty = true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.center.field_71574_a = nbt.func_74762_e("CX");
        this.center.field_71572_b = nbt.func_74762_e("CY");
        this.center.field_71573_c = nbt.func_74762_e("CZ");
        this.agressive = nbt.func_74767_n("AGR");
        this.recentlyBitten = nbt.func_74762_e("BITTEN");
        this.recentlyConverted = nbt.func_74762_e("CONVERTED");
    }

    public void setCenter(ChunkCoordinates cc) {
        this.center.func_71571_b(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
    }

    public void setWorld(World world) {
        this.world = world;
    }

    private void spawnVillager(Village v) {
        List l = this.world.func_72872_a(EntityVillager.class, VillageVampire.getBoundingBox(v));
        if (l.size() > 0) {
            EntityVillager ev = (EntityVillager)l.get(this.world.field_73012_v.nextInt(l.size()));
            EntityVillager entityvillager = ev.func_90011_a((EntityAgeable)ev);
            ev.func_70873_a(6000);
            entityvillager.func_70873_a(-24000);
            entityvillager.func_70012_b(ev.field_70165_t, ev.field_70163_u, ev.field_70161_v, 0.0f, 0.0f);
            this.world.func_72838_d((Entity)entityvillager);
            this.world.func_72960_a((Entity)entityvillager, (byte)12);
        }
    }

    public boolean tick(int tickCounter) {
        Village v;
        if (tickCounter % 20 == 0 && (v = this.getVillage()) != null) {
            if (tickCounter % (20 * BALANCE.VV_PROP.REDUCE_RATE) == 0) {
                if (this.recentlyBitten > 0) {
                    --this.recentlyBitten;
                    this.dirty = true;
                    this.spawnVillager(v);
                }
                if (this.recentlyConverted > 0) {
                    --this.recentlyConverted;
                    this.dirty = true;
                    this.spawnVillager(v);
                }
            }
            if (tickCounter % 900 == 0) {
                this.checkHunterCount(v);
            }
            if (this.recentlyBitten > BALANCE.VV_PROP.BITTEN_UNTIL_AGRESSIVE || this.recentlyConverted > BALANCE.VV_PROP.CONVERTED_UNTIL_AGRESSIVE) {
                if (!this.agressive) {
                    this.makeAgressive(v);
                }
            } else if (!(!this.agressive || this.recentlyBitten != 0 && this.recentlyBitten >= BALANCE.VV_PROP.BITTEN_UNTIL_AGRESSIVE - 1 || this.recentlyConverted != 0 && this.recentlyConverted >= BALANCE.VV_PROP.CONVERTED_UNTIL_AGRESSIVE - 1)) {
                this.makeCalm(v);
            }
        }
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    public void villagerBitten() {
        ++this.recentlyBitten;
        this.dirty = true;
    }

    public void villagerConvertedByVampire() {
        ++this.recentlyConverted;
        this.dirty = true;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("CX", this.center.field_71574_a);
        nbt.func_74768_a("CY", this.center.field_71572_b);
        nbt.func_74768_a("CZ", this.center.field_71573_c);
        nbt.func_74757_a("AGR", this.agressive);
        nbt.func_74768_a("BITTEN", this.recentlyBitten);
        nbt.func_74768_a("CONVERTED", this.recentlyConverted);
    }
}

