/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.CarbonationBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.JuJuExtensions;
import org.jwaresoftware.mcmods.vfp.agents.LavaSandFuelHandler;
import org.jwaresoftware.mcmods.vfp.agents.RennetBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.SaltBuildHelper;
import org.jwaresoftware.mcmods.vfp.agents.WaterBottlesBuildHelper;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;
import org.jwaresoftware.mcmods.vfp.milk.MilkPortion;

public final class AgentsBuildHelper
extends VfpBuildHelperSupport {
    private WaterBottlesBuildHelper _waterHelper = new WaterBottlesBuildHelper();
    private RennetBuildHelper _rennetHelper = new RennetBuildHelper();
    private SaltBuildHelper _saltHelper = new SaltBuildHelper();
    private CarbonationBuildHelper _carbHelper = new CarbonationBuildHelper();
    private JuJuExtensions _jujuHelper = new JuJuExtensions();

    @Override
    protected String categoryName() {
        return "Additives";
    }

    @Override
    public void doBuildEventBusHandlers(FMLStateEvent event, VfpRuntime runtime) {
        GameRegistry.registerFuelHandler((IFuelHandler)new LavaSandFuelHandler());
        this._waterHelper.doBuildEventBusHandlers(event, runtime);
        this._saltHelper.doBuildEventBusHandlers(event, runtime);
        this._carbHelper.doBuildEventBusHandlers(event, runtime);
        this._rennetHelper.doBuildEventBusHandlers(event, runtime);
        this._jujuHelper.doBuildEventBusHandlers(event, runtime);
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        Item[] seeds;
        VfpConfig config = runtime.getConfig();
        VfpObj.Bit_Pipette_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Bit_Pipette);
        OreDictionary.registerOre((String)"itemBitMeasure", (Item)VfpObj.Bit_Pipette_obj);
        VfpObj.Dried_Seeds_obj = VfpBuilder.newItem(VfpOid.Dried_Seeds);
        OreDictionary.registerOre((String)"additiveScaffold", (Item)VfpObj.Dried_Seeds_obj);
        VfpObj.Whisk_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Whisk);
        OreDictionary.registerOre((String)"itemWhisk", (Item)VfpObj.Whisk_obj);
        VfpObj.Portion_Sugar_obj = VfpBuilder.newAdditive(VfpOid.Portion_Sugar);
        OreDictionary.registerOre((String)"portionSugarSmall", (Item)VfpObj.Portion_Sugar_obj);
        VfpObj.Fermenting_Bucket_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Fermenting_Bucket);
        OreDictionary.registerOre((String)"itemFermentingBucket", (Item)VfpObj.Fermenting_Bucket_obj);
        OreDictionary.registerOre((String)"foodApple", (Item)MinecraftGlue.Items_apple);
        VfpObj.Heat_Portion_obj = VfpBuilder.newMisc(VfpOid.Heat_Portion);
        VfpObj.Lava_Sand_Portion_obj = VfpBuilder.newMisc(VfpOid.Lava_Sand_Portion);
        VfpObj.Lava_Sand_Pack_obj = VfpBuilder.newMisc(VfpOid.Lava_Sand_Pack);
        VfpObj.Lava_Sand_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Lava_Sand_Block, MinecraftGlue.Blocks_sand, VfpObj.Lava_Sand_Pack_obj, MinecraftGlue.CreativeTabs_misc);
        VfpObj.Lava_Sand_BlockItem_obj = Item.func_150898_a((Block)VfpObj.Lava_Sand_Block_obj);
        OreDictionary.registerOre((String)"portionHeatSmall", (Item)VfpObj.Heat_Portion_obj);
        OreDictionary.registerOre((String)"portionHeat", (Item)VfpObj.Lava_Sand_Portion_obj);
        OreDictionary.registerOre((String)"portionHeatLarge", (Item)MinecraftGlue.Items_lava_bucket);
        VfpObj.Water_Portion_obj = VfpBuilder.newPortion(VfpOid.Water_Portion);
        OreDictionary.registerOre((String)"portionWaterSmall", (Item)VfpObj.Water_Portion_obj);
        OreDictionary.registerOre((String)"portionWater", (ItemStack)VfpObj.Water_Bottle_obj);
        OreDictionary.registerOre((String)"portionWaterLarge", (Item)VfpObj.Water_Bucket_obj);
        OreDictionary.registerOre((String)"itemEmptyBottle", (Item)VfpObj.Empty_Bottle_obj);
        if (config.enablePotionWaterAsPlainWater()) {
            OreDictionary.registerOre((String)"itemWaterBottle", (ItemStack)VfpObj.Water_Bottle_obj);
        }
        OreDictionary.registerOre((String)"additiveFermenting", (Block)MinecraftGlue.Blocks_brown_mushroom);
        OreDictionary.registerOre((String)"additiveFermenting", (Block)MinecraftGlue.Blocks_red_mushroom);
        for (Item seed : seeds = new Item[]{MinecraftGlue.Items_wheat_seeds, MinecraftGlue.Items_melon_seeds, MinecraftGlue.Items_pumpkin_seeds, MinecraftGlue.Items_beetroot_seeds}) {
            OreDictionary.registerOre((String)"additiveScaffold", (Item)seed);
            OreDictionary.registerOre((String)"itemDryableSeed", (Item)seed);
        }
        VfpObj.Leavening_Agent_obj = VfpBuilder.newAdditive(VfpOid.Leavening_Agent);
        VfpObj.Leavening_Agent_Ball_obj = VfpBuilder.newAdditive(VfpOid.Leavening_Agent_Ball);
        VfpObj.Leavening_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Leavening_Agent_Pantry_Block, VfpObj.Leavening_Agent_Ball_obj);
        OreDictionary.registerOre((String)"blockLeaveningAgent", (Block)VfpObj.Leavening_Agent_Pantry_Block_obj);
        OreDictionary.registerOre((String)"ingotLeaveningAgent", (Item)VfpObj.Leavening_Agent_Ball_obj);
        OreDictionary.registerOre((String)"additiveLeavening", (Item)VfpObj.Leavening_Agent_obj);
        VfpObj.Drying_Agent_Unprocessed_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Unprocessed);
        VfpObj.Drying_Agent_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent);
        VfpObj.Drying_Agent_Ball_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Ball);
        VfpObj.Drying_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Drying_Agent_Pantry_Block, VfpObj.Drying_Agent_Ball_obj);
        VfpObj.Drying_Agent_Unprocessed_Ball_obj = VfpBuilder.newAdditive(VfpOid.Drying_Agent_Unprocessed_Ball);
        OreDictionary.registerOre((String)"itemPoisonousPotato", (Item)MinecraftGlue.Items_poisonous_potato);
        OreDictionary.registerOre((String)"additiveDrying", (Item)VfpObj.Drying_Agent_obj);
        OreDictionary.registerOre((String)"ingotDryingAgent", (Item)VfpObj.Drying_Agent_Ball_obj);
        OreDictionary.registerOre((String)"blockDryingAgent", (Block)VfpObj.Drying_Agent_Pantry_Block_obj);
        this._waterHelper.doBuildPrimaryObjects(event, runtime);
        this._saltHelper.doBuildPrimaryObjects(event, runtime);
        this._carbHelper.doBuildPrimaryObjects(event, runtime);
        this._rennetHelper.doBuildPrimaryObjects(event, runtime);
        VfpObj.Fizzing_Agent_obj = VfpBuilder.newAdditive(VfpOid.Fizzing_Agent);
        VfpObj.Fizzing_Agent_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Fizzing_Agent_Pantry_Block, MinecraftGlue.Blocks_sand, VfpObj.Fizzing_Agent_obj, null);
        OreDictionary.registerOre((String)"ingredientSweetener", (Item)VfpObj.Sugar_obj);
        OreDictionary.registerOre((String)"ingredientEgg", (Item)MinecraftGlue.Items_egg);
        OreDictionary.registerOre((String)"foodSimpleEgg", (Item)MinecraftGlue.Items_egg);
        IntegrationsImpl.registerAsBread(MinecraftGlue.Items_bread, true, new String[0]);
        OreDictionary.registerOre((String)"ingredientInk", (ItemStack)VfpObj.Ink_Sac_obj);
        OreDictionary.registerOre((String)"foodBush", (ItemStack)new ItemStack(MinecraftGlue.Blocks_tallgrass, 1, BlockTallGrass.EnumType.FERN.func_177044_a()));
        OreDictionary.registerOre((String)"foodBush", (ItemStack)new ItemStack(MinecraftGlue.Blocks_tallgrass, 1, BlockTallGrass.EnumType.GRASS.func_177044_a()));
        OreDictionary.registerOre((String)"foodBeets", (Item)MinecraftGlue.Items_beetroot);
        OreDictionary.registerOre((String)"foodPotato", (Item)MinecraftGlue.Items_baked_potato);
        OreDictionary.registerOre((String)"foodCarrot", (Item)MinecraftGlue.Items_carrot);
        OreDictionary.registerOre((String)"rottenflesh", (Item)MinecraftGlue.Items_rotten_flesh);
        OreDictionary.registerOre((String)"ingredientCereal", (Item)MinecraftGlue.Items_wheat);
        OreDictionary.registerOre((String)"foodCookie", (Item)MinecraftGlue.Items_cookie);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Block)MinecraftGlue.Blocks_brown_mushroom);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Block)MinecraftGlue.Blocks_red_mushroom);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Item)MinecraftGlue.Items_carrot);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Item)MinecraftGlue.Items_potato);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Item)MinecraftGlue.Items_apple);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Item)MinecraftGlue.Items_beetroot);
        OreDictionary.registerOre((String)"ingredientKebabFruit", (Item)MinecraftGlue.Items_apple);
        OreDictionary.registerOre((String)"ingredientKebabFruit", (Item)MinecraftGlue.Items_melon);
        OreDictionary.registerOre((String)"ingredientKebabMain", (Item)MinecraftGlue.Items_potato);
        OreDictionary.registerOre((String)"ingredientKebabMain", (Item)MinecraftGlue.Items_baked_potato);
        OreDictionary.registerOre((String)"ingredientChowderMain", (ItemStack)new ItemStack(MinecraftGlue.Items_cooked_fish, 1, ItemFishFood.FishType.SALMON.func_150976_a()));
        OreDictionary.registerOre((String)"ingredientChowderFill", (ItemStack)new ItemStack(MinecraftGlue.Items_cooked_fish, 1, ItemFishFood.FishType.COD.func_150976_a()));
        this.identifyOtherPowders(config);
        VfpObj.FoodPowders_obj = FoodPowders.get(config);
        VfpObj.Milk_Portion_obj = new MilkPortion();
        OreDictionary.registerOre((String)"portionMilkSmall", (Item)VfpObj.Milk_Portion_obj);
        OreDictionary.registerOre((String)"portionMilkLarge", (Item)MinecraftGlue.Items_milk_bucket);
        this._jujuHelper.doBuildPrimaryObjects(event, runtime);
    }

    @Override
    public void doBuildSecondaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        List<String> mappings = config.capturedContextOres();
        this.identifyEdibleFlowers(mappings, config);
        this.identifyMushrooms(mappings, config);
        this.doOtherModAdditiveScaffolding(mappings, "Corn", "Hops", "Soybean");
        this.identifyMeats(mappings, config);
        this.identifyOtherKebabItems(mappings, config);
        this._waterHelper.doBuildSecondaryObjects(event, runtime);
        this._saltHelper.doBuildSecondaryObjects(event, runtime);
        this._carbHelper.doBuildSecondaryObjects(event, runtime);
        this._rennetHelper.doBuildSecondaryObjects(event, runtime);
        this._jujuHelper.doBuildSecondaryObjects(event, runtime);
    }

    @Override
    public void doInitLikeFoods(VfpRuntime runtime) {
        this._waterHelper.doInitLikeFoods(runtime);
        this._saltHelper.doInitLikeFoods(runtime);
        this._carbHelper.doInitLikeFoods(runtime);
        this._rennetHelper.doInitLikeFoods(runtime);
        this._jujuHelper.doInitLikeFoods(runtime);
    }

    @Override
    public void doDefineLoot(VfpRuntime runtime) {
        this._waterHelper.doDefineLoot(runtime);
        this._saltHelper.doDefineLoot(runtime);
        this._carbHelper.doDefineLoot(runtime);
        this._rennetHelper.doDefineLoot(runtime);
        this._jujuHelper.doDefineLoot(runtime);
    }

    @Override
    public void doBuildRecipes(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        int additive_count = VfpCapacity.ADDITIVE_BATCH.count();
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Bit_Pipette_obj), new Object[]{" g", "gb", Character.valueOf('b'), MinecraftGlue.Items_bowl, Character.valueOf('g'), "blockGlass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Bit_Pipette_obj), new Object[]{"sg", "gb", Character.valueOf('b'), MinecraftGlue.Items_bowl, Character.valueOf('g'), "paneGlass", Character.valueOf('s'), "stickWood"}));
        Object[][] bit_ingredients = config.isSuperCompatibilityMode() ? new Object[][]{{null, VfpObj.Bit_Pipette_obj}} : new Object[][]{{null}, {null, VfpObj.Bit_Pipette_obj}};
        for (int i = 0; i < bit_ingredients.length; ++i) {
            bit_ingredients[i][0] = "itemWaterBottle";
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Water_Portion_obj, VfpCapacity.BOTTLE.count()), bit_ingredients[i]));
            bit_ingredients[i][0] = "portionWaterLarge";
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Water_Portion_obj, VfpCapacity.BUCKET.count()), bit_ingredients[i]));
            bit_ingredients[i][0] = "portionMilkLarge";
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Milk_Portion_obj, VfpCapacity.BUCKET.count()), bit_ingredients[i]));
            bit_ingredients[i][0] = "portionHeatLarge";
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Heat_Portion_obj, VfpCapacity.MAX_STACK.count()), bit_ingredients[i]));
            bit_ingredients[i][0] = VfpObj.Sugar_obj;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Portion_Sugar_obj, VfpCapacity.PINCHES_BATCH.count()), bit_ingredients[i]));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Lava_Sand_Portion_obj, 16), new Object[]{"xx", "Lm", Character.valueOf('x'), "sand", Character.valueOf('L'), "portionHeatLarge", Character.valueOf('m'), VfpObj.Bit_Pipette_obj}));
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.PORTABLE, (Object)VfpObj.Lava_Sand_Portion_obj, VfpObj.Lava_Sand_Pack_obj, VfpObj.Lava_Sand_Portion_obj);
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Lava_Sand_Pack_obj, VfpObj.Lava_Sand_Block_obj, VfpObj.Lava_Sand_Pack_obj);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Heat_Portion_obj, VfpCapacity.MAX_STACK_LCD.count()), new Object[]{"portionHeat"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Dried_Seeds_obj, 3), new Object[]{"xx", "xd", Character.valueOf('x'), "itemDryableSeed", Character.valueOf('d'), VfpObj.Drying_Agent_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Dried_Seeds_obj, VfpCapacity.DENSE_CRYSTAL_BATCH.count()), new Object[]{VfpObj.Sunflower_plant_obj, VfpObj.Drying_Agent_Ball_obj}));
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Leavening_Agent_obj, additive_count), new Object[]{"xx", "fs", Character.valueOf('x'), "additiveScaffold", Character.valueOf('f'), "additiveFermenting", Character.valueOf('s'), "portionSugarSmall"}), VfpOid.Leavening_Agent.craftingXp()));
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Leavening_Agent_obj, VfpObj.Leavening_Agent_Ball_obj, VfpObj.Leavening_Agent_obj);
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Leavening_Agent_Ball_obj, VfpObj.Leavening_Agent_Pantry_Block_obj, VfpObj.Leavening_Agent_Ball_obj);
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Drying_Agent_Unprocessed_obj, additive_count), new Object[]{"xx", "pc", Character.valueOf('x'), "additiveScaffold", Character.valueOf('p'), "itemPoisonousPotato", Character.valueOf('c'), MinecraftGlue.Blocks_cactus}), VfpOid.Drying_Agent_Unprocessed.craftingXp()));
        GameRegistry.addSmelting((Item)VfpObj.Drying_Agent_Unprocessed_obj, (ItemStack)new ItemStack(VfpObj.Drying_Agent_obj), (float)LikeFood.seed.smeltExperience());
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Drying_Agent_obj, VfpObj.Drying_Agent_Ball_obj, VfpObj.Drying_Agent_obj);
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Drying_Agent_Ball_obj, VfpObj.Drying_Agent_Pantry_Block_obj, VfpObj.Drying_Agent_Ball_obj);
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Drying_Agent_Unprocessed_obj, VfpObj.Drying_Agent_Unprocessed_Ball_obj, VfpObj.Drying_Agent_Unprocessed_obj);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Fermenting_Bucket_obj), new Object[]{"gg", "gb", Character.valueOf('g'), "blockGlass", Character.valueOf('b'), "itemEmptyBucket"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Whisk_obj), new Object[]{"is", " i", Character.valueOf('s'), "stickWood", Character.valueOf('i'), "smuggetIron"}));
        this._waterHelper.doBuildRecipes(runtime);
        this._saltHelper.doBuildRecipes(runtime);
        this._carbHelper.doBuildRecipes(runtime);
        FoodPowders.autorecipe(config);
        this._rennetHelper.doBuildRecipes(runtime);
        this._jujuHelper.doBuildRecipes(runtime);
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        VfpRewards.addRewardingCraftItem(VfpObj.Drying_Agent_Unprocessed_obj, VfpAchievements.Id.PantryBegun);
        VfpRewards.addRewardingCraftItem(VfpObj.Leavening_Agent_obj, VfpAchievements.Id.PantryBegun);
        VfpRewards.addRewardingCraftItem(VfpObj.Fizzing_Agent_obj, VfpAchievements.Id.PantryBegun);
        if (config.isSuperCompatibilityMode()) {
            VfpRewards.addRewardingCraftItem(VfpObj.Water_Portion_obj, VfpAchievements.Id.PortionInTime);
            VfpRewards.addRewardingCraftItem(VfpObj.Milk_Portion_obj, VfpAchievements.Id.PortionInTime);
            VfpRewards.addRewardingCraftItem(VfpObj.Heat_Portion_obj, VfpAchievements.Id.PortionInTime);
        }
        this._waterHelper.doBuildAchievementList(event, runtime);
        this._saltHelper.doBuildAchievementList(event, runtime);
        this._carbHelper.doBuildAchievementList(event, runtime);
        this._rennetHelper.doBuildAchievementList(event, runtime);
        this._jujuHelper.doBuildAchievementList(event, runtime);
    }

    @Override
    public void doInitRenderModels(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bit_Pipette, VfpObj.Bit_Pipette_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Dried_Seeds, VfpObj.Dried_Seeds_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fermenting_Bucket, VfpObj.Fermenting_Bucket_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Whisk, VfpObj.Whisk_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Heat_Portion, VfpObj.Heat_Portion_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Lava_Sand_Portion, VfpObj.Lava_Sand_Portion_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Lava_Sand_Pack, VfpObj.Lava_Sand_Pack_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Lava_Sand_Block, VfpObj.Lava_Sand_Block_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Water_Portion, VfpObj.Water_Portion_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Milk_Portion, VfpObj.Milk_Portion_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Sugar, VfpObj.Portion_Sugar_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Leavening_Agent, VfpObj.Leavening_Agent_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Leavening_Agent_Ball, VfpObj.Leavening_Agent_Ball_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Leavening_Agent_Pantry_Block, VfpObj.Leavening_Agent_Pantry_Block_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Drying_Agent_Unprocessed, VfpObj.Drying_Agent_Unprocessed_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Drying_Agent, VfpObj.Drying_Agent_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Drying_Agent_Ball, VfpObj.Drying_Agent_Ball_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Drying_Agent_Pantry_Block, VfpObj.Drying_Agent_Pantry_Block_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Drying_Agent_Unprocessed_Ball, VfpObj.Drying_Agent_Unprocessed_Ball_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fizzing_Agent, VfpObj.Fizzing_Agent_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fizzing_Agent_Pantry_Block, VfpObj.Fizzing_Agent_Pantry_Block_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.FoodPowder, VfpObj.FoodPowders_obj, FoodPowders.variants());
        }
        this._waterHelper.doInitRenderModels(event, runtime);
        this._saltHelper.doInitRenderModels(event, runtime);
        this._carbHelper.doInitRenderModels(event, runtime);
        this._rennetHelper.doInitRenderModels(event, runtime);
        this._jujuHelper.doInitRenderModels(event, runtime);
    }

    @Override
    public void doFinish(FMLStateEvent event, VfpRuntime runtime) {
        this._waterHelper.doFinish(event, runtime);
        this._saltHelper.doFinish(event, runtime);
        this._carbHelper.doFinish(event, runtime);
        this._rennetHelper.doFinish(event, runtime);
        this._jujuHelper.doFinish(event, runtime);
    }

    private void doOtherModAdditiveScaffolding(List<String> mappings, String ... cropNames) {
        for (String cropName : cropNames) {
            String seedName = "seed" + cropName;
            if (!mappings.contains(seedName)) continue;
            NonNullList seeds = OreDictionary.getOres((String)seedName);
            for (ItemStack seed : seeds) {
                if (seed.func_77948_v() || seed.func_77981_g()) continue;
                OreDictionary.registerOre((String)"itemDryableSeed", (ItemStack)seed);
            }
        }
    }

    private void identifyMushrooms(List<String> mappings, VfpConfig config) {
        OreDictionary.registerOre((String)"foodMushroom", (Block)MinecraftGlue.Blocks_brown_mushroom);
        OreDictionary.registerOre((String)"ingredientMushroom", (Block)MinecraftGlue.Blocks_brown_mushroom);
        OreDictionary.registerOre((String)"foodMushroom", (Block)MinecraftGlue.Blocks_red_mushroom);
        OreDictionary.registerOre((String)"ingredientMushroom", (Block)MinecraftGlue.Blocks_red_mushroom);
        IntegrationsImpl.registerMushrooms(mappings, config);
    }

    private void identifyMeats(List<String> mappings, VfpConfig config) {
        OreDictionary.registerOre((String)"foodChicken", (Item)MinecraftGlue.Items_chicken);
        OreDictionary.registerOre((String)"foodChickenCooked", (Item)MinecraftGlue.Items_cooked_chicken);
        OreDictionary.registerOre((String)"foodRedMeat", (Item)MinecraftGlue.Items_beef);
        OreDictionary.registerOre((String)"foodRedMeatCooked", (Item)MinecraftGlue.Items_cooked_beef);
        OreDictionary.registerOre((String)"foodBeefsteakCooked", (Item)MinecraftGlue.Items_cooked_beef);
        OreDictionary.registerOre((String)"foodRedMeat", (Item)MinecraftGlue.Items_mutton);
        OreDictionary.registerOre((String)"foodRedMeatCooked", (Item)MinecraftGlue.Items_cooked_mutton);
        OreDictionary.registerOre((String)"foodNativeGameMeatCooked", (Item)MinecraftGlue.Items_cooked_beef);
        OreDictionary.registerOre((String)"foodNativeGameMeatCooked", (Item)MinecraftGlue.Items_cooked_mutton);
        OreDictionary.registerOre((String)"foodNativeGameMeatCooked", (Item)MinecraftGlue.Items_cooked_rabbit);
        IntegrationsImpl.registerRedMeat(mappings, config);
    }

    private void identifyEdibleFlowers(List<String> mappings, VfpConfig config) {
        BlockFlower.EnumFlowerType[] selections = new BlockFlower.EnumFlowerType[]{BlockFlower.EnumFlowerType.RED_TULIP, BlockFlower.EnumFlowerType.ORANGE_TULIP, BlockFlower.EnumFlowerType.WHITE_TULIP, BlockFlower.EnumFlowerType.PINK_TULIP};
        for (int i = 0; i < selections.length; ++i) {
            ItemStack flower = new ItemStack(MinecraftGlue.Blocks_red_flower, 1, selections[i].func_176968_b());
            OreDictionary.registerOre((String)"foodFlower", (ItemStack)flower);
            OreDictionary.registerOre((String)"ingredientFlower", (ItemStack)flower);
        }
        OreDictionary.registerOre((String)"foodRoseFlower", (ItemStack)VfpObj.Rose_plant_obj);
        OreDictionary.registerOre((String)"ingredientRoseFlower", (ItemStack)VfpObj.Rose_plant_obj);
        IntegrationsImpl.registerEdibleFlowers(mappings, config);
    }

    private void identifyOtherPowders(VfpConfig config) {
        boolean debug = config.isDebugMode();
        if (debug) {
            for (FoodPowders.Type fpt_ : FoodPowders.Type.orderedValues()) {
                FMLLog.finer((String)"ALL(a) FoodPowder: '%s'", (Object[])new Object[]{fpt_});
            }
        }
        FoodPowders.Type.checkReservedPowderCount();
        IntegrationsImpl.registerFoodPowders(config.capturedContextOres(), config);
        if (debug) {
            for (FoodPowders.Type fpt_ : FoodPowders.Type.orderedValues()) {
                FMLLog.finer((String)"ALL(b) FoodPowder: '%s'", (Object[])new Object[]{fpt_});
            }
        }
    }

    private void identifyOtherKebabItems(List<String> mappings, VfpConfig config) {
        IntegrationsImpl.registerKebabItems(mappings, config);
    }
}

