/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.biome.BiomeSwamp;
import net.minecraftforge.common.BiomeDictionary;
import org.jwaresoftware.mcmods.vfp.agents.Water;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class EmptyBottle
extends VfpPlainItem {
    public EmptyBottle() {
        super((VfpProfile)VfpOid.Empty_Bottle, MinecraftGlue.CreativeTabs_misc);
    }

    private static boolean isSwampishBiomeAtPos(World world, BlockPos blockpos) {
        Biome biome = world.func_180494_b(blockpos);
        return biome instanceof BiomeJungle || biome instanceof BiomeSwamp || MinecraftGlue.isBiomeLike(biome, Biomes.field_76780_h, BiomeDictionary.Type.DENSE);
    }

    protected ItemStack getNewFilledBottle(World world, BlockPos blockpos) {
        return EmptyBottle.isSwampishBiomeAtPos(world, blockpos) ? Water.swamp(1) : Water.plain(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (MinecraftGlue.ItemStacks_isEmpty(stack)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult mop = this.func_77621_a(world, player, true);
        ActionResult result = ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = mop.func_178782_a();
            if (!world.func_175660_a(player, blockpos)) {
                return result;
            }
            if (!player.func_175151_a(blockpos.func_177972_a(mop.field_178784_b), mop.field_178784_b, stack)) {
                return result;
            }
            if (world.func_180495_p(blockpos).func_185904_a() == MinecraftGlue.Material_water) {
                MinecraftGlue.Effects.playBottleOfWaterScoopedUp(world, player);
                ItemStack filledBottle = this.getNewFilledBottle(world, blockpos);
                if (filledBottle == null) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
                }
                player.func_71029_a(StatList.func_188057_b((Item)this));
                if (MinecraftGlue.ItemStacks_decrBy(stack, 1)) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)filledBottle);
                }
                if (!player.field_71071_by.func_70441_a(filledBottle)) {
                    player.func_71019_a(filledBottle, false);
                }
            }
        }
        return result;
    }
}

