/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public final class JJJJar
extends VfpPlainItem {
    public static final int DEFAULT_MAX_USES = 3;
    private final int _MAX_USES;

    public JJJJar(VfpProfile oid, int max_uses) {
        super(oid);
        Validate.isTrue((max_uses > 1 ? 1 : 0) != 0);
        this._MAX_USES = max_uses;
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public JJJJar(VfpProfile oid) {
        this(oid, 3);
    }

    private static void assignForgeIds(JJJJar jar, String ... ingredientNames) {
        if (ingredientNames != null && ingredientNames.length > 0) {
            int[] metas = jar.getUsesRenderMetas();
            for (String ingredientName : ingredientNames) {
                for (int i = 0; i < metas.length; ++i) {
                    ItemStack level = new ItemStack((Item)jar, 1, metas[i]);
                    OreDictionary.registerOre((String)ingredientName, (ItemStack)level);
                }
            }
        }
    }

    public static JJJJar newJar(VfpProfile oid, int uses, String ... ingredientNames) {
        if (uses <= 0) {
            uses = 3;
        }
        JJJJar jar = new JJJJar(oid, uses).autoregister(JJJJar.class);
        JJJJar.assignForgeIds(jar, ingredientNames);
        return jar;
    }

    public static JJJJar newJar(VfpProfile oid, String ... ingredientNames) {
        JJJJar jar = new JJJJar(oid).autoregister(JJJJar.class);
        JJJJar.assignForgeIds(jar, ingredientNames);
        return jar;
    }

    public final int MAX_USES() {
        return this._MAX_USES;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77960_j() > 0;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        int at = stack.func_77960_j();
        ItemStack out = MinecraftGlue.ItemStacks_NULLSTACK();
        if (at > 1) {
            out = new ItemStack(stack.func_77973_b(), 1, at - 1);
            MinecraftGlue.ItemStacks_copyDisplayName(stack, out);
        } else if (at == 1) {
            Item emptyJar = VfpObj.Empty_Jar_obj;
            if (super.func_77668_q() != null) {
                emptyJar = super.func_77668_q();
            }
            out = new ItemStack(emptyJar);
        }
        return out;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        int at = stack.func_77960_j();
        if (at > 0) {
            tooltip.add(MinecraftGlue.Strings.translate("multiuse.use." + at));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (tab == null || tab == this.func_77640_w()) {
            subItems.add((Object)new ItemStack(item, 1, this.MAX_USES()));
        }
    }

    public final int[] getUsesRenderMetas() {
        int _max_uses = this.MAX_USES();
        int[] metas = new int[_max_uses];
        for (int i = 1; i <= _max_uses; ++i) {
            metas[i - 1] = i;
        }
        return metas;
    }

    public final String[] getUsesRenderNames() {
        int _max_uses = this.MAX_USES();
        String[] names = new String[_max_uses];
        for (int i = 1; i <= _max_uses; ++i) {
            names[i - 1] = "vanillafoodpantry:" + this._oid.fmlid() + "_" + i + "of" + _max_uses;
        }
        return names;
    }

    public static final ItemStack full(Item instance, int amount) {
        return new ItemStack(instance, amount, ((JJJJar)instance).MAX_USES());
    }

    public static final void registerAllUnder(String forgeid, Item instance) {
        JJJJar jar = (JJJJar)instance;
        int[] metas = jar.getUsesRenderMetas();
        for (int i = 0; i < metas.length; ++i) {
            ItemStack damaged = new ItemStack((Item)jar, 1, metas[i]);
            OreDictionary.registerOre((String)forgeid, (ItemStack)damaged);
        }
    }
}

