/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;

@Optional.InterfaceList(value={@Optional.Interface(iface="squeek.applecore.api.food.IEdible", modid="applecore")})
public final class FoodPortion
extends ItemFood
implements IEdible {
    private static final ThreadLocal<FoodPortion> _currentFoodPortion = new ThreadLocal();
    private final int _foodValue;
    private final float _foodSaturation;

    @Optional.Method(modid="applecore")
    @Nullable
    public static FoodValues getCurrentThreadFoodValues() {
        FoodPortion fp = _currentFoodPortion.get();
        return fp != null ? new FoodValues(fp._foodValue, fp._foodSaturation) : null;
    }

    public FoodPortion(int foodAmount, float foodSaturation) {
        super(foodAmount, foodSaturation, false);
        this.func_77655_b("gen_anyfood_portion");
        this.func_77637_a(null);
        this._foodValue = foodAmount;
        this._foodSaturation = foodSaturation;
    }

    @Optional.Method(modid="applecore")
    public FoodValues getFoodValues(@Nonnull ItemStack stack) {
        return new FoodValues(this._foodValue, this._foodSaturation);
    }

    @Optional.Method(modid="applecore")
    private void onConsumedViaACStats(ItemStack eaten, World world, EntityPlayer player) {
        player.func_71024_bL().func_151686_a((ItemFood)this, eaten);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onConsumed(ItemStack eaten, int foodAmount, float foodSaturation, World world, EntityPlayer player) {
        if (Loader.isModLoaded((String)"applecore")) {
            FoodPortion portion = new FoodPortion(foodAmount, foodSaturation);
            _currentFoodPortion.set(portion);
            try {
                portion.onConsumedViaACStats(eaten, world, player);
            }
            finally {
                _currentFoodPortion.set(null);
                portion = null;
            }
        } else {
            player.func_71024_bL().func_75122_a(foodAmount, foodSaturation);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
    }

    @Optional.Method(modid="applecore")
    @Nullable
    private static FoodPortion toACEdible(ItemStack stack, Item item) {
        FoodPortion adapter = null;
        if (item instanceof IEdible) {
            FoodValues fv = ((IEdible)item).getFoodValues(stack);
            adapter = new FoodPortion(fv.hunger, fv.saturationModifier);
        }
        return adapter;
    }

    @Nullable
    public static ItemFood toFood(@Nonnull ItemStack ingredient) {
        FoodPortion food = null;
        if (!MinecraftGlue.ItemStacks_isEmpty(ingredient)) {
            Item item = ingredient.func_77973_b();
            if (Loader.isModLoaded((String)"applecore")) {
                food = FoodPortion.toACEdible(ingredient, item);
            }
            if (food == null && item instanceof ItemFood) {
                food = (ItemFood)item;
            }
        }
        return food;
    }
}

