/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.Named;

public class Ingredient
implements Named {
    private final int _meta;
    private final String _name;
    private final ItemStack _recipeitem;
    private final boolean _isblock;
    private final boolean _isclsfier;
    private final int _multiplier;
    private int _mask;

    public Ingredient(String name, int id, ItemStack item) {
        this(name, id, item, 1);
    }

    public Ingredient(String name, int id, ItemStack item, int multiplier) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)name) && item != null ? 1 : 0) != 0, (String)"Valid parameters for any ingredient are name and ingredient", (Object[])new Object[0]);
        this._meta = id;
        this._name = name;
        this._recipeitem = item;
        this._isblock = item.func_77973_b() instanceof ItemBlock;
        this._isclsfier = DictionaryNameItemAdaptor.is(item);
        this._multiplier = Math.min(MinecraftGlue.TABLE_CRAFT_GRID_SIZE(), multiplier);
    }

    public Ingredient(String name, int id, String classifier) {
        this(name, id, new ItemStack((Item)new DictionaryNameItemAdaptor(classifier)));
    }

    public Ingredient(String name, int id, String classifier, int amount, int multiplier) {
        this(name, id, new ItemStack((Item)new DictionaryNameItemAdaptor(classifier), amount), multiplier);
    }

    public final int id() {
        return this._meta;
    }

    @Override
    public final String name() {
        return this._name;
    }

    public final ItemStack recipeitem() {
        return this._recipeitem;
    }

    public final int multiplier() {
        return this._multiplier;
    }

    public final boolean isClassifier() {
        return this._isclsfier;
    }

    public final String recipeitemName() {
        return this._isclsfier ? ((DictionaryNameItemAdaptor)this._recipeitem.func_77973_b()).dictionaryName() : null;
    }

    public final int attributes() {
        return this._mask;
    }

    public final void attributes(int newmask) {
        this._mask = newmask;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Ingredient) {
            boolean match;
            Ingredient other = (Ingredient)o;
            Item mine = this._recipeitem.func_77973_b();
            Item theirs = other._recipeitem.func_77973_b();
            boolean bl = match = this._isblock == other._isblock && this._isclsfier == other._isclsfier && this._recipeitem.func_77960_j() == other._recipeitem.func_77960_j() && this._recipeitem.func_77977_a().equals(other._recipeitem.func_77977_a());
            if (match) {
                match = this._isclsfier ? this.recipeitemName().equals(other.recipeitemName()) : (this._isblock ? ((ItemBlock)mine).field_150939_a.getClass().equals(((ItemBlock)theirs).field_150939_a.getClass()) : mine.getClass().equals(theirs.getClass()));
            }
        }
        return false;
    }

    public int hashCode() {
        return 32 * this._meta + this._recipeitem.func_77977_a().hashCode();
    }

    public boolean isEnabled() {
        return !MinecraftGlue.ItemStacks_isEmpty(this._recipeitem);
    }

    public String toString() {
        String enabled = this.isEnabled() ? "Y|" : "N|";
        return enabled + this._name + "@" + this._meta + "[many=" + this._isclsfier + "/x" + this._multiplier + "]";
    }
}

