/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;

public final class PackagedFood
implements Comparable<PackagedFood> {
    private static final Map<String, Integer> TYPE_GROUPS = new Hashtable<String, Integer>();
    private static final Collection<PackagedFood> FOODS = new ArrayList<PackagedFood>(100);
    private static boolean LOCKED;
    public static final PackagedFood BREAD;
    public static final PackagedFood SANDWICHES_HAMEGG;
    public static final PackagedFood CAKE;
    public static final PackagedFood PUMPKIN_PIE;
    public static final PackagedFood COOKIE;
    public static final PackagedFood EGG_PIE;
    public static final PackagedFood XBREAD;
    public static final PackagedFood COCOA_SEED;
    public static final PackagedFood CANE;
    public static final PackagedFood SANDWICHES_FRYEGG;
    public static final PackagedFood SANDWICHES_CHEESE;
    public static final PackagedFood POTATO;
    public static final PackagedFood CARROT;
    public static final PackagedFood MUSHROOM;
    public static final PackagedFood RED_MUSHROOM;
    public static final PackagedFood APPLE;
    public static final PackagedFood EGG;
    public static final PackagedFood COOKED_EGG;
    public static final PackagedFood CHICKEN;
    public static final PackagedFood COOKED_CHICKEN;
    public static final PackagedFood CODFISH;
    public static final PackagedFood COOKED_CODFISH;
    public static final PackagedFood SALMON;
    public static final PackagedFood COOKED_SALMON;
    public static final PackagedFood PORK;
    public static final PackagedFood COOKED_PORK;
    public static final PackagedFood BEEF;
    public static final PackagedFood COOKED_BEEF;
    public static final PackagedFood MUTTON;
    public static final PackagedFood COOKED_MUTTON;
    public static final PackagedFood RABBIT;
    public static final PackagedFood COOKED_RABBIT;
    public static final PackagedFood ROTTEN_FLESH;
    public static final PackagedFood BONES;
    public static final PackagedFood BAD_TATOES;
    public static final PackagedFood HORSE;
    public static final PackagedFood COOKED_HORSE;
    public static final PackagedFood RAW_SUGAR;
    public static final PackagedFood INK_SAC;
    public static final PackagedFood WOLF;
    public static final PackagedFood COOKED_WOLF;
    public static final PackagedFood SQUID;
    public static final PackagedFood COOKED_SQUID;
    public static final PackagedFood PORK_HOCKS;
    public static final PackagedFood COOKED_PORK_HOCKS;
    public static final PackagedFood PIGTAILS;
    public static final PackagedFood LUMINESCE_SAC;
    public static final PackagedFood BEETROOT;
    public static final PackagedFood CHORUSFRUIT;
    public static final PackagedFood LLAMA;
    public static final PackagedFood COOKED_LLAMA;
    private final String _typeid;
    private final int _meta;
    private final String _name;
    private final LikeFood _food;
    private final VfpCapacity _capacity;
    private final Integer _maxstack;
    private final FoodColor _color;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void save(PackagedFood pf) {
        Collection<PackagedFood> collection = FOODS;
        synchronized (collection) {
            for (PackagedFood next : FOODS) {
                if (!next._typeid.equals(pf._typeid) || next._food != pf._food) continue;
                return;
            }
            FOODS.add(pf);
        }
    }

    private PackagedFood(Type type, String name, LikeFood like) {
        this(type.name(), name, like, null);
    }

    PackagedFood(String type, String name, LikeFood like, FoodColor variation) {
        Validate.notNull((Object)like, (String)"A packaged food MUST be backed by a sample food item (LikeFood)", (Object[])new Object[0]);
        this._typeid = type;
        this._meta = PackagedFood.incr(type);
        this._food = like;
        this._name = name;
        this._capacity = null;
        this._maxstack = VfpCapacity.LARGE_STACK.count();
        this._color = variation;
        PackagedFood.save(this);
    }

    private PackagedFood(Type type, String name, LikeFood like, VfpCapacity cap, VfpCapacity max) {
        this(type.name(), name, like, null, cap, max);
    }

    public PackagedFood(String type, String name, LikeFood like, FoodColor variation, VfpCapacity cap, VfpCapacity max) {
        Validate.notNull((Object)like, (String)"A packaged food MUST be backed by a sample food item (LikeFood)", (Object[])new Object[0]);
        this._typeid = type;
        this._meta = PackagedFood.incr(type);
        this._food = like;
        this._name = name;
        this._capacity = cap;
        this._maxstack = max != null ? max.count() : VfpCapacity.LARGE_STACK.count();
        this._color = variation;
        PackagedFood.save(this);
    }

    public final int typemeta() {
        return this._meta;
    }

    public final String type() {
        return this._typeid;
    }

    public final LikeFood food() {
        return this._food;
    }

    public final VfpCapacity capacity() {
        return this._capacity;
    }

    public final boolean typefirst() {
        return this._meta == 0;
    }

    public final String fmlid_suffix() {
        return this._name;
    }

    @Override
    public int compareTo(PackagedFood o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        int i = this._typeid.compareTo(o._typeid);
        if (i == 0) {
            i = this._meta > o._meta ? 1 : (this._meta < o._meta ? -1 : 0);
        }
        return i;
    }

    public String toString() {
        return this._typeid + "/" + this._name + "@" + this._meta + "[cap=" + (Object)((Object)this._capacity) + ",max=" + this._maxstack + "] for " + this._food;
    }

    private static int incr(String typeid) {
        Integer I = TYPE_GROUPS.get(typeid);
        I = I == null ? Integer.valueOf(0) : Integer.valueOf(I + 1);
        TYPE_GROUPS.put(typeid, I);
        return I;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lockdown() {
        boolean locked = false;
        int bad = 0;
        Map<String, Integer> map = TYPE_GROUPS;
        synchronized (map) {
            if (!LOCKED) {
                Type[] types;
                int custom_0th = Type.reservedSlotCount();
                Integer custom_0th_I = custom_0th - 1;
                for (Type type : types = Type.values()) {
                    Integer I = TYPE_GROUPS.get(type.name());
                    if (I == null || custom_0th > I) continue;
                    ++bad;
                }
                if (bad == 0) {
                    for (Type type : types) {
                        TYPE_GROUPS.put(type.name(), custom_0th_I);
                    }
                    locked = true;
                    LOCKED = true;
                }
            }
        }
        return locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shift16() {
        Map<String, Integer> map = TYPE_GROUPS;
        synchronized (map) {
            for (Type type : Type.values()) {
                Integer I = TYPE_GROUPS.get(type.name());
                int i = I / 16 + 1;
                I = ++i * 16 - 1;
                TYPE_GROUPS.put(type.name(), I);
            }
        }
    }

    public static final String[] groups() {
        return TYPE_GROUPS.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static final boolean known(String typeid) {
        return TYPE_GROUPS.containsKey(typeid);
    }

    private static final VfpVariant _new_variant(PackagedFood pf, int index, String fmlid, VfpVariantSet set) {
        VfpVariant variant;
        if (pf._maxstack != null) {
            if (pf._capacity != null) {
                ItemStack food = pf._food.sample().func_77946_l();
                MinecraftGlue.ItemStacks_setSize(food, pf._capacity.count());
                variant = new VfpVariant(index, fmlid, (Object)food, pf._maxstack, set, index == 0);
            } else {
                variant = new VfpVariant(index, fmlid, pf._food, null, pf._maxstack, set, index == 0);
            }
        } else {
            variant = new VfpVariant(index, fmlid, pf._food, pf._capacity, set, index == 0);
        }
        return variant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final VfpVariant[] init(String typeid, VfpVariantSet set, boolean shortnames, int metaoffset, List<PackagedFood> exclusions) {
        if (!PackagedFood.known(typeid)) {
            return null;
        }
        if (exclusions == null) {
            exclusions = Collections.EMPTY_LIST;
        }
        ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(16);
        Collection<PackagedFood> collection = FOODS;
        synchronized (collection) {
            for (PackagedFood pf : FOODS) {
                VfpVariant variant;
                if (!typeid.equals(pf.type()) || exclusions.contains(pf)) continue;
                String fmlid = shortnames ? pf.fmlid_suffix().toLowerCase(Locale.US) : set.typeName() + "_" + pf.fmlid_suffix().toLowerCase(Locale.US);
                if (metaoffset > 0) {
                    int meta = metaoffset + pf._meta;
                    variant = new VfpTransientVariant(meta, fmlid, pf._food, pf._capacity, pf._maxstack, pf._color, null, set);
                } else {
                    int index = exclusions.isEmpty() ? pf._meta : set.size();
                    variant = PackagedFood._new_variant(pf, index, fmlid, set);
                }
                variants.add(variant);
            }
        }
        Collections.sort(variants);
        return variants.toArray(VfpVariant.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final VfpVariant[] init(Type type, VfpVariantSet set, Item containerItem, VfpVariant[] typeMetas, List<PackagedFood> filter, boolean exclusion) {
        if (filter == null) {
            filter = Collections.EMPTY_LIST;
        }
        ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(16);
        Collection<PackagedFood> collection = FOODS;
        synchronized (collection) {
            for (PackagedFood pf : FOODS) {
                if (!type.name().equals(pf.type()) || (!exclusion || filter.contains(pf)) && (exclusion || !filter.contains(pf))) continue;
                String fmlid = set.typeName() + "_" + pf.fmlid_suffix().toLowerCase(Locale.US);
                ItemStack bag = null;
                for (VfpVariant content : typeMetas) {
                    if (content.metadata() != pf._meta + type.shared_metaoffset()) continue;
                    bag = new ItemStack(containerItem, VfpCapacity.TRAY.count(), pf._meta + type.shared_metaoffset());
                    break;
                }
                int index = set.size();
                VfpVariant variant = bag != null ? new VfpVariant(index, fmlid, null, pf._capacity, pf._maxstack, bag, null, set, index == 0) : PackagedFood._new_variant(pf, index, fmlid, set);
                variants.add(variant);
            }
        }
        Collections.sort(variants);
        return variants.toArray(VfpVariant.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final List<PackagedFood> values(String typeid, List<PackagedFood> exclusions) {
        if (!PackagedFood.known(typeid)) {
            return null;
        }
        if (exclusions == null) {
            exclusions = Collections.EMPTY_LIST;
        }
        ArrayList<PackagedFood> matches = new ArrayList<PackagedFood>(16);
        Collection<PackagedFood> collection = FOODS;
        synchronized (collection) {
            for (PackagedFood pf : FOODS) {
                if (!typeid.equals(pf.type()) || exclusions.contains(pf)) continue;
                matches.add(pf);
            }
        }
        Collections.sort(matches);
        return matches;
    }

    static {
        BREAD = new PackagedFood(Type.bakery, "breads", LikeFood.bread);
        SANDWICHES_HAMEGG = new PackagedFood(Type.bakery, "sandwich_hamegg", LikeFood.hamegg_sandwich);
        CAKE = new PackagedFood(Type.bakery, "cakes", LikeFood.cake, VfpCapacity.HALF_TRAY, VfpCapacity.SMALL_STACK);
        PUMPKIN_PIE = new PackagedFood(Type.bakery, "pumpkin_pies", LikeFood.pumpkin_pie, VfpCapacity.BAKERS_TRAY, VfpCapacity.MEDIUM_STACK);
        COOKIE = new PackagedFood(Type.bakery, "cookies", LikeFood.cookie, null, VfpCapacity.BULK_STACK);
        EGG_PIE = new PackagedFood(Type.bakery, "egg_pies", LikeFood.egg_pie, VfpCapacity.BAKERS_TRAY, VfpCapacity.MEDIUM_STACK);
        XBREAD = new PackagedFood(Type.bakery, "enriched_breads", LikeFood.enriched_bread);
        COCOA_SEED = new PackagedFood(Type.bakery, "cocoa", LikeFood.cocoa_seed, null, VfpCapacity.BULK_STACK);
        CANE = new PackagedFood(Type.bakery, "cane", LikeFood.cane_section, null, VfpCapacity.BULK_STACK);
        SANDWICHES_FRYEGG = new PackagedFood(Type.bakery, "sandwich_fryegg", LikeFood.fryegg_sandwich);
        SANDWICHES_CHEESE = new PackagedFood(Type.bakery, "sandwich_cheeze", LikeFood.cheese_sandwich);
        POTATO = new PackagedFood(Type.vegetable, "potatoes", LikeFood.uncooked_potato, null, VfpCapacity.BULK_STACK);
        CARROT = new PackagedFood(Type.vegetable, "carrots", LikeFood.uncooked_carrot, null, VfpCapacity.BULK_STACK);
        MUSHROOM = new PackagedFood(Type.vegetable, "mushrooms", LikeFood.mushroom, null, VfpCapacity.BULK_STACK);
        RED_MUSHROOM = new PackagedFood(Type.vegetable, "red_mushrooms", LikeFood.red_mushroom, null, VfpCapacity.BULK_STACK);
        APPLE = new PackagedFood(Type.fruit, "apples", LikeFood.apple, null, VfpCapacity.BULK_STACK);
        EGG = new PackagedFood(Type.meat, "eggs", LikeFood.uncooked_egg);
        COOKED_EGG = new PackagedFood(Type.cooked_meat, "eggs_cooked", LikeFood.egg);
        CHICKEN = new PackagedFood(Type.meat, "chicken", LikeFood.uncooked_chicken);
        COOKED_CHICKEN = new PackagedFood(Type.cooked_meat, "chicken_cooked", LikeFood.chicken);
        CODFISH = new PackagedFood(Type.meat, "cod", LikeFood.uncooked_fish);
        COOKED_CODFISH = new PackagedFood(Type.cooked_meat, "cod_cooked", LikeFood.fish);
        SALMON = new PackagedFood(Type.meat, "salmon", LikeFood.uncooked_salmon);
        COOKED_SALMON = new PackagedFood(Type.cooked_meat, "salmon_cooked", LikeFood.salmon);
        PORK = new PackagedFood(Type.meat, "pork", LikeFood.uncooked_pork);
        COOKED_PORK = new PackagedFood(Type.cooked_meat, "pork_cooked", LikeFood.pork);
        BEEF = new PackagedFood(Type.meat, "beef", LikeFood.uncooked_beef);
        COOKED_BEEF = new PackagedFood(Type.cooked_meat, "beef_cooked", LikeFood.beef);
        MUTTON = new PackagedFood(Type.meat, "mutton", LikeFood.uncooked_mutton);
        COOKED_MUTTON = new PackagedFood(Type.cooked_meat, "mutton_cooked", LikeFood.mutton);
        RABBIT = new PackagedFood(Type.meat, "rabbit", LikeFood.uncooked_rabbit);
        COOKED_RABBIT = new PackagedFood(Type.cooked_meat, "rabbit_cooked", LikeFood.rabbit);
        ROTTEN_FLESH = new PackagedFood(Type.meat, "rotten_flesh", LikeFood.rotten_flesh, null, VfpCapacity.BULK_STACK);
        BONES = new PackagedFood(Type.meat, "bones", LikeFood.bone, null, VfpCapacity.BULK_STACK);
        BAD_TATOES = new PackagedFood(Type.general, "badpotatoes", LikeFood.bad_potato, null, VfpCapacity.BULK_STACK);
        HORSE = new PackagedFood(Type.meat, "horse", LikeFood.uncooked_horse);
        COOKED_HORSE = new PackagedFood(Type.cooked_meat, "horse_cooked", LikeFood.horse);
        RAW_SUGAR = new PackagedFood(Type.bakery, "hardened_sugar", LikeFood.hardened_sugar);
        INK_SAC = new PackagedFood(Type.liquids, "ink", LikeFood.air, null, VfpCapacity.LIQUID_STACK);
        WOLF = new PackagedFood(Type.meat, "wolf", LikeFood.uncooked_wolf);
        COOKED_WOLF = new PackagedFood(Type.cooked_meat, "wolf_cooked", LikeFood.wolf);
        SQUID = new PackagedFood(Type.meat, "squid", LikeFood.uncooked_squid);
        COOKED_SQUID = new PackagedFood(Type.cooked_meat, "squid_cooked", LikeFood.squid);
        PORK_HOCKS = new PackagedFood(Type.meat, "hocks", LikeFood.uncooked_pork_hocks);
        COOKED_PORK_HOCKS = new PackagedFood(Type.cooked_meat, "hocks_smoked", LikeFood.smoked_pork_hocks);
        PIGTAILS = new PackagedFood(Type.meat, "pigtails", LikeFood.uncooked_pigtail);
        LUMINESCE_SAC = new PackagedFood(Type.liquids, "luminesce", LikeFood.air, null, VfpCapacity.LIQUID_STACK);
        BEETROOT = new PackagedFood(Type.vegetable, "beetroot", LikeFood.uncooked_beetroot, null, VfpCapacity.BULK_STACK);
        CHORUSFRUIT = new PackagedFood(Type.fruit, "chorusfruit", LikeFood.chorus_fruit, null, VfpCapacity.BULK_STACK);
        LLAMA = new PackagedFood(Type.meat, "llama", LikeFood.uncooked_llama);
        COOKED_LLAMA = new PackagedFood(Type.cooked_meat, "llama_cooked", LikeFood.llama);
    }

    public static enum Type {
        meat(1),
        bakery(272),
        vegetable(544),
        fruit(816),
        cooked_meat(1088),
        general(1360),
        powders(1632),
        liquids(1904);

        private final int _offset;

        private Type(int offset) {
            this._offset = offset;
        }

        public int shared_metaoffset() {
            return this._offset;
        }

        public static int reservedSlotCount() {
            return 64;
        }

        public static int leftoverSlotCount() {
            return 272 - Type.reservedSlotCount();
        }

        public static final int idLastUsed() {
            return 6400;
        }

        public static final Type from(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

