/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.VanillaFoodPantry;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.configui.LConfigElement;

public final class VfpConfig {
    static final String _GENERAL = "a Options";
    static final String _BAKERY = "b Bakery";
    static final String _BUTCHER = "c Butcher";
    static final String _PRODUCE = "d Produce";
    static final String _UPSIZER = "e Upsizer";
    static final String _OTHRMOD = "x Integration";
    static final String _MISC = "z Miscellaneous";
    private static final String __DEFAULT_VAL = "*DEFAULT*";
    static final String[] UI_CATEGORIES = new String[]{"a Options", "b Bakery", "c Butcher", "d Produce", "e Upsizer", "x Integration", "z Miscellaneous"};
    private static final VfpConfig _defaultvaluesINSTANCE = new VfpConfig();
    private static VfpConfig _sharedINSTANCE;
    private Configuration _forgeConfig;
    private CreativeTabs _vfpTab;
    private final Map<String, Object> _cache = new HashMap<String, Object>(41);
    private final Map<String, Object> _builderContext = new HashMap<String, Object>();
    private boolean _dontSave;
    private boolean _mcToldRestartIfChanged = false;

    public VfpConfig() {
        this._forgeConfig = new Configuration();
    }

    public VfpConfig(FMLPreInitializationEvent event) {
        File genericLoc = event.getSuggestedConfigurationFile();
        File configFile = new File(genericLoc.getParentFile(), "wabbity_" + genericLoc.getName());
        this._forgeConfig = new Configuration(configFile, "1");
        this._forgeConfig.load();
        this.validateVersion();
    }

    public static final synchronized VfpConfig setInstance(VfpConfig activeConfig) {
        VfpConfig oldConfig = _sharedINSTANCE;
        _sharedINSTANCE = activeConfig;
        return oldConfig;
    }

    public static final synchronized boolean clrInstance(VfpConfig expectedConfig) {
        boolean switched;
        boolean bl = switched = _sharedINSTANCE == expectedConfig;
        if (switched) {
            VfpConfig.setInstance(null);
        }
        return switched;
    }

    public static final synchronized VfpConfig getInstance() {
        VfpConfig c = _sharedINSTANCE;
        if (c == null) {
            c = _defaultvaluesINSTANCE;
        }
        return c;
    }

    public boolean isModLoaded(Integrations mod) {
        return Loader.isModLoaded((String)mod.modid());
    }

    public boolean isModLoaded(String modid) {
        return Loader.isModLoaded((String)modid);
    }

    public final boolean isDebugMode() {
        if (VanillaFoodPantry.DESPERATION_DEBUG) {
            return true;
        }
        String PROPERTY = "debug_mode";
        Boolean b = (Boolean)this._cache.get("a Optionsdebug_mode");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "debug_mode", false, "DEVELOPER. Development messages and tooltips enabled.");
        b = p.getBoolean();
        this._cache.put("a Optionsdebug_mode", b);
        return b;
    }

    public boolean useOwnTab() {
        String PROPERTY = "use_custom_tab";
        Boolean b = (Boolean)this._cache.get("a Optionsuse_custom_tab");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "use_custom_tab", false, "Set to true to force all VFP items and blocks to a single custom 'VFP' tab in creative views. Disabled by default.");
        b = p.getBoolean();
        this._cache.put("a Optionsuse_custom_tab", b);
        return b;
    }

    public void setVfpTab(CreativeTabs tab) {
        this._vfpTab = tab;
        this._builderContext.put("vfpTab", tab);
        VfpUtils.setVfpTabOverride(tab);
    }

    public CreativeTabs getVfpTab() {
        return this._vfpTab;
    }

    public final List<IConfigElement> getConfigElements() {
        String[] categories;
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        for (String category : categories = new String[]{_GENERAL, _BAKERY, _BUTCHER, _PRODUCE, _UPSIZER, _OTHRMOD, _MISC}) {
            list.add((IConfigElement)new LConfigElement(this._forgeConfig.getCategory(category.toLowerCase(Locale.ENGLISH))));
        }
        return list;
    }

    public boolean isSuperCompatibilityMode() {
        String PROPERTY = "super_compatibility_mode";
        Boolean b = (Boolean)this._cache.get("a Optionssuper_compatibility_mode");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "super_compatibility_mode", false, "Set to true to force all the basic recipes to have a mod-specific element to ensure no collisions with other mod recipes; for example, instead of just a bucket of water to make bits o' water, the recipe will require a water bucket and a mod-specific item. OFF by default.");
        b = p.getBoolean();
        this._cache.put("a Optionssuper_compatibility_mode", b);
        return b;
    }

    public boolean includeCraftXpAndAchievements() {
        String PROPERTY = "achievements_and_xp_enabled";
        Boolean b = (Boolean)this._cache.get("a Optionsachievements_and_xp_enabled");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "achievements_and_xp_enabled", true, "Set to false to disable generation of experience and achievements from crafting VFP foods. Note that this option does not affect smelting or mining Xp. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("a Optionsachievements_and_xp_enabled", b);
        return b;
    }

    public boolean generousCraftingXp() {
        String PROPERTY = "generous_xp";
        Boolean b = (Boolean)this._cache.get("a Optionsgenerous_xp");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "generous_xp", true, "Set to false to disable compensation for Minecraft ignoring small amounts of crafting Xp. Note that this option is ignored if crafting Xp is disabled. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("a Optionsgenerous_xp", b);
        return b;
    }

    public boolean isOreGenerationEnabled() {
        String PROPERTY = "ore_generate_enabled";
        Boolean b = (Boolean)this._cache.get("a Optionsore_generate_enabled");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "ore_generate_enabled", true, "Set to false to disable generation of custom VFP ores like rock salt and natron in new worlds and new chunks. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("a Optionsore_generate_enabled", b);
        return b;
    }

    public boolean allowLootTableEnrichment() {
        String PROPERTY = "enrich_loot_tables";
        Boolean b = (Boolean)this._cache.get("a Optionsenrich_loot_tables");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "enrich_loot_tables", true, "Set to false to disable all mod-specific additions to structure and activity loot tables. Changing this affects things like fishing and dungeon loot but NOT custom drops (see individual options). Enabled by default; requires restart if changed in-game.");
        b = p.getBoolean();
        this._cache.put("a Optionsenrich_loot_tables", b);
        return b;
    }

    public boolean alwaysIncludeSimpleFlourRecipe() {
        String PROPERTY = "always_include_simple_flour_recipe";
        Boolean b = (Boolean)this._cache.get("b Bakeryalways_include_simple_flour_recipe");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BAKERY, "always_include_simple_flour_recipe", false, "Set to true to disable the VFP check for a pre-existing flour recipe. Normally VFP will not include its own (1 wheat to 1 flour) recipe if one exists (regardless of what ingredients the other one uses). Disabled by default. Overrides super-compatibility mode.");
        b = p.getBoolean();
        this._cache.put("b Bakeryalways_include_simple_flour_recipe", b);
        return b;
    }

    public boolean alwaysIncludeSimpleFriedEggRecipe() {
        String PROPERTY = "always_include_fried_egg_recipe";
        Boolean b = (Boolean)this._cache.get("c Butcheralways_include_fried_egg_recipe");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "always_include_fried_egg_recipe", false, "Set to true to disable the VFP check for a pre-existing fried egg smelting recipe. Normally VFP will not include its own smelt 1 egg recipe if one exists (regardless of what ingredients or method the other one uses). Disabled by default. Overrides super-compatibility mode.");
        b = p.getBoolean();
        this._cache.put("c Butcheralways_include_fried_egg_recipe", b);
        return b;
    }

    public boolean includePotionBrewing() {
        String PROPERTY = "potions_enabled";
        Boolean b = (Boolean)this._cache.get("a Optionspotions_enabled");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "potions_enabled", true, "Set to false to disable registration of and all recipes for VFP's potions like Wolf's Spirit potion. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("a Optionspotions_enabled", b);
        return b;
    }

    public boolean enablePotionWaterAsPlainWater() {
        String PROPERTY = "allow_potionitem_as_plain_water";
        Boolean b = (Boolean)this._cache.get("a Optionsallow_potionitem_as_plain_water");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "allow_potionitem_as_plain_water", false, "Set to true to enable use of potion water bottles in VFP recipes that require a bottle of water. Disabled by default as a crafting table does not differentiate between brewed potions and the plain potion water bottle.");
        b = p.getBoolean();
        this._cache.put("a Optionsallow_potionitem_as_plain_water", b);
        return b;
    }

    public boolean enableBoneSmelting() {
        String PROPERTY = "enable_bone_smelting";
        Boolean b = (Boolean)this._cache.get("c Butcherenable_bone_smelting");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "enable_bone_smelting", false, "Set to true to enable smelting of big bones directly to gelatin powder. If disabled you must obtain gelatin using the craft-table recipes. Disabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherenable_bone_smelting", b);
        return b;
    }

    public boolean enableButcherAxeRepairs() {
        String PROPERTY = "enable_butcheraxe_repair";
        Boolean b = (Boolean)this._cache.get("c Butcherenable_butcheraxe_repair");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "enable_butcheraxe_repair", false, "Set to true to enable repair of butchering axes with standard flint. Disabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherenable_butcheraxe_repair", b);
        return b;
    }

    public boolean allowGeneralFlintCutter() {
        String PROPERTY = "flint_cutter_for_food_only";
        Boolean b = (Boolean)this._cache.get("z Miscellaneousflint_cutter_for_food_only");
        if (b != null) {
            return b == false;
        }
        Property p = this.forgeConfig().get(_MISC, "flint_cutter_for_food_only", false, "Set to true to limit the use of the flint-cutter to only food RELATED recipes. Disabled by default (cutter can be used to cut things like wool blocks).");
        b = p.getBoolean();
        this._cache.put("z Miscellaneousflint_cutter_for_food_only", b);
        return b == false;
    }

    public VfpCapacity maxDrinksStackCapacity(VfpCapacity defaultSize) {
        String PROPERTY = "drinks_max_stacksize";
        VfpCapacity n = (VfpCapacity)((Object)this._cache.get("e Upsizerdrinks_max_stacksize"));
        if (n != null) {
            return n;
        }
        Property p = this.forgeConfig().get(_UPSIZER, "drinks_max_stacksize", defaultSize.count(), "Max stack size for all bottled items like fizzy and milk drinks. Default stack size is 24. Allowed sizes are [1,4,8,16,24,32,64].", 1, MinecraftGlue.MAX_STACK_SIZE());
        n = VfpCapacity.fromConfig(p.getInt(), defaultSize);
        this._cache.put("e Upsizerdrinks_max_stacksize", (Object)n);
        return n;
    }

    public VfpCapacity maxSoupsStackCapacity(VfpCapacity defaultSize) {
        String PROPERTY = "soups_max_stacksize";
        VfpCapacity n = (VfpCapacity)((Object)this._cache.get("e Upsizersoups_max_stacksize"));
        if (n != null) {
            return n;
        }
        Property p = this.forgeConfig().get(_UPSIZER, "soups_max_stacksize", defaultSize.count(), "Max stack size for all soupy items like creamy soups and chowders. Default stack size is 24. Allowed sizes are [1,4,8,16,24,32,64].", 1, MinecraftGlue.MAX_STACK_SIZE());
        n = VfpCapacity.fromConfig(p.getInt(), defaultSize);
        this._cache.put("e Upsizersoups_max_stacksize", (Object)n);
        return n;
    }

    public VfpCapacity maxEggsStackCapacity(VfpCapacity defaultSize) {
        String PROPERTY = "eggs_max_stacksize";
        VfpCapacity n = (VfpCapacity)((Object)this._cache.get("e Upsizereggs_max_stacksize"));
        if (n != null) {
            return n;
        }
        Property p = this.forgeConfig().get(_UPSIZER, "eggs_max_stacksize", defaultSize.count(), "Max stack size for all just-an-egg items like fried eggs that we inherit from other mods. Preferred stack size is 64; allowed sizes are [16,32,64]. Does NOT affect raw eggs' stack size.", 1, MinecraftGlue.MAX_STACK_SIZE());
        n = VfpCapacity.fromConfig(p.getInt(), defaultSize);
        this._cache.put("e Upsizereggs_max_stacksize", (Object)n);
        return n;
    }

    public boolean includeBatDrops() {
        String PROPERTY = "include_bat_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_bat_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_bat_drops", true, "Set to false to disable all VFP drops from killing a bat. VFP adds bat meat, bat poop (used to create rotten flesh or as a fertilizer like bone meal), and special drops for potions. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_bat_drops", b);
        return b;
    }

    public boolean includeCalfDrops() {
        String PROPERTY = "include_calf_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_calf_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_calf_drops", true, "Set to false to disable stomach lining drops from killing baby cows. VFP adds calf stomach lining for use in creating curdling agent for cheese. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_calf_drops", b);
        return b;
    }

    public boolean includePigDrops() {
        String PROPERTY = "include_pig_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_pig_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_pig_drops", true, "Set to false to disable all VFP drops from killing pigs. VFP adds drops like raw pork hocks and pig tails. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_pig_drops", b);
        return b;
    }

    public boolean includeHorseDrops() {
        String PROPERTY = "include_horse_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_horse_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_horse_drops", true, "Set to false to disable all VFP drops from killing horses. VFP adds drops like horse tears and raw horse meat. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_horse_drops", b);
        return b;
    }

    public boolean includeWolfDrops() {
        String PROPERTY = "include_wolf_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_wolf_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_wolf_drops", true, "Set to false to disable all VFP drops from killing wolves (tamed and untamed). VFP adds raw wolf meat and special drops for custom potions. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_wolf_drops", b);
        return b;
    }

    public boolean includeSquidDrops() {
        String PROPERTY = "include_squid_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_squid_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_squid_drops", true, "Set to false to disable all VFP drops from killing squid. VFP adds raw squid meat and ink pearl shard drops from squid. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_squid_drops", b);
        return b;
    }

    public boolean includePolarBearDrops() {
        String PROPERTY = "include_bear_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_bear_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_bear_drops", true, "Set to false to disable all VFP drops from killing polar bears. VFP adds raw bear meat and special drops for custom potions. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_bear_drops", b);
        return b;
    }

    public boolean includeLlamaDrops() {
        String PROPERTY = "include_llama_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_llama_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "include_llama_drops", true, "Set to false to disable all VFP drops from killing llamas. VFP adds raw llama meat and fleece (like wool) blocks. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherinclude_llama_drops", b);
        return b;
    }

    public boolean increaseMeatDrops() {
        String PROPERTY = "upsize_meat_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherupsize_meat_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "upsize_meat_drops", true, "Set to true to increase the number of meat dropped from killing cows, pigs, sheep, etc. The increase is from 0 to 3 more pieces with auxilliary items like hides, feathers, and bones always included. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherupsize_meat_drops", b);
        return b;
    }

    public boolean includeBoneDrops() {
        String PROPERTY = "include_bone_drops";
        Boolean b = (Boolean)this._cache.get("c Butcherinclude_bone_drops");
        if (b != null) {
            return b;
        }
        String p = this.forgeConfig().getString("include_bone_drops", _BUTCHER, __DEFAULT_VAL, "Set to true to enable VFP bone drops regardless of the other mods present and super-compatibility mode setting. Requires restart if changed in game.");
        b = true;
        String s = StringUtils.trimToEmpty((String)p);
        if (s.isEmpty() || __DEFAULT_VAL.equals(s)) {
            if (this.isSuperCompatibilityMode()) {
                b = false;
            }
        } else {
            b = BooleanUtils.toBoolean((String)s);
        }
        this._cache.put("c Butcherinclude_bone_drops", b);
        return b;
    }

    public boolean excludeHorseMeatDrops() {
        String PROPERTY = "exclude_horse_meat";
        Boolean b = (Boolean)this._cache.get("c Butcherexclude_horse_meat");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "exclude_horse_meat", false, "Set to true to disable ONLY meat drops from killing horses when 'include_horse_drops' is enabled; ignored otherwise. Use if you have another mod that already drops horse meat. Disabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherexclude_horse_meat", b);
        return b;
    }

    public boolean excludeSquidMeatDrops() {
        String PROPERTY = "exclude_squid_meat";
        Boolean b = (Boolean)this._cache.get("c Butcherexclude_squid_meat");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "exclude_squid_meat", true, "Set to false to enable inclusion of meat drops from killing squid; ignored if 'include_squid_drops' is false. Enable if you do NOT have another mod that already drops squid meat. Note that some VFP recipes require our squid drop and become effectively disabled if this option is off. Enabled by default (no squid meat is dropped).");
        b = p.getBoolean();
        this._cache.put("c Butcherexclude_squid_meat", b);
        return b;
    }

    public boolean excludeWolfMeatDrops() {
        String PROPERTY = "exclude_wolf_meat";
        Boolean b = (Boolean)this._cache.get("c Butcherexclude_wolf_meat");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "exclude_wolf_meat", false, "Set to true to disable ONLY meat drops from killing wolves when 'include_wolf_drops' is enabled; ignored otherwise. Use if you have another mod that already drops wolf meat. Disabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherexclude_wolf_meat", b);
        return b;
    }

    public boolean excludeLlamaMeatDrops() {
        String PROPERTY = "exclude_llama_meat";
        Boolean b = (Boolean)this._cache.get("c Butcherexclude_llama_meat");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "exclude_llama_meat", false, "Set to true to disable ONLY meat drops from killing llamas when 'include_llama_drops' is enabled; ignored otherwise. Use if you have another mod that already drops llama meat. Disabled by default.");
        b = p.getBoolean();
        this._cache.put("c Butcherexclude_llama_meat", b);
        return b;
    }

    public boolean llamasDropRegularWool() {
        String PROPERTY = "llamas_drop_regular_wool";
        Boolean b = (Boolean)this._cache.get("c Butcherllamas_drop_regular_wool");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_BUTCHER, "llamas_drop_regular_wool", false, "Set to true to have llamas drop regular (sheep) wool blocks instead of the custom VFP fleece wool blocks. Disabled by default. Ignored if llama drops in general are disabled.");
        b = p.getBoolean();
        this._cache.put("c Butcherllamas_drop_regular_wool", b);
        return b;
    }

    public boolean useMushroomBlocksForPantry() {
        String PROPERTY = "use_mushroom_blocks_as_storage";
        Boolean b = (Boolean)this._cache.get("d Produceuse_mushroom_blocks_as_storage");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_PRODUCE, "use_mushroom_blocks_as_storage", true, "Set to false to disable (un)crafting of 9 mushrooms from standard mushroom blocks. If enabled you can increase storage size of mushrooms per slot and unlock all the mushroomy goodness of giant mushrooms! Enabled by default.");
        b = p.getBoolean();
        this._cache.put("d Produceuse_mushroom_blocks_as_storage", b);
        return b;
    }

    public boolean increaseShroomDrops() {
        String PROPERTY = "upsize_mushroom_drops";
        Boolean b = (Boolean)this._cache.get("d Produceupsize_mushroom_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_PRODUCE, "upsize_mushroom_drops", true, "Set to true to enable additional mushroom drops from chopping down huge mushrooms with a butchering axe or other tool with fortune enchantment. Also adds red mushrooms to mooshroom drops. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("d Produceupsize_mushroom_drops", b);
        return b;
    }

    public boolean includeAcornDrops() {
        String PROPERTY = "include_acorn_drops";
        Boolean b = (Boolean)this._cache.get("d Produceinclude_acorn_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_PRODUCE, "include_acorn_drops", true, "Set to false to stop acorn drops when you break oak and dark-oak leaves. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("d Produceinclude_acorn_drops", b);
        return b;
    }

    public boolean craftOtherSourcesOfWater() {
        String PROPERTY = "extra_water_items_crafting";
        Boolean b = (Boolean)this._cache.get("z Miscellaneousextra_water_items_crafting");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_MISC, "extra_water_items_crafting", true, "Set to false to disable the extra craft recipes for water buckets and bottles (for instance the recipe to convert ice blocks to buckets of water). Enabled by default.");
        b = p.getBoolean();
        this._cache.put("z Miscellaneousextra_water_items_crafting", b);
        return b;
    }

    public boolean includeCraftableGravel() {
        String PROPERTY = "gravel_crafting";
        Boolean b = (Boolean)this._cache.get("z Miscellaneousgravel_crafting");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_MISC, "gravel_crafting", false, "Set to true to enable the gravel craft recipes (both manual and automated for SmartHoppers). Disabled by default.");
        b = p.getBoolean();
        this._cache.put("z Miscellaneousgravel_crafting", b);
        return b;
    }

    public boolean craftPantryMigrationRecipes() {
        String PROPERTY = "pantry_migration_crafting";
        Boolean b = (Boolean)this._cache.get("z Miscellaneouspantry_migration_crafting");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_MISC, "pantry_migration_crafting", false, "DEVELOPER. Set to true to enable extra craft recipes for migration of other food mod crafted items to their equivalent (or mostly equivalent) VFP items. Disabled by default.");
        b = p.getBoolean();
        this._cache.put("z Miscellaneouspantry_migration_crafting", b);
        return b;
    }

    public boolean fixReWFoodDictionary() {
        String PROPERTY = "fix_food_dictionary";
        String _REW_CATEGORY = "x Integration.REW";
        Boolean b = (Boolean)this._cache.get("x Integration.REWfix_food_dictionary");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get("x Integration.REW", "fix_food_dictionary", true, "ADVANCED. Set to false to disable installing 'food*' dictionary mappings for ReW-based foodstuffs. Only used if RealWorld mod detected and is a version where this tweak is needed (ignored otherwise). Enabled by default.");
        b = p.getBoolean();
        this._cache.put("x Integration.REWfix_food_dictionary", b);
        return b;
    }

    public boolean fixReWTreeDictionary() {
        String PROPERTY = "fix_tree_dictionary";
        String _REW_CATEGORY = "x Integration.REW";
        Boolean b = (Boolean)this._cache.get("x Integration.REWfix_tree_dictionary");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get("x Integration.REW", "fix_tree_dictionary", true, "ADVANCED. Set to false to disable installing 'tree*' dictionary mappings for ReW-based leaves, saplings, logs, etc. Only used if RealWorld mod detected and is a version where this tweak is needed (ignored otherwise). Enabled by default.");
        b = p.getBoolean();
        this._cache.put("x Integration.REWfix_tree_dictionary", b);
        return b;
    }

    public boolean includeReWCropSeedRecipes() {
        String PROPERTY = "include_seed_recipes";
        String _REW_CATEGORY = "x Integration.REW";
        Boolean b = (Boolean)this._cache.get("x Integration.REWinclude_seed_recipes");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get("x Integration.REW", "include_seed_recipes", true, "Set to false to disable crafting recipes for obtaining ReW crops seeds from dropped crops. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("x Integration.REWinclude_seed_recipes", b);
        return b;
    }

    public boolean fixHVCFoodDictionary() {
        String PROPERTY = "fix_food_dictionary";
        String _HVC_CATEGORY = "x Integration.HVC";
        Boolean b = (Boolean)this._cache.get("x Integration.HVCfix_food_dictionary");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get("x Integration.HVC", "fix_food_dictionary", true, "ADVANCED. Set to false to disable installing 'food*' dictionary mappings for Harvestcraft-based foodstuffs. Only used if Harvestcraft mod detected and is a version where this tweak is needed (ignored otherwise). Enabled by default.");
        b = p.getBoolean();
        this._cache.put("x Integration.HVCfix_food_dictionary", b);
        return b;
    }

    public boolean includeModRecipes() {
        String PROPERTY = "recipe_use_enabled";
        Boolean b = (Boolean)this._cache.get("x Integrationrecipe_use_enabled");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_OTHRMOD, "recipe_use_enabled", true, "Set to false to disable recipe-making with non-vanilla foodstuffs (for example Harvestcraft). Note turning this off _after_ you've created mod-dependent items can result in lost items. Enabled by default. Requires game restart.");
        b = p.getBoolean();
        this._cache.put("x Integrationrecipe_use_enabled", b);
        return b;
    }

    public boolean harderFries() {
        String PROPERTY = "use_harder_fries_recipe";
        Boolean b = (Boolean)this._cache.get("z Miscellaneoususe_harder_fries_recipe");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_MISC, "use_harder_fries_recipe", false, "Set to true to enable a more complex raw fries recipe that requires salt and a vinegar bath.  Disabled by default.");
        b = p.getBoolean();
        this._cache.put("z Miscellaneoususe_harder_fries_recipe", b);
        return b;
    }

    public boolean alwaysIncludeRedFlintDrops() {
        String PROPERTY = "always_include_red_flint_drops";
        Boolean b = (Boolean)this._cache.get("z Miscellaneousalways_include_red_flint_drops");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_MISC, "always_include_red_flint_drops", true, "Set to false to disable red flint drops when not in super-compatibility mode. Some recipes require red flint. If you want these recipes always, leave this option on. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("z Miscellaneousalways_include_red_flint_drops", b);
        return b;
    }

    public boolean isAutocraftingEnabled() {
        String PROPERTY = "automation_enabled";
        Boolean b = (Boolean)this._cache.get("x Integrationautomation_enabled");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_OTHRMOD, "automation_enabled", true, "Set to false to disable integration with automation mods like SmartHoppers that support auto-crafting mechanics. Enabled by default.");
        b = p.getBoolean();
        this._cache.put("x Integrationautomation_enabled", b);
        return b;
    }

    public boolean showDeckerIngredients() {
        String PROPERTY = "decker_ingredients_tooltip";
        Boolean b = (Boolean)this._cache.get("a Optionsdecker_ingredients_tooltip");
        if (b != null) {
            return b;
        }
        Property p = this.forgeConfig().get(_GENERAL, "decker_ingredients_tooltip", true, "Set to false to disable decker sandwich ingredient (name) tooltips. If enabled you will see the name of each food item that went into your decker sandwich. Enabled by default.");
        b = p.getBoolean() || this.isDebugMode();
        this._cache.put("a Optionsdecker_ingredients_tooltip", b);
        return b;
    }

    public final void persist() {
        this.fullyDefine();
        if (!this._dontSave) {
            this.forgeConfig().save();
        }
    }

    final Configuration forgeConfig() {
        return this._forgeConfig;
    }

    public Map<String, Object> builderContext() {
        return this._builderContext;
    }

    public boolean isPresent(@Nonnull String feature) {
        return Boolean.valueOf(true).equals(this._builderContext.get(feature + ".present"));
    }

    public void setPresent(@Nonnull String feature) {
        this._builderContext.put(feature + ".present", true);
    }

    @Nullable
    public String getPresentAs(@Nonnull String feature) {
        Object value = this._builderContext.get(feature + ".forgeid");
        return value == null ? null : String.valueOf(value);
    }

    public void setPresentAs(String feature, String as) {
        this._builderContext.put(feature + ".present", true);
        this._builderContext.put(feature + ".forgeid", as);
    }

    public void captureContextOres() {
        List<String> ores = Arrays.asList(OreDictionary.getOreNames());
        this._builderContext.put("__ores", ores);
    }

    public List<String> capturedContextOres() {
        List ores = (List)List.class.cast(this._builderContext.get("__ores"));
        return ores != null ? ores : Collections.EMPTY_LIST;
    }

    public final void changed() {
        if (this.forgeConfig().hasChanged() && !this._dontSave) {
            this.forgeConfig().save();
        }
    }

    private void fullyDefine() {
        this.useOwnTab();
        this.isSuperCompatibilityMode();
        this.includeCraftXpAndAchievements();
        this.includePotionBrewing();
        this.generousCraftingXp();
        this.isOreGenerationEnabled();
        this.allowLootTableEnrichment();
        this.includeBoneDrops();
        this.increaseMeatDrops();
        this.includeBatDrops();
        this.includeCalfDrops();
        this.includePigDrops();
        this.includeHorseDrops();
        this.includeWolfDrops();
        this.includeSquidDrops();
        this.includePolarBearDrops();
        this.includeLlamaDrops();
        this.alwaysIncludeSimpleFlourRecipe();
        this.alwaysIncludeSimpleFriedEggRecipe();
        this.enableBoneSmelting();
        this.enablePotionWaterAsPlainWater();
        this.enableButcherAxeRepairs();
        this.allowGeneralFlintCutter();
        this.excludeHorseMeatDrops();
        this.excludeSquidMeatDrops();
        this.excludeWolfMeatDrops();
        this.excludeLlamaMeatDrops();
        this.llamasDropRegularWool();
        this.maxDrinksStackCapacity(VfpLiquidFood.DEFAULT_STACK_SIZE);
        this.maxSoupsStackCapacity(VfpLiquidFood.DEFAULT_STACK_SIZE);
        this.maxEggsStackCapacity(VfpCapacity.BULK_STACK);
        this.craftOtherSourcesOfWater();
        this.useMushroomBlocksForPantry();
        this.increaseShroomDrops();
        this.includeAcornDrops();
        this.includeModRecipes();
        this.fixReWFoodDictionary();
        this.fixReWTreeDictionary();
        this.includeReWCropSeedRecipes();
        this.fixHVCFoodDictionary();
        this.harderFries();
        this.alwaysIncludeRedFlintDrops();
        this.includeCraftableGravel();
        this.craftPantryMigrationRecipes();
        this.isAutocraftingEnabled();
        this.showDeckerIngredients();
        if (!this._mcToldRestartIfChanged) {
            this._mcToldRestartIfChanged = true;
            for (String category : UI_CATEGORIES) {
                this._forgeConfig.setCategoryRequiresMcRestart(category, true);
            }
        }
    }

    private void validateVersion() {
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)this._forgeConfig.getLoadedConfigVersion())) {
            int v_load = NumberUtils.toInt((String)this._forgeConfig.getLoadedConfigVersion(), (int)-1);
            int v_curr = NumberUtils.toInt((String)"1");
            if (v_load < 0 || v_load > v_curr) {
                this._dontSave = true;
                FMLLog.warning((String)"Unrecognized configuration version detected; config changes will NOT be saved this session", (Object[])new Object[0]);
            }
        }
    }
}

