/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class VfpExtendedPantryItem
extends VfpPantryItem {
    protected Predicate<Item> _have_ingredients = Predicates.alwaysTrue();

    public VfpExtendedPantryItem(VfpProfile oid, LikeFood like, Predicate<Item> test, CreativeTabs tab) {
        super(oid, like, tab);
        Validate.notNull(test, (String)"A non-null test is required", (Object[])new Object[0]);
        this._have_ingredients = test;
    }

    protected VfpExtendedPantryItem(VfpProfile oid, LikeFood like, CreativeTabs tab) {
        super(oid, like, tab);
    }

    protected boolean showSubItem(Item item, CreativeTabs forTab) {
        return this._have_ingredients.apply((Object)item);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.showSubItem(item, tab)) {
            super.func_150895_a(item, tab, subItems);
        }
    }

    public static final class IsIngredientPresent
    implements Predicate<Item> {
        private final String _id;
        private final VfpAware.IdDomain _selector;

        public IsIngredientPresent(VfpAware.IdDomain selector, String ingredient) {
            Validate.isTrue((selector != null && ingredient != null ? 1 : 0) != 0);
            this._selector = selector;
            this._id = ingredient;
        }

        public boolean apply(Item item) {
            boolean yes = false;
            switch (this._selector) {
                case MODID: {
                    VfpConfig config = VfpConfig.getInstance();
                    yes = config.includeModRecipes() && config.isModLoaded(this._id);
                    break;
                }
                case CONFIG: {
                    yes = VfpConfig.getInstance().isPresent(this._id);
                    break;
                }
                default: {
                    yes = VfpUtils.ingredientDefined(this._id);
                }
            }
            return yes;
        }
    }
}

