/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class VfpFertilizerItem
extends VfpPlainItem {
    private static final int _BONEMEAL_DONE_SFX = 2005;
    private static final int _DISPENSE_DONE_SFX = 1000;
    private static final int _DISPENSE_FAIL_SFX = 1001;

    public VfpFertilizerItem(VfpProfile oid, CreativeTabs tab) {
        super(oid, tab);
    }

    public VfpFertilizerItem(VfpProfile oid) {
        this(oid, null);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_175151_a(pos.func_177972_a(side), side, stack) && VfpFertilizerItem.applyBonemeal(stack, world, pos, player)) {
            if (!world.field_72995_K) {
                MinecraftGlue.Effects.playFertilizedSuccessfully(world, pos);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    private static final boolean bonemealAlwaysEffective(World world, IBlockState state, IGrowable growable) {
        return growable instanceof BlockMushroom || growable instanceof BlockSapling || MinecraftGlue.isLikelySapling(world, state);
    }

    public static boolean applyBonemeal(ItemStack stack, World world, BlockPos to, EntityPlayer player) {
        IGrowable growable;
        IBlockState blockstate = world.func_180495_p(to);
        int hook = ForgeEventFactory.onApplyBonemeal((EntityPlayer)player, (World)world, (BlockPos)to, (IBlockState)blockstate, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        if (blockstate.func_177230_c() instanceof IGrowable && (growable = (IGrowable)blockstate.func_177230_c()).func_176473_a(world, to, blockstate, world.field_72995_K)) {
            boolean used = true;
            if (!world.field_72995_K) {
                boolean always = stack.func_77973_b() instanceof VfpFertilizerItem && VfpFertilizerItem.bonemealAlwaysEffective(world, blockstate, growable);
                used = false;
                if (always || growable.func_180670_a(world, world.field_73012_v, to, blockstate)) {
                    growable.func_176474_b(world, world.field_73012_v, to, blockstate);
                    used = true;
                }
                if (MinecraftGlue.getPlayerInSurvival(player) && used) {
                    MinecraftGlue.ItemStacks_decrBy(stack, 1);
                }
            }
            return used;
        }
        return false;
    }

    public static boolean applyBonemeal(ItemStack stack, World world, BlockPos to) {
        if (world instanceof WorldServer) {
            return VfpFertilizerItem.applyBonemeal(stack, world, to, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)));
        }
        return false;
    }

    public static final void initDispenseBehavior(Item instance) {
        Validate.notNull((Object)instance, (String)"A non-null fertilizer item is required", (Object[])new Object[0]);
        BlockDispenser.field_149943_a.func_82595_a((Object)instance, (Object)new BehaviorDefaultDispenseItem(){
            private boolean _dispensed = true;

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                World world = source.func_82618_k();
                if (VfpFertilizerItem.applyBonemeal(stack, world, blockpos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)))) {
                    if (!world.field_72995_K) {
                        world.func_175718_b(2005, blockpos, 0);
                    }
                } else {
                    this._dispensed = false;
                }
                return stack;
            }

            protected void func_82485_a(IBlockSource source) {
                if (this._dispensed) {
                    source.func_82618_k().func_175718_b(1000, source.func_180699_d(), 0);
                } else {
                    source.func_82618_k().func_175718_b(1001, source.func_180699_d(), 0);
                }
            }
        });
    }
}

