/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.IMultiColored;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.Named;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;

public abstract class VfpLiquidMultiItem
extends VfpPantryMultiItem
implements IMultiColored {
    protected final VfpVariantSet _variantset;

    protected static final synchronized boolean register(Ingredient flavor, List<Ingredient> variant_flavors, String typename) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for %s", (Object[])new Object[]{typename});
        boolean added = false;
        if (!variant_flavors.contains(flavor)) {
            added = variant_flavors.add(flavor);
        }
        return added;
    }

    protected VfpLiquidMultiItem(VfpProfile oid, VfpVariantSet set, CreativeTabs tab) {
        super(oid, false, set.variants(), tab, true);
        this._variantset = set;
        this.func_77625_d(this.getItemMaxStackSize().count());
        this.completeInit(oid);
    }

    protected abstract ItemStack getNewEmptyContainer();

    protected VfpCapacity getItemMaxStackSize() {
        return VfpLiquidFood.DEFAULT_STACK_SIZE;
    }

    protected Integer getVariantColorFromMeta(VfpVariant type, Ingredient ingredient, int tintIndex) {
        Integer colorValue = null;
        if (type != null) {
            int num;
            if (ingredient instanceof FoodColor) {
                int num2 = ((FoodColor)((Object)ingredient)).color(ingredient.recipeitem());
                if (num2 != 0xF1F1F1) {
                    colorValue = num2;
                }
            } else if (ingredient.recipeitem().func_77973_b() instanceof FoodColor) {
                int num3 = ((FoodColor)ingredient.recipeitem().func_77973_b()).color(ingredient.recipeitem());
                if (num3 != 0xF1F1F1) {
                    colorValue = num3;
                }
            } else if (ingredient.recipeitem().func_77973_b() instanceof IMultiColored && (num = ((IMultiColored)ingredient.recipeitem().func_77973_b()).getColorFrom(ingredient.recipeitem(), tintIndex)) != 0xFFFFFF) {
                colorValue = num;
            }
        }
        return colorValue;
    }

    protected int getColorFromMeta(int meta, int tintIndex) {
        Integer colorValue;
        Ingredient ingredient;
        int color_num = 0;
        VfpVariant type = this._variantset.lookup(meta);
        if (type != null && (ingredient = type.datadata(Ingredient.class)) != null && (colorValue = this.getVariantColorFromMeta(type, ingredient, tintIndex)) != null) {
            color_num = colorValue;
        }
        return color_num;
    }

    @Override
    public int getColorFrom(ItemStack stack, int tintIndex) {
        int default_color_num;
        int color_num = default_color_num = 0xFFFFFF;
        if (tintIndex <= 0 && (color_num = this.getColorFromMeta(stack.func_77960_j(), tintIndex)) == 0) {
            color_num = default_color_num;
        }
        return color_num;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        String name = MinecraftGlue.I18N_ITEM_KEY_PREFIX() + this._variantset.typeName();
        if (variant != null) {
            name = name + "_" + variant.datadata(Named.class).name();
        }
        return name;
    }

    @Override
    protected ItemStack onItemConsumedFully(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        if (MinecraftGlue.getPlayerInSurvival(player)) {
            ItemStack empty = this.getNewEmptyContainer();
            if (MinecraftGlue.ItemStacks_isEmpty(remaining)) {
                return empty;
            }
            if (!player.field_71071_by.func_70441_a(empty)) {
                player.func_71019_a(empty, false);
            }
        }
        return remaining;
    }

    protected static abstract class VariantSet
    extends VfpVariantSet.ByMapInstance {
        protected VariantSet(VfpProfile typedef, Class<?> marker) {
            super(typedef, marker, "flavor");
        }

        @Override
        public String[] renderNames() {
            return new String[]{"vanillafoodpantry:" + this.typeName()};
        }
    }
}

