/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpCraftedStorage;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class VfpPantryBlock
extends VfpPlainBlock
implements VfpAware,
VfpCraftedStorage {
    protected final ItemStack _constituent;
    protected final int _multiplier;

    public VfpPantryBlock(VfpProfile oid, Material likeMaterial, Block likeBlock, ItemStack constituent, CreativeTabs tab) {
        super(oid, likeMaterial, likeBlock);
        Validate.notNull((Object)constituent, (String)"A non-null constituent item is required for a pantry block", (Object[])new Object[0]);
        Validate.isTrue((boolean)MinecraftGlue.ItemStacks_isSingle(constituent), (String)"A pantry block's constituent must be of stacksize ONE", (Object[])new Object[0]);
        this._constituent = constituent.func_77946_l();
        this._multiplier = 1;
        VfpUtils.copy(likeBlock, this, 1.0f);
        this.func_149672_a(MinecraftGlue.Block_soundType_Gravel);
        this.func_149647_a(VfpUtils.bestTab(oid, tab));
    }

    public VfpPantryBlock(VfpProfile oid, Block likeBlock, ItemStack constituent) {
        this(oid, null, likeBlock, constituent, null);
    }

    public VfpPantryBlock(VfpProfile oid, Block likeBlock, Item constituent) {
        this(oid, null, likeBlock, new ItemStack(constituent), null);
    }

    public VfpPantryBlock(VfpProfile oid, LikeFood constituent) {
        this(oid, MinecraftGlue.Material_sponge, MinecraftGlue.Blocks_slime_block, constituent.sample(), null);
        this.func_149672_a(MinecraftGlue.Block_soundType_Slime);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return this.isEffectivelyDense(state) ? EnumPushReaction.NORMAL : EnumPushReaction.DESTROY;
    }

    public int func_149745_a(Random random) {
        return this._oid.capacity().count() * this._multiplier;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this._constituent.func_77973_b();
    }

    public int func_180651_a(IBlockState state) {
        return this._constituent.func_77960_j();
    }

    protected boolean isEffectivelyDense(@Nullable IBlockState state) {
        if (this._oid.isLiquid()) {
            return false;
        }
        return this._oid.isDense() || this._multiplier > 1 && this._oid.capacity().count() * this._multiplier >= VfpCapacity.DENSE_BLOCK.count();
    }

    @Override
    public String storedTypeName() {
        return "ITEM";
    }

    @Override
    public int quantityStored(ItemStack stack, EntityPlayer player) {
        int m;
        int n = 1;
        if (this._constituent.func_77973_b() instanceof VfpCraftedStorage && (m = ((VfpCraftedStorage)this._constituent.func_77973_b()).quantityStored(this._constituent, player)) > 0) {
            n = m;
        }
        m = VfpCapacity.STANDARD_BLOCK.count();
        if (this._oid.capacity() != null) {
            m = this._oid.capacity().count();
        }
        return n * m * (stack == null ? 1 : MinecraftGlue.ItemStacks_getSize(stack));
    }

    @Override
    public int quantityStored(IBlockState block, EntityPlayer player) {
        return -1;
    }
}

