/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpCraftedStorage;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;

public class VfpPantryCarton
extends VfpPantryMultiBlock
implements VfpCraftedStorage {
    private static final void validateCartonDefinition(VfpProfile oid, VfpVariantSet set) {
        Validate.isTrue((boolean)oid.isPackaged(), (String)"Carton's VFP profile must be marked as packaged", (Object[])new Object[0]);
        Validate.isTrue((oid.capacity().count() <= VfpCapacity.TRAY.count() ? 1 : 0) != 0, (String)"Carton's VFP capacity must be at MOST %d (TRAY sized)", (long)VfpCapacity.TRAY.count());
        VfpVariant[] v = set.variants();
        VfpUtils.validIndexAsMeta(oid, v);
        for (int i = 0; i < v.length; ++i) {
            Integer count = null;
            VfpCapacity capacity = v[i].capacity();
            if (capacity != null) {
                count = capacity.count();
            } else {
                ItemStack other = v[i].datadata(ItemStack.class);
                if (other != null) {
                    count = MinecraftGlue.ItemStacks_getSize(other);
                }
            }
            if (count == null) continue;
            Validate.isTrue((count <= VfpCapacity.TRAY.count() ? 1 : 0) != 0, (String)"Carton's VFP capacity for variant '%s' must be at MOST %d (TRAY sized); it is %d", (Object[])new Object[]{v[i].fmlid(), VfpCapacity.TRAY.count(), count});
        }
    }

    protected VfpPantryCarton(VfpProfile oid, Block likeBlock, ItemStack constituent, VfpVariantSet variants, CreativeTabs tab) {
        super(oid, likeBlock, constituent, variants, tab);
        VfpPantryCarton.validateCartonDefinition(oid, variants);
    }

    protected VfpPantryCarton(VfpProfile oid, Block likeBlock, Item constituent, VfpVariantSet variants, CreativeTabs tab) {
        super(oid, likeBlock, constituent, variants, tab);
        VfpPantryCarton.validateCartonDefinition(oid, variants);
    }

    final int quantityDropped(int meta) {
        int count = this._oid.capacity().count() * this._multiplier;
        VfpVariant variant = this._variantsJA[meta];
        if (variant.capacity() != null) {
            count = variant.capacity().count();
        } else {
            ItemStack other = variant.datadata(ItemStack.class);
            if (other != null) {
                count = MinecraftGlue.ItemStacks_getSize(other);
            }
        }
        return count;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int count = this.quantityDropped(this.func_176201_c(state));
        return count;
    }

    @Override
    protected ItemStack getVariantItemDropped(IBlockState state) {
        ItemStack drop = this._constituent;
        VfpVariant variant = this._variantsJA[this.func_176201_c(state)];
        if (LikeFood.really(variant.food())) {
            drop = variant.food().sample();
            assert (drop != null) : "Non-null food drop for packaged carton defined";
        } else {
            ItemStack other = variant.datadata(ItemStack.class);
            if (other != null && MinecraftGlue.ItemStacks_getSize(drop = other) > 1) {
                drop = new ItemStack(other.func_77973_b(), 1, other.func_77960_j());
            }
        }
        return drop;
    }

    @Override
    public String storedTypeName() {
        return "ITEM";
    }

    protected int quantityStoredPerInnerContainer(ItemStack stack) {
        return VfpCapacity.TRAY.count();
    }

    @Override
    public int quantityStored(ItemStack stack, EntityPlayer player) {
        int qty = 0;
        if (!MinecraftGlue.ItemStacks_isEmpty(stack)) {
            int per = this.quantityStoredPerInnerContainer(stack);
            qty = this.quantityDropped(stack.func_77960_j()) * per;
            qty *= MinecraftGlue.ItemStacks_getSize(stack);
        }
        return qty;
    }

    @Override
    public int quantityStored(IBlockState state, EntityPlayer player) {
        int per_bag = VfpCapacity.TRAY.count();
        return this.quantityDropped(this.func_176201_c(state)) * per_bag;
    }

    @Override
    protected boolean isEffectivelyDense(IBlockState state) {
        return false;
    }

    @Override
    protected int getMaxStackFromMeta(int meta) {
        VfpVariant variant = this._variantsJA[meta];
        Integer override = variant.maxstack();
        if (override != null) {
            return override;
        }
        return -1;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 45;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 15;
    }

    protected final VfpVariant findVariant(PackagedFood packaged) {
        LikeFood target = packaged.food();
        for (VfpVariant variant : this._variantsJA) {
            if (LikeFood.really(variant.food())) {
                if (!variant.food().equals(target)) continue;
                return variant;
            }
            ItemStack variant_otherfood = variant.datadata(ItemStack.class);
            ItemStack target_sample = target.sample();
            if (MinecraftGlue.ItemStacks_isEmpty(variant_otherfood) || variant_otherfood.func_77973_b() != target_sample.func_77973_b() || variant_otherfood.func_77960_j() != target_sample.func_77960_j()) continue;
            return variant;
        }
        return null;
    }

    private static boolean isTray(int count) {
        return count == VfpCapacity.TRAY.count() || count == VfpCapacity.HALF_TRAY.count() || count == VfpCapacity.BAKERS_TRAY.count();
    }

    public static ItemStack[] autorecipe(VfpPantryCarton carton) {
        return VfpPantryCarton.autorecipe(carton, null);
    }

    public static ItemStack[] autorecipe(VfpPantryCarton carton, Item empty_carton) {
        Validate.notNull((Object)carton, (String)"A non-null carton instance is required", (Object[])new Object[0]);
        if (empty_carton == null) {
            empty_carton = VfpObj.Empty_Carton_obj;
        }
        Validate.notNull((Object)carton, (String)"A non-null empty_carton item is required", (Object[])new Object[0]);
        boolean plain = empty_carton == VfpObj.Empty_Carton_obj;
        Item itemblock = Item.func_150898_a((Block)carton);
        if (itemblock != null && itemblock.func_77668_q() == null) {
            itemblock.func_77642_a(VfpObj.Empty_Carton_obj);
        }
        ItemStack[] instances = new ItemStack[carton._variantsJA.length];
        Object empty_carton_item = empty_carton;
        if (plain && VfpUtils.ingredientDefined("itemPackagingBox")) {
            empty_carton_item = "itemPackagingBox";
        }
        for (int i = 0; i < carton._variantsJA.length; ++i) {
            ItemStack typed_carton = new ItemStack((Block)carton, 1, i);
            instances[i] = typed_carton.func_77946_l();
            int count = carton.quantityDropped(i);
            Validate.validState((boolean)VfpPantryCarton.isTray(count), (String)"Auto-recipe only works for full, baker's, or half tray cartons (%s carton drops %d)", (Object[])new Object[]{carton._oid, count});
            ItemStack constituent = carton.getVariantItemDropped(carton.func_176203_a(i));
            if (MinecraftGlue.ItemStacks_getSize(constituent) > 1) {
                constituent = constituent.func_77946_l();
                MinecraftGlue.ItemStacks_setSize(constituent, 1);
            }
            if (count == VfpCapacity.HALF_TRAY.count()) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(typed_carton, new Object[]{"XX ", "XX ", "c  ", Character.valueOf('X'), constituent, Character.valueOf('c'), empty_carton_item}));
            } else if (count == VfpCapacity.BAKERS_TRAY.count()) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(typed_carton, new Object[]{"XXX", "XXX", "c  ", Character.valueOf('X'), constituent, Character.valueOf('c'), empty_carton_item}));
            } else {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(typed_carton, new Object[]{"XXX", "XcX", "XXX", Character.valueOf('X'), constituent, Character.valueOf('c'), empty_carton_item}));
            }
            if (constituent.func_77976_d() < count) continue;
            ItemStack result = constituent.func_77946_l();
            MinecraftGlue.ItemStacks_setSize(result, count);
            GameRegistry.addShapelessRecipe((ItemStack)result, (Object[])new Object[]{typed_carton.func_77946_l()});
        }
        return instances;
    }

    protected static class VariantSet
    extends VfpVariantSet.ByMapInstanceVType {
        public VariantSet(VfpProfile typedef, Class<?> marker) {
            super(typedef, marker, "contents");
        }

        @Override
        protected VfpVariant[] declaredVariants() {
            return this.values().toArray(VfpVariant.EMPTY_ARRAY);
        }
    }
}

