/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.AchievementPage;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.JuJuExtensions;
import org.jwaresoftware.mcmods.vfp.agents.Water;
import org.jwaresoftware.mcmods.vfp.carton.BakeryCarton;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.eggs.EggPies;
import org.jwaresoftware.mcmods.vfp.meats.Kebabs;
import org.jwaresoftware.mcmods.vfp.meats.Nuggets;
import org.jwaresoftware.mcmods.vfp.meats.Spam;
import org.jwaresoftware.mcmods.vfp.milk.MilkDrinks;
import org.jwaresoftware.mcmods.vfp.milk.TeaDrinks;
import org.jwaresoftware.mcmods.vfp.misc.DeckerSandwiches;
import org.jwaresoftware.mcmods.vfp.misc.Tatoes;
import org.jwaresoftware.mcmods.vfp.wheat.Breads;
import org.jwaresoftware.mcmods.vfp.wheat.DoughBallType;
import org.jwaresoftware.mcmods.vfp.wheat.Muffins;

public final class VfpAchievements {
    private static final Map<String, Achievement> _registryInstance = new Hashtable<String, Achievement>();

    static final void define(VfpConfig config) {
        Item TBD = VfpObj.Eek_obj;
        int W = 2;
        boolean H = true;
        Achievement pantryBegun = new Achievement(Id.PantryBegun.statid(), Id.PantryBegun.id(), 10, 9, VfpObj.Drying_Agent_Unprocessed_obj, (Achievement)null);
        VfpAchievements.addAchievement(Id.PantryBegun, pantryBegun);
        Achievement makingDough = new Achievement(Id.MakingDough.statid(), Id.MakingDough.id(), 10, 11, DoughBallType.plain(1), pantryBegun);
        VfpAchievements.addAchievement(Id.MakingDough, makingDough);
        Achievement mooRiches = new Achievement(Id.MooRiches.statid(), Id.MooRiches.id(), 10, 6, MilkDrinks.heavy(1), pantryBegun);
        VfpAchievements.addAchievement(Id.MooRiches, mooRiches);
        Achievement portionInTime = new Achievement(Id.PortionInTime.statid(), Id.PortionInTime.id(), 14, 9, VfpObj.Pumpkin_Portion_obj, pantryBegun);
        VfpAchievements.addAchievement(Id.PortionInTime, portionInTime);
        VfpAchievements.addAchievement(Id.ThatFizzyFeeling, new Achievement(Id.ThatFizzyFeeling.statid(), Id.ThatFizzyFeeling.id(), 2, 9, Water.fizzy(1), pantryBegun));
        VfpAchievements.addAchievement(Id.AhHoardingWeShallGo, new Achievement(Id.AhHoardingWeShallGo.statid(), Id.AhHoardingWeShallGo.id(), 6, 10, VfpObj.Empty_Carton_obj, pantryBegun));
        VfpAchievements.addAchievement(Id.PowahFirstAid, new Achievement(Id.PowahFirstAid.statid(), Id.PowahFirstAid.id(), 4, 8, FoodPowders.get(FoodPowders.Type.MUSCLE, 1), pantryBegun));
        VfpAchievements.addAchievement(Id.TeaTime, new Achievement(Id.TeaTime.statid(), Id.TeaTime.id(), 8, 7, TeaDrinks.bush(1), pantryBegun));
        VfpAchievements.addAchievement(Id.BakerPrime, new Achievement(Id.BakerPrime.statid(), Id.BakerPrime.id(), 10, 13, Breads.pumpkin(1), makingDough));
        VfpAchievements.addAchievement(Id.GetTheMeats, new Achievement(Id.GetTheMeats.statid(), Id.GetTheMeats.id(), 14, 11, VfpObj.Flint_Butcher_Axe_obj, portionInTime));
        VfpAchievements.addAchievement(Id.FingerFoodie, new Achievement(Id.FingerFoodie.statid(), Id.FingerFoodie.id(), 18, 9, Nuggets.combo(Nuggets.NuggetDef.Chicken), portionInTime));
        VfpAchievements.addAchievement(Id.NowYoureCooking, new Achievement(Id.NowYoureCooking.statid(), Id.NowYoureCooking.id(), 16, 13, VfpObj.Ham_Hocks_Stew_obj, VfpAchievements.getAchievement(Id.GetTheMeats)));
        VfpAchievements.addAchievement(Id.BatSplat, new Achievement(Id.BatSplat.statid(), Id.BatSplat.id(), 18, 11, VfpObj.Small_Bone_obj, VfpAchievements.getAchievement(Id.GetTheMeats)));
        VfpAchievements.addAchievement(Id.ChowderHound, new Achievement(Id.ChowderHound.statid(), Id.ChowderHound.id(), 10, 1, VfpObj.Fish_Chowder_obj, mooRiches));
        VfpAchievements.addAchievement(Id.NewWorldsOfTaste, new Achievement(Id.NewWorldsOfTaste.statid(), Id.NewWorldsOfTaste.id(), 12, 5, VfpObj.CheeseBall_obj, mooRiches));
        VfpAchievements.addAchievement(Id.SweetyTooth, new Achievement(Id.SweetyTooth.statid(), Id.SweetyTooth.id(), 2, 11, VfpObj.Taffy_Blob_obj, VfpAchievements.getAchievement(Id.ThatFizzyFeeling)));
        VfpAchievements.addAchievement(Id.GrandmasFavorite, new Achievement(Id.GrandmasFavorite.statid(), Id.GrandmasFavorite.id(), 20, 14, EggPies.grandmas(), VfpAchievements.getAchievement(Id.NowYoureCooking)));
        VfpAchievements.addAchievement(Id.GrillMeister, new Achievement(Id.GrillMeister.statid(), Id.GrillMeister.id(), 16, 7, Kebabs.meat(), portionInTime));
        VfpAchievements.addAchievement(Id.WellStuffed, new Achievement(Id.WellStuffed.statid(), Id.WellStuffed.id(), 10, 15, Tatoes.wellstuffed(), VfpAchievements.getAchievement(Id.BakerPrime)));
        VfpAchievements.addAchievement(Id.ZombieCuisineOnDemand, new Achievement(Id.ZombieCuisineOnDemand.statid(), Id.ZombieCuisineOnDemand.id(), 4, 2, JuJuExtensions.jujujuice(), VfpAchievements.getAchievement(Id.PowahFirstAid)));
        VfpAchievements.addAchievement(Id.BraveStomach, new Achievement(Id.BraveStomach.statid(), Id.BraveStomach.id(), 20, 7, Kebabs.polarbear(), VfpAchievements.getAchievement(Id.GrillMeister)));
        VfpAchievements.addAchievement(Id.WellBalanced, new Achievement(Id.WellBalanced.statid(), Id.WellBalanced.id(), 6, 5, TBD, VfpAchievements.getAchievement(Id.TeaTime)));
        VfpAchievements.addAchievement(Id.PickledPink, new Achievement(Id.PickledPink.statid(), Id.PickledPink.id(), 8, 3, VfpObj.Pickled_Egg_obj, VfpAchievements.getAchievement(Id.TeaTime)));
        VfpAchievements.addAchievement(Id.TroubleBrewing, new Achievement(Id.TroubleBrewing.statid(), Id.TroubleBrewing.id(), 2, 4, TBD, VfpAchievements.getAchievement(Id.PowahFirstAid)));
        VfpAchievements.addAchievement(Id.NeverMuffed, new Achievement(Id.NeverMuffed.statid(), Id.NeverMuffed.id(), 8, 12, Muffins.pumpkin(1), makingDough));
        VfpAchievements.addAchievement(Id.LiesLiesLies, new Achievement(Id.LiesLiesLies.statid(), Id.LiesLiesLies.id(), 4, 13, BakeryCarton.get(PackagedFood.CAKE), VfpAchievements.getAchievement(Id.AhHoardingWeShallGo)));
        VfpAchievements.addAchievement(Id.SpiceOfLife, new Achievement(Id.SpiceOfLife.statid(), Id.SpiceOfLife.id(), 22, 13, FoodPowders.get(FoodPowders.Type.PICKLING, 1), VfpAchievements.getAchievement(Id.NowYoureCooking)));
        VfpAchievements.addAchievement(Id.SpiritsFlown, new Achievement(Id.SpiritsFlown.statid(), Id.SpiritsFlown.id(), 24, 5, VfpObj.Wolf_Spirit_obj, VfpAchievements.getAchievement(Id.BraveStomach)));
        VfpAchievements.addAchievement(Id.FriendOfTheWolf, new Achievement(Id.FriendOfTheWolf.statid(), Id.FriendOfTheWolf.id(), 16, 4, TBD, VfpAchievements.getAchievement(Id.GrillMeister)));
        VfpAchievements.addAchievement(Id.PearlJammin, new Achievement(Id.PearlJammin.statid(), Id.PearlJammin.id(), 20, 13, VfpObj.Ink_Pearl_obj, VfpAchievements.getAchievement(Id.PearlJammin)));
        VfpAchievements.addAchievement(Id.TheWalkingSpam, new Achievement(Id.TheWalkingSpam.statid(), Id.TheWalkingSpam.id(), 4, 15, Spam.steamed(1), pantryBegun));
        VfpAchievements.addAchievement(Id.AllHandsOnDeck, new Achievement(Id.AllHandsOnDeck.statid(), Id.AllHandsOnDeck.id(), 4, 17, DeckerSandwiches.empty(), pantryBegun));
    }

    static final void autoregister() {
        if (!_registryInstance.isEmpty()) {
            ArrayList<Achievement> achievements = new ArrayList<Achievement>(_registryInstance.size() * 2);
            for (Achievement achievement : _registryInstance.values()) {
                achievement.func_75971_g();
                achievements.add(achievement);
            }
            String pageName = MinecraftGlue.Strings.translate("achievement.vfp_page.name");
            AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage(pageName, achievements.toArray(new Achievement[0])));
        }
    }

    public static void addAchievement(String id, Achievement achievement) {
        Achievement old = _registryInstance.put(id, achievement);
        Validate.isTrue((old == null ? 1 : 0) != 0, (String)"Only one achievement for '%s' allowed; already registered %s", (Object[])new Object[]{id, old});
    }

    public static void addAchievement(Id id, Achievement achievement) {
        VfpAchievements.addAchievement(id.id(), achievement);
    }

    public static Achievement getAchievement(String id) {
        return _registryInstance.get(id);
    }

    public static Achievement getAchievement(Id achievement) {
        return VfpAchievements.getAchievement(achievement.id());
    }

    public static void triggerAchievement(EntityPlayer player, String id) {
        Achievement achievement = _registryInstance.get(id);
        if (achievement != null) {
            player.func_71029_a((StatBase)achievement);
        }
    }

    public static void triggerAchievement(EntityPlayer player, Id achievement) {
        if (achievement != null) {
            VfpAchievements.triggerAchievement(player, achievement.id());
        }
    }

    public static enum Id {
        PantryBegun("pantrybegun"),
        MakingDough("makingdough"),
        MooRiches("mooriches"),
        PortionInTime("portionintime"),
        ThatFizzyFeeling("fizzyfeeling"),
        AhHoardingWeShallGo("hoardingwego"),
        PowahFirstAid("powahaid"),
        TeaTime("teatime"),
        BakerPrime("bakerprime"),
        GetTheMeats("getmeats"),
        FingerFoodie("fingerfoodie"),
        NowYoureCooking("nowcooking"),
        ChowderHound("chowderhound"),
        NewWorldsOfTaste("newtastes"),
        SweetyTooth("sweetytooth"),
        GrandmasFavorite("grandmafav"),
        GrillMeister("grillmeister"),
        WellStuffed("wellstuffed"),
        ZombieCuisineOnDemand("zombiecuisine"),
        BraveStomach("bravestomach"),
        WellBalanced("wellbalanced"),
        PickledPink("pickledpink"),
        TroubleBrewing("troublebrewing"),
        NeverMuffed("notmuffed"),
        LiesLiesLies("lieslieslies"),
        SpiceOfLife("spiceoflife"),
        FriendOfTheWolf("friendofthewolf"),
        BatSplat("batsplat"),
        SpiritsFlown("spirtshavingflown"),
        PearlJammin("pearljammin"),
        TheWalkingSpam("walkingspam"),
        AllHandsOnDeck("allhands");

        private final String _id;

        private Id(String id) {
            this._id = "vfp_" + id;
        }

        public String id() {
            return this._id;
        }

        public String statid() {
            return "achievement." + this.id();
        }
    }
}

