/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.core;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.OneXp;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;

public final class VfpRewards {
    private static boolean _ENABLED = false;
    public static final float NO_XP = 0.0f;
    private static final Map<ItemStack, Float> EXPERIENCE_LIST = new Hashtable<ItemStack, Float>();
    private static final Map<ItemStack, VfpAchievements.Id> GENERIC_ACHIEVEMENT_LIST = new Hashtable<ItemStack, VfpAchievements.Id>();
    private static final Map<PotionType, VfpAchievements.Id> POTIONS_ACHIEVEMENT_LIST = new Hashtable<PotionType, VfpAchievements.Id>();
    private static int GENEROUS_XP_MIN_BATCH = Integer.MAX_VALUE;
    private static boolean GENEROUS_XP = false;
    private static Map<PotionType, Boolean> _IGNORED_POTION_TYPES = new Hashtable<PotionType, Boolean>();

    static final void init(VfpConfig config) {
        _ENABLED = true;
        if (config.generousCraftingXp()) {
            GENEROUS_XP = true;
            GENEROUS_XP_MIN_BATCH = MinecraftGlue.TABLE_CRAFT_GRID_SIZE();
        }
        _IGNORED_POTION_TYPES.put(PotionTypes.field_185229_a, true);
        _IGNORED_POTION_TYPES.put(PotionTypes.field_185230_b, true);
        _IGNORED_POTION_TYPES.put(PotionTypes.field_185233_e, true);
        _IGNORED_POTION_TYPES.put(PotionTypes.field_185232_d, true);
        _IGNORED_POTION_TYPES.put(PotionTypes.field_185231_c, true);
    }

    public static final IRecipe addRewardingCraftItem(IRecipe recipe, float experience) {
        ItemStack output;
        if (experience > 0.0f && !MinecraftGlue.ItemStacks_isEmpty(output = recipe.func_77571_b())) {
            EXPERIENCE_LIST.put(output.func_77946_l(), Float.valueOf(experience));
        }
        return recipe;
    }

    public static final void addRewardingCraftItem(ItemStack target, float experience) {
        if (experience > 0.0f && !MinecraftGlue.ItemStacks_isEmpty(target)) {
            EXPERIENCE_LIST.put(target.func_77946_l(), Float.valueOf(experience));
        }
    }

    public static final void addRewardingCraftItem(ItemStack target, VfpAchievements.Id achievement) {
        if (achievement != null) {
            GENERIC_ACHIEVEMENT_LIST.put(target.func_77946_l(), achievement);
        }
    }

    public static final void addRewardingCraftItem(Item target, VfpAchievements.Id achievement) {
        if (achievement != null) {
            GENERIC_ACHIEVEMENT_LIST.put(new ItemStack(target), achievement);
        }
    }

    public static final void addRewardingBrewItem(PotionType potionType, VfpAchievements.Id achievement) {
        if (potionType != null && !_IGNORED_POTION_TYPES.containsKey(potionType)) {
            POTIONS_ACHIEVEMENT_LIST.put(potionType, achievement);
        }
    }

    public static final Map<ItemStack, Float> getExperienceMap() {
        return _ENABLED ? Collections.unmodifiableMap(EXPERIENCE_LIST) : Collections.EMPTY_MAP;
    }

    private static boolean equalStacks(ItemStack crafted, ItemStack target) {
        return !MinecraftGlue.ItemStacks_isEmpty(crafted) && target.func_77973_b() == crafted.func_77973_b() && (target.func_77960_j() == Short.MAX_VALUE || target.func_77960_j() == crafted.func_77960_j());
    }

    private static final float getCraftingXpRegistered(ItemStack crafted) {
        for (Map.Entry<ItemStack, Float> next : EXPERIENCE_LIST.entrySet()) {
            if (!VfpRewards.equalStacks(crafted, next.getKey())) continue;
            return next.getValue().floatValue();
        }
        return 0.0f;
    }

    private static final VfpAchievements.Id getAchievementRegistered(ItemStack crafted, boolean brewed) {
        block3: {
            block2: {
                if (brewed) break block2;
                for (Map.Entry<ItemStack, VfpAchievements.Id> next : GENERIC_ACHIEVEMENT_LIST.entrySet()) {
                    if (!VfpRewards.equalStacks(crafted, next.getKey())) continue;
                    return next.getValue();
                }
                break block3;
            }
            PotionType potionType = PotionUtils.func_185191_c((ItemStack)crafted);
            if (_IGNORED_POTION_TYPES.containsKey(potionType)) break block3;
            for (Map.Entry<PotionType, VfpAchievements.Id> next : POTIONS_ACHIEVEMENT_LIST.entrySet()) {
                if (next.getKey() != potionType) continue;
                return next.getValue();
            }
        }
        return null;
    }

    public static final float getCraftingXp(ItemStack crafted) {
        Item item;
        float xp = 0.0f;
        Item item2 = item = crafted == null ? null : crafted.func_77973_b();
        if (item != null && (xp = VfpRewards.getCraftingXpRegistered(crafted)) == 0.0f && item instanceof VfpAware) {
            xp = ((VfpAware)item).vfplink().craftingXp();
        }
        return xp;
    }

    public static final void onCraftingCheckXp(EntityPlayer player, int count, ItemStack crafted) {
        World world = player.func_130014_f_();
        if (!world.field_72995_K) {
            float f = VfpRewards.getCraftingXp(crafted);
            int n = count;
            if (f == 0.0f) {
                n = 0;
            } else if (f < 1.0f) {
                n = 0;
                float chance = player.func_130014_f_().field_73012_v.nextFloat();
                if (chance < f) {
                    n = 1;
                } else if (GENEROUS_XP && count > GENEROUS_XP_MIN_BATCH && chance < OneXp.Per03.value()) {
                    n = 1;
                }
            } else {
                int n2 = n = GENEROUS_XP ? MathHelper.func_76123_f((float)f) : (int)f;
            }
            while (n > 0) {
                int j = EntityXPOrb.func_70527_a((int)n);
                n -= j;
                world.func_72838_d((Entity)new EntityXPOrb(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v + 0.5, j));
            }
        }
    }

    public static final void onCraftingCheckAchievement(EntityPlayer player, ItemStack crafted) {
        VfpAchievements.Id achieved;
        if (!player.func_130014_f_().field_72995_K && (achieved = VfpRewards.getAchievementRegistered(crafted, false)) != null) {
            VfpAchievements.triggerAchievement(player, achieved);
        }
    }

    public static final void onBrewingCheckAchievement(EntityPlayer player, ItemStack brewed) {
        VfpAchievements.Id achieved;
        if (!player.func_130014_f_().field_72995_K && (achieved = VfpRewards.getAchievementRegistered(brewed, true)) != null) {
            VfpAchievements.triggerAchievement(player, achieved);
        }
    }

    private VfpRewards() {
    }

    static final class ForgeEventHandler {
        private static ForgeEventHandler instance;

        static final ForgeEventHandler init(VfpConfig config) {
            instance = new ForgeEventHandler(config);
            return instance;
        }

        @SubscribeEvent
        public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
            int amountCrafted = MinecraftGlue.ItemStacks_getSize(event.crafting);
            if (amountCrafted <= 0) {
                amountCrafted = 1;
            }
            VfpRewards.onCraftingCheckXp(event.player, amountCrafted, event.crafting);
            VfpRewards.onCraftingCheckAchievement(event.player, event.crafting);
        }

        @SubscribeEvent
        public void onItemSmelted(PlayerEvent.ItemSmeltedEvent event) {
            VfpRewards.onCraftingCheckAchievement(event.player, event.smelting);
        }

        @SubscribeEvent
        public void onItemBrewed(PlayerBrewedPotionEvent event) {
            VfpRewards.onBrewingCheckAchievement(event.getEntityPlayer(), event.getStack());
        }

        private ForgeEventHandler(VfpConfig config) {
        }
    }
}

