/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import java.util.Collection;
import net.minecraft.item.ItemStack;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;
import org.jwaresoftware.mcmods.vfp.meats.Kebabs;
import org.jwaresoftware.mcmods.vfp.meats.MeatPortions;

public final class ImplANM {
    private static final String[] redmeat = new String[]{"raw_prime_steak", "raw_longhorn_steak", "raw_hereford_steak", "raw_angus_steak"};
    private static final String[] pork = new String[]{"raw_prime_bacon", "raw_old_spot_bacon", "raw_large_black_bacon", "raw_hampshire_bacon", "raw_duroc_bacon"};
    private static final String[] poultry = new String[]{"raw_prime_chicken", "raw_wyandotte_chicken", "raw_rhode_island_red_chicken", "raw_plymouth_rock_chicken", "raw_orpington_chicken"};

    static final void fixFoodDictionary(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.ANM)) {
            String[] small_roasts = new String[]{"cooked_prime_pork", "cooked_old_spot_roast", "cooked_large_black_roast", "cooked_hampshire_roast", "cooked_duroc_roast"};
            IntegrationsImpl._registerFoodItems(Integrations.ANM, "foodPorkRoastSmall", small_roasts);
            small_roasts = new String[]{"raw_prime_pork", "raw_old_spot_pork", "raw_large_black_pork", "raw_hampshire_pork", "raw_duroc_pork"};
            IntegrationsImpl._registerFoodItems(Integrations.ANM, "foodRawPorkRoastSmall", small_roasts);
            IntegrationsImpl._registerFoodItems(Integrations.ANM, "foodChicken", poultry);
            small_roasts = new String[]{"cooked_prime_chicken", "cooked_orpington_chicken", "cooked_plymouth_rock_chicken", "cooked_rhode_island_red_chicken", "cooked_wyandotte_chicken"};
            IntegrationsImpl._registerFoodItems(Integrations.ANM, "foodChickenCooked", small_roasts);
        }
    }

    static final void registerRedMeat(VfpConfig config) {
        if (config.isModLoaded(Integrations.ANM)) {
            String[] cooked_redmeat = new String[]{"cooked_prime_steak", "cooked_longhorn_steak", "cooked_hereford_steak", "cooked_angus_steak"};
            IntegrationsImpl._registerFoodItems(Integrations.ANM, "foodRedMeat", redmeat);
            IntegrationsImpl._registerFoodItems(Integrations.ANM, "foodRedMeatCooked", cooked_redmeat);
            IntegrationsImpl._registerFoodItems(Integrations.ANM, "foodBeefsteakCooked", cooked_redmeat);
            IntegrationsImpl._registerFoodItems(Integrations.ANM, "foodNativeGameMeatCooked", cooked_redmeat);
        }
    }

    static final void registerKebabItems(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.ANM)) {
            IntegrationsImpl._registerFoodItems(Integrations.ANM, "foodGoodMeat", redmeat);
            IntegrationsImpl._registerFoodItems(Integrations.ANM, "foodGoodMeat", pork);
            IntegrationsImpl._registerFoodItems(Integrations.ANM, "foodGoodMeat", poultry);
            IntegrationsImpl._registerFoodItem(Integrations.ANM, "ingredientKebabAdventure", "raw_frog_legs");
        }
    }

    static final void registerCompatibleForgeIds(VfpConfig config) {
        if (config.isModLoaded(Integrations.ANM)) {
            IntegrationsImpl._registerFoodItem(Integrations.ANM, "foodEggFried", "plain_omelette");
            IntegrationsImpl._registerMiscItem(Integrations.ANM, "itemFoodCutter", "carving_knife", true);
            IntegrationsImpl._registerMiscItem(Integrations.ANM, "portionMilkLarge", "friesian_bucket_milk");
            IntegrationsImpl._registerMiscItem(Integrations.ANM, "portionMilkLarge", "holstein_bucket_milk");
            IntegrationsImpl._registerMiscItem(Integrations.ANM, "foodSimpleEgg", "brown_egg");
            IntegrationsImpl._registerMiscItem(Integrations.ANM, "ingredientCheese", "friesian_cheese_wedge");
            IntegrationsImpl._registerMiscItem(Integrations.ANM, "ingredientCheese", "holstein_cheese_wedge");
            IntegrationsImpl._registerFoodItem(Integrations.ANM, "foodProteinCooked", "cooked_prime_beef");
            IntegrationsImpl._registerFoodItem(Integrations.ANM, "foodProteinCooked", "cooked_prime_pork");
            IntegrationsImpl._registerFoodItem(Integrations.ANM, "foodProteinCooked", "cooked_frog_legs");
            IntegrationsImpl._registerFoodItem(Integrations.ANM, "foodProteinCooked", "super_omelette");
            IntegrationsImpl._registerFoodItem(Integrations.ANM, "foodProteinCooked", "truffle_omelette");
            IntegrationsImpl._registerFoodItem(Integrations.ANM, "foodProteinCooked", "cheese_omelette");
            IntegrationsImpl._registerMiscItem(Integrations.ANM, "ingredientCondiment", "truffle");
        }
    }

    static final void registerPackagedFoods(VfpConfig config) {
    }

    private static final void addPortionRecipe(PackagedFood type, int size, String[] itemnames) {
        ItemStack portions = MeatPortions.get(type);
        MinecraftGlue.ItemStacks_setSize(portions, size > 0 ? size : 4);
        IntegrationsImpl._registerMeatPortionRecipe(Integrations.ANM, portions, itemnames);
    }

    private static final void addKebabRecipe(PackagedFood type, String[] itemnames) {
        ItemStack raw_kebab = type == PackagedFood.CHICKEN ? Kebabs.uncooked_poultry(4) : Kebabs.uncooked_meat(2);
        IntegrationsImpl._registerKebabRecipe(Integrations.ANM, raw_kebab, itemnames);
    }

    static final void autorecipeMisc(VfpConfig config) {
        if (config.isModLoaded(Integrations.ANM)) {
            ImplANM.addPortionRecipe(PackagedFood.BEEF, -1, redmeat);
            ImplANM.addPortionRecipe(PackagedFood.PORK, -1, pork);
            ImplANM.addPortionRecipe(PackagedFood.CHICKEN, 8, poultry);
            ImplANM.addKebabRecipe(PackagedFood.BEEF, redmeat);
            ImplANM.addKebabRecipe(PackagedFood.CHICKEN, poultry);
        }
    }
}

