/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.carton.CartonsBuildHelper;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;

final class ImplPMP {
    private static final String _CORN = "food_corn";
    private static final String _CASSAVA = "food_cassava_root";
    private static final String _TARO = "food_taro_root";
    private static final String _RICE = "food_rice";
    private static final String _RICE_WILD = "food_rice_wild";
    private static final String _SOYBEAN = "food_soybeans";
    private static final String _TOFU = "food_tofu";
    private static final String _TOMATO = "food_tomato";
    private static final String _CELERY = "food_celery";
    private static final String _ONION = "food_onion";
    private static final String _GARLIC = "food_garlic";
    private static final String _LEEK = "food_leek";
    private static final String _CUCUMBER = "food_cucumber";
    private static final String _SWEETPEPPER_Y = "food_bell_pepper_yellow";
    private static final String _SWEETPEPPER_R = "food_bell_pepper_red";
    private static final String _SWEETPEPPER_O = "food_bell_pepper_orange";
    private static final String _EGGPLANT = "food_eggplant";
    private static final String _BROCCOLI = "food_broccoli";
    private static final String _CAULIFLOWER = "food_cauliflower";
    private static final String _GREENBEANS = "food_green_beans";
    private static final String _LENTILS = "food_lentils";
    private static final String _SPINACH = "food_spinach";
    private static final String _WATERCRESS = "food_watercress";
    private static final String _BRUSSELSPROUTS = "food_brussels_sprout";
    private static final String _SQUASH = "food_squash";
    private static final String _SWISS_CHARD = "food_swiss_chard";
    private static final String _GRAPES = "food_grapes_purple";
    private static final String _STRAWBERRY = "food_strawberry";
    private static final String _BLUEBERRY = "food_blueberry";
    private static final String _KIWI = "food_kiwi";
    private static final String _PEANUTS = "food_peanuts";
    private static final String _MANGO = "food_mango";
    private static final String _ORANGE = "food_orange";
    private static final String _TANGERINE = "food_tangerine";
    private static final String _GRAPEFRUIT = "food_grapefruit";
    private static final String _BANANA = "food_banana";
    private static final String _AVOCADO = "food_avocado";
    private static final String _COCONUT = "food_coconut";
    private static final String _PLUM = "food_plum";
    private static final String _PEAR = "food_pear";
    private static final String _CHERRIES = "food_cherry";
    private static final String _LEMON = "food_lemon";
    private static final String _LIME = "food_lime";
    private static final String _PINEAPPLE = "food_pineapple";
    private static final String _LETTUCE = "food_lettuce";
    private static final String _APPLE_G = "food_apple_green";
    private static final String _APPLE_Y = "food_apple_yellow";
    private static final String _PBJ_SANDWICH = "food_sandwich_pbj";
    private static final String _COOKED_RICE = "food_cooked_rice";
    private static final String _CORN_MEAL = "food_corn_flour";
    private static final String _CORN_BREAD = "food_corn_bread";
    private static final String _T = "_T";
    private static final String _F = "_F";

    ImplPMP() {
    }

    private static String[] SEEDS() {
        return new String[]{"eggplant", "tomato", "corn", "cucumber", "spinach", "asparagus", "brussels_sprout", "garlic", "broccoli", "celery", "leek", "cauliflower", "green_beans", "chard", "squash", "cassava", "pineapple", "bell_pepper_yellow", "bell_pepper_red", "bell_pepper_orange", "lettuce", "peanuts", "lentils", "rice", "rice_wild", "soybeans"};
    }

    private static String[] BERRIES() {
        return new String[]{"blackberry", "blueberry", "elderberry", "strawberry"};
    }

    static final void fixFoodDictionary(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.ReW) && config.fixReWFoodDictionary()) {
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCorn", _CORN);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodRice", _RICE);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodRice", _RICE_WILD);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodTaro", _TARO);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCassava", _CASSAVA);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodSoybean", _SOYBEAN);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodAvocado", _AVOCADO);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodTofu", _TOFU);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodTomato", _TOMATO);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCelery", _CELERY);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodOnion", _ONION);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodGarlic", _GARLIC);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodLeek", _LEEK);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCucumber", _CUCUMBER);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBellPepper", _SWEETPEPPER_Y);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBellPepper", _SWEETPEPPER_R);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBellPepper", _SWEETPEPPER_O);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodEggplant", _EGGPLANT);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodSquash", _SQUASH);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBroccoli", _BROCCOLI);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCauliflower", _CAULIFLOWER);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodChard", _SWISS_CHARD);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodMustardGreens", _SWISS_CHARD);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodGreenBeans", _GREENBEANS);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodSpinach", _SPINACH);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBrusselSprouts", _BRUSSELSPROUTS);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodLentils", _LENTILS);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodGrapes", _GRAPES);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodStrawberry", _STRAWBERRY);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBlueberry", _BLUEBERRY);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodKiwi", _KIWI);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodPeanuts", _PEANUTS);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodMango", _MANGO);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodLime", _LIME);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodLemon", _LEMON);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodOrange", _ORANGE);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodTangerine", _TANGERINE);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCoconut", _COCONUT);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodPlums", _PLUM);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBanana", _BANANA);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodPineapple", _PINEAPPLE);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodGrapefruit", _GRAPEFRUIT);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodPear", _PEAR);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCherry", _CHERRIES);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodWatercress", _WATERCRESS);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodLettuce", _LETTUCE);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodApple", _APPLE_G);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodApple", _APPLE_Y);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBread", _CORN_BREAD);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodPBJ", _PBJ_SANDWICH);
        }
    }

    static final void registerKebabItems(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.ReW) && !config.fixReWFoodDictionary()) {
            String[] primary = new String[]{_TOFU, _BROCCOLI, _EGGPLANT, _CASSAVA, _CAULIFLOWER, _TARO};
            IntegrationsImpl._registerFoodItems(Integrations.ReW, "ingredientKebabMain", primary);
            String[] fillers = new String[]{_TOMATO, _ONION, _LEEK, _CORN, _BRUSSELSPROUTS, _PINEAPPLE, _SWEETPEPPER_Y, _SWEETPEPPER_R, _SWEETPEPPER_O};
            IntegrationsImpl._registerFoodItems(Integrations.ReW, "ingredientKebabFill", fillers);
            String[] fruit = new String[]{_MANGO, _APPLE_G, _APPLE_Y, _BANANA, _KIWI, _PLUM, _PEAR, _ORANGE, _TANGERINE};
            IntegrationsImpl._registerFoodItems(Integrations.ReW, "ingredientKebabFruit", fruit);
            String[] nuggets = new String[]{_BROCCOLI, _EGGPLANT, _CAULIFLOWER};
            IntegrationsImpl._registerFoodItems(Integrations.ReW, "ingredientVegNugget", nuggets);
        }
    }

    static final void registerFoodPowders(int slotid_0th, VfpConfig config) {
        if (config.isModLoaded(Integrations.ReW) && !config.fixReWFoodDictionary()) {
            FoodPowders.Type fpt;
            Item item;
            boolean debug = config.isDebugMode();
            int id = slotid_0th;
            if (FoodPowders.findType("strawberry") == null && (item = Item.func_111206_d((String)Integrations.ReW.itemid(_STRAWBERRY))) != null) {
                fpt = new FoodPowders.Type(id, "strawberry", new ItemStack(item), 1, 2, null, (Integer)0xDD6161);
                if (debug) {
                    FMLLog.fine((String)"ReW foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("blueberry") == null && (item = Item.func_111206_d((String)Integrations.ReW.itemid(_BLUEBERRY))) != null) {
                fpt = new FoodPowders.Type(id, "blueberry", new ItemStack(item), 1, 3, null, (Integer)6384842);
                if (debug) {
                    FMLLog.fine((String)"ReW foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("peanuts") == null && (item = Item.func_111206_d((String)Integrations.ReW.itemid(_PEANUTS))) != null) {
                fpt = new FoodPowders.Type(id, "peanuts", new ItemStack(item), 0, 3, null, (Integer)12816928);
                if (debug) {
                    FMLLog.fine((String)"ReW foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("mango") == null && (item = Item.func_111206_d((String)Integrations.ReW.itemid(_MANGO))) != null) {
                fpt = new FoodPowders.Type(id, "mango", new ItemStack(item), 1, null, (Integer)16759296);
                if (debug) {
                    FMLLog.fine((String)"ReW foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("pineapple") == null && (item = Item.func_111206_d((String)Integrations.ReW.itemid(_PINEAPPLE))) != null) {
                fpt = new FoodPowders.Type(id, "pineapple", new ItemStack(item), 1, null, (Integer)16769875);
                if (debug) {
                    FMLLog.fine((String)"ReW foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("onion") == null && (item = Item.func_111206_d((String)Integrations.ReW.itemid(_ONION))) != null) {
                fpt = new FoodPowders.Type(id, "onion", new ItemStack(item), 0x100000, "ingredientOnion", null);
                if (debug) {
                    FMLLog.fine((String)"ReW foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("leek") == null && (item = Item.func_111206_d((String)Integrations.ReW.itemid(_LEEK))) != null) {
                fpt = new FoodPowders.Type(id, "leek", new ItemStack(item), 0x101000, null, (Integer)15859668);
                if (debug) {
                    FMLLog.fine((String)"ReW foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("tomato") == null && (item = Item.func_111206_d((String)Integrations.ReW.itemid(_TOMATO))) != null) {
                fpt = new FoodPowders.Type(id, "tomato", new ItemStack(item), 4096, 2, "ingredientTomato", (Integer)14111549);
                OreDictionary.registerOre((String)"ingredientTomato", (Item)item);
                if (debug) {
                    FMLLog.fine((String)"ReW foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("celery") == null && (item = Item.func_111206_d((String)Integrations.ReW.itemid(_CELERY))) != null) {
                fpt = new FoodPowders.Type(id, "celery", new ItemStack(item), 0x100000, null, null);
                if (debug) {
                    FMLLog.fine((String)"ReW foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
            if (FoodPowders.findType("garlic") == null && (item = Item.func_111206_d((String)Integrations.ReW.itemid(_GARLIC))) != null) {
                fpt = new FoodPowders.Type(id, "garlic", new ItemStack(item), 0x100000, "ingredientGarlic", null);
                if (debug) {
                    FMLLog.fine((String)"ReW foodPowder: '%s'", (Object[])new Object[]{fpt});
                }
            }
            ++id;
        }
    }

    static final void registerMushrooms(Collection<String> mappings, VfpConfig config) {
        if (config.isModLoaded(Integrations.ReW)) {
            String[] fungi;
            boolean generalize = config.fixReWFoodDictionary();
            for (String fungus : fungi = new String[]{"plant_chanterelle", "plant_giant_club", "plant_weeping_milk_cap", "plant_stinkhorn", "plant_wood_blewit", "plant_black_powderpuff", "plant_parasol"}) {
                Block item = Block.func_149684_b((String)Integrations.ReW.itemid(fungus));
                if (item == null) continue;
                if (generalize) {
                    OreDictionary.registerOre((String)"foodMushroom", (Block)item);
                }
                OreDictionary.registerOre((String)"ingredientMushroom", (Block)item);
                OreDictionary.registerOre((String)"ingredientKebabFill", (Block)item);
                OreDictionary.registerOre((String)"greenLitterFungi", (Block)item);
            }
        }
    }

    static final void registerPackagedFoods(VfpConfig config) {
        if (!config.isModLoaded(Integrations.ReW)) {
            return;
        }
        boolean debug = config.isDebugMode();
        VfpCapacity BULK = VfpCapacity.BULK_STACK;
        String[] baggables = new String[]{"fruit", _STRAWBERRY, "strawberries", _F, "fruit", _BLUEBERRY, "blueberries", _F, "fruit", _PEANUTS, "peanuts", _F, "fruit", _GRAPES, "grapes", _T, "vegetable", _CORN, "corn", _F, "vegetable", _BROCCOLI, "broccoli", _F, "vegetable", _SPINACH, "spinach", _F, "vegetable", _TOMATO, "tomatoes", _F, "vegetable", _EGGPLANT, "eggplant", _F, "vegetable", _CASSAVA, "cassava", _F, "bakery", _PBJ_SANDWICH, "sandwich_pbj", _F, "general", _COOKED_RICE, "precooked_rice", _T};
        for (int i = 0; i < baggables.length; i += 4) {
            PackagedFood.Type type = PackagedFood.Type.valueOf(baggables[i]);
            Item item = Item.func_111206_d((String)Integrations.ReW.itemid(baggables[i + 1]));
            if (!(item instanceof ItemFood)) continue;
            PackagedFood pf = new PackagedFood(type.name(), baggables[i + 2], new LikeFood((ItemFood)item), null, null, BULK);
            if (baggables[i + 3] == _T) {
                CartonsBuildHelper.exclude(type, pf);
            }
            if (!debug) continue;
            FMLLog.finer((String)"ReW packagedFood '%s' registers: %s", (Object[])new Object[]{baggables[i], pf});
        }
    }

    static final void registerCompatibleForgeIds(VfpConfig config) {
        if (config.isModLoaded(Integrations.ReW)) {
            String[] berries;
            String[] crops = ImplPMP.SEEDS();
            Item corn = null;
            for (String cropname : crops) {
                boolean dryable;
                Item seed = Item.func_111206_d((String)Integrations.ReW.itemid("seed_" + cropname));
                boolean bl = dryable = seed != null;
                if (!dryable) {
                    seed = Item.func_111206_d((String)Integrations.ReW.itemid("food_" + cropname));
                }
                if (seed == null) continue;
                OreDictionary.registerOre((String)"greenLitterSeeds", (Item)seed);
                if (dryable) {
                    OreDictionary.registerOre((String)"itemDryableSeed", (Item)seed);
                }
                if (!"corn".equals(cropname)) continue;
                corn = seed;
            }
            if (corn != null) {
                OreDictionary.registerOre((String)"additiveScaffold", corn);
            }
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodLightGreens", _LETTUCE);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodLightGreens", _WATERCRESS);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodLightGreens", _SPINACH);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodSandwich", "food_sandwich_fish");
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodSandwich", "food_sandwich_meat");
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodSandwich", _PBJ_SANDWICH);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "ingredientCereal", _COOKED_RICE);
            IntegrationsImpl._registerMiscItem(Integrations.ReW, "foodFlourCorn", _CORN_MEAL);
            if (!config.isPresent("cornmeal")) {
                config.setPresentAs("cornmeal", "foodFlourCorn");
            }
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "portionBread", "food_corn_tortilla");
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBerry", _STRAWBERRY);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBerry", _BLUEBERRY);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBerry", _CHERRIES);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodBerry", "food_blackberry");
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCitrusFruit", _TANGERINE);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCitrusFruit", _LIME);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCitrusFruit", _LEMON);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCitrusFruit", _ORANGE);
            IntegrationsImpl._registerFoodItem(Integrations.ReW, "foodCitrusFruit", _GRAPEFRUIT);
            boolean fixTreeDict = config.fixReWTreeDictionary();
            for (String berryname : berries = ImplPMP.BERRIES()) {
                Block plant = Block.func_149684_b((String)Integrations.ReW.itemid("plant_" + berryname));
                if (!(plant instanceof IPlantable)) continue;
                OreDictionary.registerOre((String)"greenLitterOther", (Block)plant);
                if (!fixTreeDict) continue;
                OreDictionary.registerOre((String)"plantBerry", (Block)plant);
            }
            if (fixTreeDict) {
                String[] planks;
                String[] logs;
                String[] leaves;
                String[] saplings;
                for (String sapling : saplings = new String[]{"sapling_acacia", "sapling_birch", "sapling_birch_white", "sapling_dark_oak", "sapling_jungle", "sapling_oak", "sapling_spruce", "sapling_fruit1", "sapling_fruit2", "sapling_fruit3", "sapling_fruit4"}) {
                    Block block = Block.func_149684_b((String)Integrations.ReW.itemid(sapling));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack(block, 1, Item.func_150898_a((Block)block).func_77614_k() ? Short.MAX_VALUE : 0));
                }
                for (String leaf : leaves = new String[]{"leaves_birch", "leaves_birch_white", "leaves_dark_oak", "leaves_jungle", "leaves_oak", "leaves_spruce", "leaves_fruit1", "leaves_fruit2", "leaves_fruit3", "leaves_fruit4"}) {
                    Block block = Block.func_149684_b((String)Integrations.ReW.itemid(leaf));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack(block, 1, Item.func_150898_a((Block)block).func_77614_k() ? Short.MAX_VALUE : 0));
                }
                for (String log : logs = new String[]{"log_fruitwood"}) {
                    Block block = Block.func_149684_b((String)Integrations.ReW.itemid(log));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(block, 1, Item.func_150898_a((Block)block).func_77614_k() ? Short.MAX_VALUE : 0));
                }
                for (String plank : planks = new String[]{"planks_fruitwood"}) {
                    Block block = Block.func_149684_b((String)Integrations.ReW.itemid(plank));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(block, 1, Item.func_150898_a((Block)block).func_77614_k() ? Short.MAX_VALUE : 0));
                }
                for (String plank : planks = new String[]{"block_bamboo_asper", "block_bamboo_fargesia", "block_bamboo_giant_timber", "block_bamboo_golden", "block_bamboo_moso", "block_bamboo_short_tassled", "block_bamboo_timor_black", "block_bamboo_tropical_blue", "block_bamboo_wet_forest"}) {
                    Block block = Block.func_149684_b((String)Integrations.ReW.itemid(plank));
                    if (block == null) continue;
                    OreDictionary.registerOre((String)"plankBamboo", (ItemStack)new ItemStack(block, 1, Item.func_150898_a((Block)block).func_77614_k() ? Short.MAX_VALUE : 0));
                }
            }
        }
    }

    static final void autorecipeMisc(VfpConfig config) {
        if (config.isModLoaded(Integrations.ReW)) {
            Item eggplant;
            int yes = 0;
            Item corn_on_cob = Item.func_111206_d((String)Integrations.ReW.itemid(_CORN));
            if (corn_on_cob instanceof ItemFood) {
                ++yes;
                GameRegistry.addSmelting((ItemStack)new ItemStack(corn_on_cob), (ItemStack)new ItemStack(VfpObj.Roast_Corn_obj), (float)LikeFood.uncooked_potato.smeltExperience());
            }
            if ((eggplant = Item.func_111206_d((String)Integrations.ReW.itemid(_EGGPLANT))) instanceof ItemFood) {
                ++yes;
                GameRegistry.addSmelting((ItemStack)new ItemStack(eggplant), (ItemStack)new ItemStack(VfpObj.Roasted_Eggplant_obj), (float)LikeFood.uncooked_potato.smeltExperience());
            }
            if (yes == 2 && config.includeReWCropSeedRecipes()) {
                String[] crops;
                for (String cropname : crops = ImplPMP.SEEDS()) {
                    Item seed = Item.func_111206_d((String)Integrations.ReW.itemid("seed_" + cropname));
                    Item food = Item.func_111206_d((String)Integrations.ReW.itemid("food_" + cropname));
                    if (seed == null || food == null) continue;
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(seed, 2), new Object[]{"s", "p", Character.valueOf('s'), food, Character.valueOf('p'), "paper"}));
                }
            }
        }
    }
}

