/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.integrations.ImplANM;
import org.jwaresoftware.mcmods.vfp.integrations.ImplAQC;
import org.jwaresoftware.mcmods.vfp.integrations.ImplHCB;
import org.jwaresoftware.mcmods.vfp.integrations.ImplHVC;
import org.jwaresoftware.mcmods.vfp.integrations.ImplPMP;
import org.jwaresoftware.mcmods.vfp.integrations.ImplPNKS;
import org.jwaresoftware.mcmods.vfp.integrations.ImplSCO;
import org.jwaresoftware.mcmods.vfp.integrations.ImplXFB;
import org.jwaresoftware.mcmods.vfp.integrations.ImplYAFM;
import org.jwaresoftware.mcmods.vfp.meats.Kebabs;
import org.jwaresoftware.mcmods.vfp.meats.MeatPortions;

public final class IntegrationsImpl {
    static final String LITTER_SEEDS_LISTID = "greenLitterSeeds";
    static final String LITTER_FUNGI_LISTID = "greenLitterFungi";
    static final String LITTER_TUBER_LISTID = "greenLitterTuber";
    static final String LITTER_OTHER_LISTID = "greenLitterOther";
    static final int _ANY_TYPE = Short.MAX_VALUE;
    public static final String[] COMMON_INGREDIENTS = new String[]{"Corn", "Soybean", "Peanuts", "SweetPotato", "Cassava", "Taro", "Onion", "Garlic", "Pepper", "Celery", "Tomato", "Leek", "Scallions", "BellPepper", "Cucumber", "Avocado", "Spinach", "Dasheen", "Kale", "MustardGreens", "WildDandelion", "Cabbage", "Beets", "Thyme", "Parsley", "Basil", "Sage", "Oregano", "Paprika", "Peppercorn", "BayLeaves", "Mint", "Eggplant", "Squash", "Zucchini", "Okra", "Broccoli", "Cauliflower", "BrusselSprouts", "GreenBeans", "KidneyBeans", "PintoBeans", "ButterBeans", "BlackBeans", "Lentils", "Ginger", "Cinnamon", "Nutmeg", "Apple", "Coconut", "Mango", "Banana", "Strawberry", "Blueberry", "Kiwi", "Grapes", "Cantaloupe", "Pineapple", "Papaya", "Plums", "Pear", "Cherry", "Orange", "Lime", "Lemon", "Grapefruit", "Tangerine", "Rice", "Tofu", "CoffeeBean", "Watercress"};
    public static final String[] COMMON_MIXTURE_SEEDS = new String[]{"Peppercorn", "Celery", "Mustard", "Dill", "Cloves", "Allspice", "Fennel"};
    static final String _XP_NBT_TAG = "vanillafoodpantry:craftXp";

    private static final String getPresentAs(String prefix, Collection<String> mappings, String foodid) {
        String forgeid = prefix + foodid;
        boolean present = mappings.contains(forgeid);
        if (!present && foodid.charAt(foodid.length() - 1) == 's') {
            forgeid = prefix + foodid.substring(0, foodid.length() - 1);
            present = mappings.contains(forgeid);
        }
        return present ? forgeid : null;
    }

    private static final void fixFoodIsSeed(Collection<String> mappings, VfpConfig config) {
        if (!config.isPresent("peppercorn") && config.isPresent("peppercorn_seed")) {
            config.setPresentAs("peppercorn", config.getPresentAs("peppercorn_seed"));
        }
        if (!config.isPresent("corn") && config.isPresent("corn_seed")) {
            config.setPresentAs("corn", config.getPresentAs("corn_seed"));
        }
        if (!config.isPresent("lentils") && config.isPresent("lentils_seed")) {
            config.setPresentAs("lentils", config.getPresentAs("lentils_seed"));
        }
    }

    public static final void detectFeatureSupport(VfpConfig config) {
        boolean roastSeedsPresent;
        boolean boneDropsPresent;
        boolean friedEggPresent;
        if (config.includeModRecipes()) {
            String forgeid;
            List<String> mappings = config.capturedContextOres();
            ImplPMP.fixFoodDictionary(mappings, config);
            ImplHVC.fixFoodDictionary(mappings, config);
            ImplANM.fixFoodDictionary(mappings, config);
            ImplSCO.fixFoodDictionary(mappings, config);
            config.captureContextOres();
            mappings = config.capturedContextOres();
            for (String foodid : COMMON_INGREDIENTS) {
                forgeid = IntegrationsImpl.getPresentAs("food", mappings, foodid);
                if (forgeid == null) continue;
                config.setPresentAs(foodid.toLowerCase(Locale.US), forgeid);
            }
            for (String foodid : COMMON_MIXTURE_SEEDS) {
                forgeid = IntegrationsImpl.getPresentAs("seed", mappings, foodid);
                if (forgeid == null) continue;
                config.setPresentAs(foodid.toLowerCase(Locale.US) + "_seed", forgeid);
            }
            IntegrationsImpl.fixFoodIsSeed(mappings, config);
        }
        if (friedEggPresent = IntegrationsImpl.detectSimpleFriedEggRecipe(config)) {
            config.setPresent("fried_eggs");
        }
        boolean bl = boneDropsPresent = !config.includeBoneDrops();
        if (boneDropsPresent) {
            config.setPresent("bone_drops");
        }
        if (roastSeedsPresent = IntegrationsImpl.detectRoastedSeedsRecipes(config)) {
            config.setPresent("roast_seeds");
        }
    }

    static final void _registerFoodItem(Integrations mod, String ingredient_id, String itemname) {
        Item item = Item.func_111206_d((String)mod.itemid(itemname));
        if (item instanceof ItemFood) {
            OreDictionary.registerOre((String)ingredient_id, (Item)item);
        }
    }

    static final void _registerFoodItems(Integrations mod, String ingredient_id, String[] choices) {
        for (String itemname : choices) {
            Item item = Item.func_111206_d((String)mod.itemid(itemname));
            if (!(item instanceof ItemFood)) continue;
            OreDictionary.registerOre((String)ingredient_id, (Item)item);
        }
    }

    static final void _registerFoodItems(String ingredient_id, Collection<ItemStack> choices) {
        for (ItemStack item : choices) {
            if (!(item.func_77973_b() instanceof ItemFood)) continue;
            OreDictionary.registerOre((String)ingredient_id, (ItemStack)item);
        }
    }

    private static final void foodItemToIngredient(String dictid, String ingredient_id) {
        NonNullList matches = OreDictionary.getOres((String)dictid);
        for (ItemStack food : matches) {
            OreDictionary.registerOre((String)ingredient_id, (ItemStack)food);
        }
    }

    static final void _registerMiscItem(Integrations mod, String ingredient_id, String itemname, boolean wildcard) {
        String moditemid = mod.itemid(itemname);
        Item item = Item.func_111206_d((String)moditemid);
        if (item != null) {
            ItemStack stack = new ItemStack(item, 1, wildcard && (item.func_77614_k() || item.func_77645_m()) ? Short.MAX_VALUE : 0);
            OreDictionary.registerOre((String)ingredient_id, (ItemStack)stack);
        } else {
            Block blok = Block.func_149684_b((String)moditemid);
            if (blok != null) {
                OreDictionary.registerOre((String)ingredient_id, (Block)blok);
            }
        }
    }

    static final void _registerMiscItem(Integrations mod, String ingredient_id, String itemname) {
        IntegrationsImpl._registerMiscItem(mod, ingredient_id, itemname, false);
    }

    static final void _registerMiscItem(Integrations mod, String ingredient_id, String itemname, int meta) {
        String moditemid = mod.itemid(itemname);
        Item item = Item.func_111206_d((String)moditemid);
        if (item != null) {
            ItemStack stack = new ItemStack(item, 1, meta);
            OreDictionary.registerOre((String)ingredient_id, (ItemStack)stack);
        } else {
            Block blok = Block.func_149684_b((String)moditemid);
            if (blok != null) {
                ItemStack stack = new ItemStack(blok, 1, meta);
                OreDictionary.registerOre((String)ingredient_id, (ItemStack)stack);
            }
        }
    }

    static final void _registerMeatPortionRecipe(Integrations mod, ItemStack portions, String[] itemnames) {
        for (String itemname : itemnames) {
            Item mainfood = Item.func_111206_d((String)mod.itemid(itemname));
            if (mainfood == null) continue;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(portions, new Object[]{mainfood, "itemFoodCutter"}));
        }
    }

    static final void _registerKebabRecipe(ItemStack raw_kebab, Object mainfood) {
        if (mainfood != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(raw_kebab, new Object[]{"vv", "ms", Character.valueOf('v'), "ingredientKebabFill", Character.valueOf('m'), mainfood, Character.valueOf('s'), VfpObj.Skewers_Wood_obj}));
        }
    }

    static final void _registerKebabRecipe(Integrations mod, ItemStack raw_kebab, String[] itemnames) {
        for (String itemname : itemnames) {
            Item mainfood = Item.func_111206_d((String)mod.itemid(itemname));
            if (mainfood == null) continue;
            IntegrationsImpl._registerKebabRecipe(raw_kebab, new ItemStack(mainfood));
        }
    }

    public static final void registerFoodPowders(Collection<String> mappings, VfpConfig config) {
        FoodPowders.Type fpt;
        if (!config.includeModRecipes()) {
            return;
        }
        boolean debug = config.isDebugMode();
        int slotid = FoodPowders.Type.reservedPowderCount();
        int MAX_COMMON_SLOTS = 32;
        int NUM_COMMON_MIXED_POWDERS = 8;
        int id = slotid;
        String item = config.getPresentAs("strawberry");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "strawberry", DictionaryNameItemAdaptor.newi(item), 1, 2, null, (Integer)0xDD6161);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(strawberry): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("blueberry");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "blueberry", DictionaryNameItemAdaptor.newi(item), 1, 3, null, (Integer)6384842);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(blueberry): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("peanuts");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "peanuts", DictionaryNameItemAdaptor.newi(item), 0, 3, null, (Integer)12816928);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(peanuts): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("mango");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "mango", DictionaryNameItemAdaptor.newi(item), 1, null, (Integer)16759296);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(mango): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("pineapple");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "pineapple", DictionaryNameItemAdaptor.newi(item, 2), 1, null, (Integer)16769875);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(pineapple): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("peppercorn");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "peppercorn", DictionaryNameItemAdaptor.newi(item), 0x100000, 3, "ingredientPeppercorn", null);
            IntegrationsImpl.foodItemToIngredient(item, "ingredientPeppercorn");
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(peppercorn): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("onion");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "onion", DictionaryNameItemAdaptor.newi(item), 0x100000, "ingredientOnion", null);
            IntegrationsImpl.foodItemToIngredient(item, "ingredientOnion");
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(onion): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("leek");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "leek", DictionaryNameItemAdaptor.newi(item), 0x101000, null, (Integer)15859668);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(leek): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("tomato");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "tomato", DictionaryNameItemAdaptor.newi(item), 4096, 2, "ingredientTomato", (Integer)14111549);
            IntegrationsImpl.foodItemToIngredient(item, "ingredientTomato");
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(tomato): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("celery");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "celery", DictionaryNameItemAdaptor.newi(item), 0x100000, null, null);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(celery): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("garlic");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "garlic", DictionaryNameItemAdaptor.newi(item), 0x100000, "ingredientGarlic", null);
            IntegrationsImpl.foodItemToIngredient(item, "ingredientGarlic");
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(garlic): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        item = config.getPresentAs("coffeebean");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "coffee", DictionaryNameItemAdaptor.newi(item), 0, 3, null, null);
            if (debug) {
                FMLLog.fine((String)"GEN foodPowder(coffee): '%s'", (Object[])new Object[]{fpt});
            }
        }
        int slotid_mixes_0 = id + 1;
        int slotid_mixes_N = slotid + 32;
        Validate.validState((slotid_mixes_0 - slotid < 24 ? 1 : 0) != 0, (String)"Only expected to have at most %d predefined food powders (excluding mixes); currently have %d ", (Object[])new Object[]{24, slotid_mixes_0 - slotid});
        slotid_mixes_0 = slotid + 32 - 8;
        slotid += 32;
        for (Integrations ii : Integrations.orderedValues()) {
            if (config.isModLoaded(ii)) {
                switch (ii) {
                    case ReW: {
                        ImplPMP.registerFoodPowders(slotid, config);
                    }
                }
            }
            if (ii.reserve() <= 0) continue;
            for (int i = 0; i < ii.reserve(); ++i) {
                slotid += 8;
            }
        }
        IntegrationsImpl.registerMixedFoodPowders(mappings, config, slotid_mixes_0, slotid_mixes_N);
    }

    private static void registerMixedFoodPowders(Collection<String> mappings, VfpConfig config, int slotid_0, int slotid_N) {
        FoodPowders.Type fpt;
        String[] required;
        int id = slotid_0;
        boolean craftable = true;
        for (String ingredient : required = new String[]{"peppercorn", "celery", "onion"}) {
            if (config.isPresent(ingredient)) continue;
            craftable = false;
            break;
        }
        if (craftable) {
            fpt = new FoodPowders.Type(id, "stew_mix", DictionaryNameItemAdaptor.newi("unused"), 0x100000, null, true);
            if (config.isDebugMode()) {
                FMLLog.fine((String)"GEN foodPowder(stew_mix): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        craftable = config.isPresent("lime");
        if (craftable) {
            String[] secondaries = new String[]{"lemon", "orange", "grapefruit", "tangerine"};
            int matches = 0;
            for (int i = 0; i < secondaries.length; ++i) {
                String s = config.getPresentAs(secondaries[i]);
                if (s == null) continue;
                IntegrationsImpl.foodItemToIngredient(s, "ingredientCitrusFill");
                ++matches;
            }
            if (matches > 0) {
                FoodPowders.Type fpt2 = new FoodPowders.Type(id, "citrus", DictionaryNameItemAdaptor.newi("unused"), 1, null, 13563136, true);
                if (config.isDebugMode()) {
                    FMLLog.fine((String)"GEN foodPowder(citrus_mix): '%s'", (Object[])new Object[]{fpt2});
                }
            }
        }
        ++id;
        boolean bl = craftable = FoodPowders.findType("coffee") != null;
        if (craftable) {
            fpt = new FoodPowders.Type(id, "mocha", DictionaryNameItemAdaptor.newi("unused"), 0, null, 7289344, true);
            if (config.isDebugMode()) {
                FMLLog.fine((String)"GEN foodPowder(mocha_mix): '%s'", (Object[])new Object[]{fpt});
            }
        }
        ++id;
        craftable = config.isPresent("grapes");
        ++id;
        ++id;
    }

    private static boolean detectSimpleFriedEggRecipe(VfpConfig config) {
        if (config.isSuperCompatibilityMode()) {
            return true;
        }
        boolean recipePresent = ImplYAFM.isFriedEggRecipePresent(config);
        if (!recipePresent) {
            recipePresent = config.isModLoaded(Integrations.HVC) || config.isModLoaded(Integrations.ANM) || config.isModLoaded(Integrations.BFo);
        }
        return recipePresent;
    }

    private static boolean detectRoastedSeedsRecipes(VfpConfig config) {
        if (config.isSuperCompatibilityMode()) {
            return true;
        }
        return config.isModLoaded(Integrations.BFo);
    }

    public static final void registerRedMeat(Collection<String> mappings, VfpConfig config) {
        if (config.includeModRecipes()) {
            ImplHVC.registerRedMeat(config);
            ImplANM.registerRedMeat(config);
        }
    }

    public static final void registerKebabItems(Collection<String> mappings, VfpConfig config) {
        String[] nuggets;
        String[] fruits;
        String[] fillers;
        String forgeid;
        String[] primary;
        if (!config.includeModRecipes()) {
            return;
        }
        for (String foodid : primary = new String[]{"tofu", "broccoli", "eggplant", "cauliflower", "cassava", "sweetpotato", "taro"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            NonNullList choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabMain", (Collection<ItemStack>)choices);
        }
        for (String foodid : fillers = new String[]{"tomato", "onion", "leek", "corn", "bellpepper", "zucchini", "brusselsprouts", "pineapple"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            NonNullList choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabFill", (Collection<ItemStack>)choices);
        }
        for (String foodid : fruits = new String[]{"pineapple_slice", "cantaloupe_slice", "mango", "banana", "kiwi", "orange", "pear", "plum", "tangerine"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            NonNullList choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabFruit", (Collection<ItemStack>)choices);
        }
        String[] small_fruits = new String[]{"strawberry", "cherry"};
        int hits = 0;
        for (String foodid : small_fruits) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            NonNullList choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabMiniFruit", (Collection<ItemStack>)choices);
            ++hits;
        }
        if (hits > 0) {
            config.setPresent("mini_fruit");
        }
        for (String foodid : nuggets = new String[]{"broccoli", "eggplant", "cauliflower", "zucchini", "pack_okra"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            NonNullList choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientVegNugget", (Collection<ItemStack>)choices);
        }
        ImplPNKS.registerKebabItems(mappings, config);
        ImplPMP.registerKebabItems(mappings, config);
        ImplHVC.registerKebabItems(mappings, config);
        ImplYAFM.registerKebabItems(mappings, config);
        ImplANM.registerKebabItems(mappings, config);
    }

    public static final void registerEdibleFlowers(Collection<String> mappings, VfpConfig config) {
        if (config.includeModRecipes()) {
            // empty if block
        }
    }

    public static final void registerMushrooms(Collection<String> mappings, VfpConfig config) {
        if (config.includeModRecipes()) {
            ImplPMP.registerMushrooms(mappings, config);
            ImplHVC.registerMushrooms(mappings, config);
        }
    }

    public static final void registerPackagedFoods(VfpConfig config) {
        if (!config.includeModRecipes()) {
            return;
        }
        for (Integrations ii : Integrations.orderedValues()) {
            switch (ii) {
                case ReW: {
                    ImplPMP.registerPackagedFoods(config);
                    break;
                }
                case HVC: {
                    ImplHVC.registerPackagedFoods(config);
                    break;
                }
                case ANM: {
                    ImplANM.registerPackagedFoods(config);
                }
            }
            if (ii.reserve() <= 0) continue;
            for (int j = 0; j < ii.reserve(); ++j) {
                PackagedFood.shift16();
            }
        }
    }

    public static final void registerAsTie(Item item) {
        OreDictionary.registerOre((String)"itemTieStrong", (Item)item);
        OreDictionary.registerOre((String)"itemTieNormal", (Item)item);
        OreDictionary.registerOre((String)"itemTieWeak", (Item)item);
        if (item != MinecraftGlue.Items_string) {
            OreDictionary.registerOre((String)"string", (Item)item);
        }
    }

    public static final void registerAsBread(Item bread, boolean sandwichToo, String ... otherIds) {
        OreDictionary.registerOre((String)"foodBread", (Item)bread);
        OreDictionary.registerOre((String)"bread", (Item)bread);
        if (sandwichToo) {
            OreDictionary.registerOre((String)"foodBreadSandwich", (Item)bread);
        }
        if (otherIds != null) {
            for (String oid : otherIds) {
                OreDictionary.registerOre((String)oid, (Item)bread);
            }
        }
    }

    public static final void registerAsBread(ItemStack bread, boolean sandwichToo, String ... otherIds) {
        OreDictionary.registerOre((String)"foodBread", (ItemStack)bread);
        OreDictionary.registerOre((String)"bread", (ItemStack)bread);
        if (sandwichToo) {
            OreDictionary.registerOre((String)"foodBreadSandwich", (ItemStack)bread);
        }
        if (otherIds != null) {
            for (String oid : otherIds) {
                OreDictionary.registerOre((String)oid, (ItemStack)bread);
            }
        }
    }

    public static final void registerForgeIds(VfpConfig config) {
        IntegrationsImpl.registerVanillaItemForgeIds();
        IntegrationsImpl.registerItemBucketIfMissing();
        if (config.includeModRecipes()) {
            ImplPMP.registerCompatibleForgeIds(config);
            ImplHVC.registerCompatibleForgeIds(config);
            ImplANM.registerCompatibleForgeIds(config);
            ImplAQC.registerCompatibleForgeIds(config);
            ImplXFB.registerCompatibleForgeIds(config);
            ImplSCO.registerCompatibleForgeIds(config);
            ImplHCB.registerCompatibleForgeIds(config);
        }
        IntegrationsImpl.registerGreenSaladIngredients(config);
        IntegrationsImpl.foodItemToIngredient("foodSimpleEgg", "ingredientEgg");
        IntegrationsImpl.foodItemToIngredient("foodKebabGoodMeat", "foodProteinCooked");
        IntegrationsImpl.foodItemToIngredient("ingredientHotPeppers", "ingredientCondiment");
        IntegrationsImpl.foodItemToIngredient("portionMayo", "ingredientCondiment");
        if (config.isPresent("onion")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("onion"), "ingredientAllium");
        }
    }

    public static final void defineModdedLoot(VfpConfig config) {
        ImplPNKS.registerLoot(config);
    }

    private static final void registerVanillaItemForgeIds() {
    }

    private static final void registerItemBucketIfMissing() {
        if (!VfpUtils.ingredientDefined("itemEmptyBucket")) {
            OreDictionary.registerOre((String)"itemEmptyBucket", (Item)MinecraftGlue.Items_bucket);
        }
        if (!VfpUtils.ingredientDefined("itemWaterBucket")) {
            OreDictionary.registerOre((String)"itemWaterBucket", (Item)MinecraftGlue.Items_water_bucket);
        }
        if (!VfpUtils.ingredientDefined("itemLavaBucket")) {
            OreDictionary.registerOre((String)"itemLavaBucket", (Item)MinecraftGlue.Items_lava_bucket);
        }
        if (!VfpUtils.ingredientDefined("itemMilkBucket")) {
            OreDictionary.registerOre((String)"itemMilkBucket", (Item)MinecraftGlue.Items_milk_bucket);
        }
    }

    private static final void registerGreenSaladIngredients(VfpConfig config) {
        IntegrationsImpl.foodItemToIngredient("foodLightGreens", "ingredientSalad");
        if (config.isPresent("avocado")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("avocado"), "ingredientSalad");
        }
        if (config.isPresent("tomato")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("tomato"), "ingredientSalad");
        }
        if (config.isPresent("grapes")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("grapes"), "ingredientSalad");
        }
        if (config.isPresent("bellpepper")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("bellpepper"), "ingredientSalad");
        }
        if (config.isPresent("cucumber")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("cucumber"), "ingredientSalad");
        }
    }

    public static final void registerCookedGoodMeat(VfpConfig config) {
        FurnaceRecipes registry = FurnaceRecipes.func_77602_a();
        for (ItemStack next : OreDictionary.getOres((String)"foodGoodMeat")) {
            ItemStack smelted = registry.func_151395_a(next.func_77946_l());
            if (MinecraftGlue.ItemStacks_isEmpty(smelted)) continue;
            OreDictionary.registerOre((String)"foodGoodMeatCooked", (ItemStack)smelted);
        }
    }

    private static final void addAllRegisteredCraftingXpRecipes(VfpConfig config) {
        ImmutableList registrations = FMLInterModComms.fetchRuntimeMessages((Object)"vanillafoodpantry");
        if (config.includeCraftXpAndAchievements()) {
            for (FMLInterModComms.IMCMessage msg : registrations) {
                if (!"addRewardingCraftItem".equals(msg.key) || !msg.isItemStackMessage()) continue;
                ItemStack crafted = msg.getItemStackValue();
                NBTTagCompound itemdata = null;
                if (!crafted.func_77942_o() || !(itemdata = crafted.func_77978_p()).func_150297_b(_XP_NBT_TAG, 99)) continue;
                float xp = itemdata.func_74760_g(_XP_NBT_TAG);
                VfpRewards.addRewardingCraftItem(crafted, xp);
            }
        }
    }

    public static final void registerAutocraftingRecipes(VfpConfig config) {
        IntegrationsImpl.addAllRegisteredCraftingXpRecipes(config);
        if (config.isModLoaded(Integrations.SMH) && config.isAutocraftingEnabled()) {
            IntegrationsImpl.registerItemBucketIfMissing();
            IntegrationsImpl.addHoardercraftRecipesBuilder(config, "org.jwaresoftware.mcmods.vfp.integrations.ImplSMH");
        }
    }

    static final void addHoardercraftRecipesBuilder(VfpConfig config, String builderClassName) {
        FMLInterModComms.sendMessage((String)Integrations.SMH.modid(), (String)"registerRecipes", (String)builderClassName);
    }

    public static final void autorecipeMisc(VfpConfig config) {
        if (config.includeModRecipes()) {
            IntegrationsImpl.addSimpleFishRecipes(config);
            ImplPNKS.autorecipeMisc(config);
            ImplPMP.autorecipeMisc(config);
            ImplHVC.autorecipeMisc(config);
            ImplANM.autorecipeMisc(config);
            ImplAQC.autorecipeMisc(config);
            ImplHCB.autorecipeMisc(config);
        }
    }

    private static void addSimpleFishRecipes(VfpConfig config) {
        if (VfpUtils.ingredientDefined("foodSimpleFish")) {
            ItemStack raw_kebab = Kebabs.uncooked_fish(2);
            IntegrationsImpl._registerKebabRecipe(raw_kebab, "foodSimpleFish");
            ItemStack portions = MeatPortions.get(PackagedFood.CODFISH);
            MinecraftGlue.ItemStacks_setSize(portions, 4);
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(portions, new Object[]{"foodSimpleFish", "itemFoodCutter"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Salt_Fish_obj, 4), new Object[]{"Fs", "s.", Character.valueOf('F'), "foodSimpleFish", Character.valueOf('s'), "ingredientSalt"}));
        }
    }

    public static final void dprintfOreId(String label, String oreid) {
        System.out.println("" + label + ", items under OREID=" + oreid);
        for (ItemStack i : OreDictionary.getOres((String)oreid, (boolean)false)) {
            System.out.println("   > " + i);
        }
    }
}

