/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import com.google.common.base.Predicate;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotionTypes;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.meats.WolfsSpiritElement;

public class WolfItems
extends VfpBuildHelperSupport {
    @Override
    protected String categoryName() {
        return "WolfDrops";
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpObj.Wolf_Raw_obj = VfpBuilder.newFood(VfpOid.Wolf_Raw, LikeFood.uncooked_wolf);
        VfpObj.Wolf_Cooked_obj = VfpBuilder.newFood(VfpOid.Wolf_Cooked, LikeFood.wolf);
        VfpObj.Wolf_Spirit_obj = VfpBuilder.newBrewingItem(VfpOid.Wolf_Spirit, false);
        VfpObj.Wolf_Spirit_Element_obj = WolfsSpiritElement.get();
        OreDictionary.registerOre((String)"ingredientKebabAdventure", (Item)VfpObj.Wolf_Raw_obj);
        OreDictionary.registerOre((String)"foodProteinCooked", (Item)VfpObj.Wolf_Cooked_obj);
        if (runtime.getConfig().includePotionBrewing()) {
            PotionHelper.ItemPredicateInstance is_wolfspirit = new PotionHelper.ItemPredicateInstance(VfpObj.Wolf_Spirit_obj);
            PotionHelper.func_185204_a((PotionType)PotionTypes.field_185233_e, (Predicate)is_wolfspirit, (PotionType)VfpPotionTypes.WOLF_SPIRIT);
            PotionHelper.func_185204_a((PotionType)PotionTypes.field_185232_d, (Predicate)is_wolfspirit, (PotionType)VfpPotionTypes.WOLF_SPIRIT);
            PotionHelper.ItemPredicateInstance is_wolfspirit_element = new PotionHelper.ItemPredicateInstance(VfpObj.Wolf_Spirit_Element_obj, -1);
            PotionHelper.func_185204_a((PotionType)VfpPotionTypes.WOLF_SPIRIT, (Predicate)is_wolfspirit_element, (PotionType)VfpPotionTypes.SUPER_WOLF_SPIRIT);
        }
    }

    @Override
    public void doInitLikeFoods(VfpRuntime runtime) {
        LikeFood.wolf.food().item(VfpObj.Wolf_Cooked_obj);
        LikeFood.uncooked_wolf.food().item(VfpObj.Wolf_Raw_obj);
    }

    @Override
    public void doDefineLoot(VfpRuntime runtime) {
        MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", LootTableList.field_186430_l, null, (LootEntry)MinecraftGlue.Loot.createEntryItem(VfpOid.Wolf_Spirit.fmlid(), VfpObj.Wolf_Spirit_obj, MinecraftGlue.TREASURE_WEIGHT(), 2));
    }

    @Override
    public void doBuildRecipes(VfpRuntime runtime) {
        GameRegistry.addSmelting((Item)VfpObj.Wolf_Raw_obj, (ItemStack)new ItemStack(VfpObj.Wolf_Cooked_obj), (float)LikeFood.uncooked_wolf.smeltExperience());
        ItemStack anyElement = new ItemStack(VfpObj.Wolf_Spirit_Element_obj, 1, Short.MAX_VALUE);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(VfpObj.Wolf_Spirit_obj, new Object[]{anyElement, MinecraftGlue.Items_gold_nugget, MinecraftGlue.Items_gold_nugget}));
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.getConfig().includePotionBrewing()) {
            VfpRewards.addRewardingBrewItem(VfpPotionTypes.WOLF_SPIRIT, VfpAchievements.Id.SpiritsFlown);
        }
    }

    @Override
    public void doInitRenderModels(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Raw, VfpObj.Wolf_Raw_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Cooked, VfpObj.Wolf_Cooked_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Spirit, VfpObj.Wolf_Spirit_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Wolf_Spirit_Element, VfpObj.Wolf_Spirit_Element_obj, WolfsSpiritElement.variants());
        }
    }
}

