/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;

public final class CreamSoups
extends VfpLiquidMultiItem {
    private static final int CREAM_SOUP_COLOR = 16775636;
    private static final List<Ingredient> VARIANT_FLAVORS = new ArrayList<Ingredient>();
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static CreamSoups INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final synchronized boolean register(Ingredient flavor) {
        return CreamSoups.register(flavor, VARIANT_FLAVORS, "cream soups");
    }

    public static final synchronized boolean register(FoodPowders.Type flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null food powder is required for cream soups", (Object[])new Object[0]);
        String name = flavor.name().toLowerCase(Locale.US);
        return CreamSoups.register(FoodPowders.toIngredient(flavor, FoodPowders.Usage.SOUP_FLAVOR, name), VARIANT_FLAVORS, "cream soups");
    }

    public CreamSoups(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_SET, tab);
        MinecraftGlue.Potions.addMilkBasedRegenEffect(this);
        this.func_77848_i();
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(MinecraftGlue.Items_bowl);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxSoupsStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected Integer getVariantColorFromMeta(VfpVariant type, Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getVariantColorFromMeta(type, ingredient, renderPass);
        if (colorValue == null) {
            colorValue = 16775636;
        }
        return colorValue;
    }

    @Override
    protected void onFoodEaten(ItemStack eaten, ItemStack remaining, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            MinecraftGlue.Potions.cureBadPotionEffectsWithMilk(player, false, false);
        }
        super.onFoodEaten(eaten, remaining, world, player);
    }

    public static final synchronized CreamSoups get(VfpConfig config) {
        if (INSTANCE == null) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(16);
            String typeName = VARIANT_SET.typeName();
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                variants.add(new VfpTransientVariant(ingredient.id(), typeName, LikeFood.cream_soup, ingredient, null, VARIANT_SET));
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.CreamSoup, CreamSoups.class, VfpBuilder.User.INTERNAL);
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_soup = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)"foodSoup", (ItemStack)a_soup);
                OreDictionary.registerOre((String)"foodCurative", (ItemStack)a_soup);
            }
        }
        return INSTANCE;
    }

    static final synchronized void autorecipe() {
        if (TYPED_INSTANCES == null && CreamSoups.get(null) != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(16);
            for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
                Ingredient ingredient = VARIANT_ARRAY[i].datadata(Ingredient.class);
                instances.add(new ItemStack((Item)INSTANCE, 1, ingredient.id()));
                if (!ingredient.isEnabled()) continue;
                ItemStack a_cream_soup = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                String recipeitem = ingredient.isClassifier() ? ingredient.recipeitemName() : ingredient.recipeitem();
                GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(a_cream_soup, new Object[]{"cx", "xb", Character.valueOf('c'), "ingredientCream", Character.valueOf('x'), recipeitem, Character.valueOf('b'), MinecraftGlue.Items_bowl}), LikeFood.cream_soup.craftExperience()));
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    static {
        VARIANT_SET = new VfpLiquidMultiItem.VariantSet((VfpProfile)VfpOid.CreamSoup, (Class)CreamSoups.class){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }
}

