/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.FoodPortion;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.misc.DefinedDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.misc.EdibleCactus;
import org.jwaresoftware.mcmods.vfp.misc.GenericDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.misc.KingDeckerSandwichRecipe;

public final class DeckerSandwiches
extends VfpPantryMultiItem {
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Decker, DeckerSandwiches.class, "type");
    private static final int _GENERIC = 0;
    private static final int _CHIKIN = 1;
    private static final int _OSTEAK = 2;
    private static final int _MUTTON = 3;
    private static final int _LUMBERJACK = 4;
    private static final int _KINGED = 5;
    private static final int _CUBAN = 6;
    private static final int _CSTEAK = 7;
    static VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, VfpOid.Decker.fmlid(), LikeFood.decker, VARIANT_SET, true), new VfpVariant(1, VfpOid.Decker_Chicken.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(2, VfpOid.Decker_Steak.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(3, VfpOid.Decker_Mutton.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(4, VfpOid.Decker_Lumberjack.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(5, VfpOid.Decker_Kinged.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(6, VfpOid.Decker_Cuban.fmlid(), LikeFood.decker, VARIANT_SET, false), new VfpVariant(7, VfpOid.Decker_Cheesesteak.fmlid(), LikeFood.decker, VARIANT_SET, false)};
    private static DeckerSandwiches INSTANCE;
    private static final int _MAX_INGREDIENTS;
    private static final int _BONUS_EFFORT_THRESHOLD = 4;

    public DeckerSandwiches(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    @Override
    public float func_150906_h(ItemStack stack) {
        float saturation = super.func_150906_h(stack);
        NBTTagCompound instr = MinecraftGlue.Instructions.get(stack);
        if (instr != null && instr.func_150297_b("FoodSaturation", 5)) {
            saturation = instr.func_74760_g("FoodSaturation");
        }
        return saturation;
    }

    @Override
    protected void addFoodPointsInformation_(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        String uitip;
        super.addFoodPointsInformation_(stack, player, tooltip, true);
        NBTTagCompound instr = null;
        if ((advanced || VfpConfig.getInstance().showDeckerIngredients()) && (instr = MinecraftGlue.Instructions.get(stack)) != null && !(uitip = instr.func_74779_i("UiTip")).isEmpty()) {
            String[] lines = StringUtils.split((String)uitip, (String)"\n", (int)9);
            for (int i = 0; i < lines.length; ++i) {
                tooltip.add(" + " + TextFormatting.DARK_GRAY + lines[i] + TextFormatting.RESET);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
    }

    public static final DeckerSandwiches get(VfpConfig config) {
        if (INSTANCE == null) {
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Decker, DeckerSandwiches.class, VfpBuilder.User.INTERNAL);
        }
        return INSTANCE;
    }

    static final void autorecipe(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)new GenericDeckerSandwichRecipe());
        GameRegistry.addRecipe((IRecipe)new KingDeckerSandwichRecipe());
        ItemStack placeholder = new ItemStack(MinecraftGlue.Items_brick);
        GameRegistry.addRecipe((IRecipe)new DefinedDeckerSandwichRecipe(1, LikeFood.chicken, (IRecipe)new ShapedOreRecipe(placeholder, new Object[]{"Bm", "Cv", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('C'), "foodChickenCooked", Character.valueOf('m'), "portionMayo", Character.valueOf('v'), "ingredientSalad"})));
        GameRegistry.addRecipe((IRecipe)new DefinedDeckerSandwichRecipe(2, LikeFood.fried_egg, (IRecipe)new ShapedOreRecipe(placeholder, new Object[]{"Bm", "Ko", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('K'), "foodBeefsteakCooked", Character.valueOf('m'), "portionMayo", Character.valueOf('o'), VfpObj.Caramelized_Alliums_obj})));
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem(new DefinedDeckerSandwichRecipe(7, LikeFood.fried_egg, (IRecipe)new ShapedOreRecipe(placeholder, new Object[]{"Bc", "Ko", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('c'), "foodCheese", Character.valueOf('K'), "foodBeefsteakCooked", Character.valueOf('o'), VfpObj.Sauteed_Alliums_Mushrooms_obj})), VfpOid.Decker_Cheesesteak.craftingXp()));
        GameRegistry.addRecipe((IRecipe)new DefinedDeckerSandwichRecipe(3, LikeFood.fried_egg, (IRecipe)new ShapedOreRecipe(placeholder, new Object[]{"Bm", "K ", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('K'), MinecraftGlue.Items_cooked_mutton, Character.valueOf('m'), "portionMayo"})));
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem(new DefinedDeckerSandwichRecipe(6, null, Float.valueOf(LikeFood.meat_pie.saturationModifier()), (IRecipe)new ShapedOreRecipe(placeholder, new Object[]{"Bc ", "PH ", "ohp", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('c'), "foodCheese", Character.valueOf('P'), MinecraftGlue.Items_cooked_porkchop, Character.valueOf('H'), VfpObj.Cooked_Salt_Pork_obj, Character.valueOf('o'), VfpObj.Caramelized_Alliums_obj, Character.valueOf('h'), "portionHeatSmall", Character.valueOf('p'), VfpObj.Sandwich_Press_Plate_obj})), VfpOid.Decker_Cuban.craftingXp()));
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem(new DefinedDeckerSandwichRecipe(4, null, Float.valueOf(LikeFood.golden_carrot.saturationModifier()), (IRecipe)new ShapedOreRecipe(placeholder, new Object[]{"Bm ", "Kee", "vsp", Character.valueOf('B'), "foodBreadSandwich", Character.valueOf('K'), "foodRedMeatCooked", Character.valueOf('m'), "foodMashedpotatoes", Character.valueOf('e'), "foodEggFried", Character.valueOf('v'), EdibleCactus.roasted_slice(1), Character.valueOf('s'), "portionSaltSmall", Character.valueOf('p'), VfpObj.Sandwich_Press_Plate_obj})), VfpOid.Decker_Lumberjack.craftingXp()));
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack empty() {
        return new ItemStack((Item)INSTANCE, 1, 0);
    }

    static final int getIngredientFoodTotal(ItemFood food, ItemStack ingredient) {
        int ingredientTotal = food instanceof VfpPantryItem ? ((VfpPantryItem)food).getAvailableFoodPoints(ingredient) : food.func_150905_g(ingredient);
        return ingredientTotal;
    }

    private static final void addIngredients(ItemStack deckerSandwich, List<IngredientStats> ingredients, int foodTotal, int fpBonus, float saValue, int muscleBoost) {
        Collections.sort(ingredients);
        if (fpBonus > 0) {
            IngredientStats stat = new IngredientStats(fpBonus);
            ingredients.add(stat);
        }
        float saturation = 0.0f;
        StringBuilder sb = new StringBuilder(150);
        for (IngredientStats ingredient : ingredients) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(ingredient._foodDisplayName);
            saturation += (float)ingredient._foodPoints / (float)foodTotal * ingredient._foodSaturation;
        }
        if (saValue > 0.0f) {
            saturation = saValue;
        } else {
            if (saturation < LikeFood.decker.saturationModifier()) {
                saturation = LikeFood.decker.saturationModifier();
            }
            if (muscleBoost > 0) {
                saturation += LikeFood.muscle_boost.saturationModifier() * (float)muscleBoost;
            }
        }
        MinecraftGlue.Instructions.get(deckerSandwich).func_74776_a("FoodSaturation", saturation);
        MinecraftGlue.Instructions.get(deckerSandwich).func_74778_a("UiTip", sb.toString());
    }

    public static final ItemStack create(IItemHandler grid, int meta, int recipeBonus, int maxValue, float saturationValue) {
        Validate.notNull((Object)grid, (String)"A valid non-null IItemHandler is required", (Object[])new Object[0]);
        recipeBonus = MathHelper.func_76125_a((int)recipeBonus, (int)0, (int)LikeFood.beef.healAmount());
        ItemStack deckerSandwich = MinecraftGlue.ItemStacks_NULLSTACK();
        int foodTotal = 0;
        ArrayList<IngredientStats> stats = new ArrayList<IngredientStats>(_MAX_INGREDIENTS + 2);
        int effortBonus = 0;
        int muscleBoost = 0;
        int n = grid.getSlots();
        for (int i = 0; i < n; ++i) {
            int ingredientTotal;
            ItemStack ingredient = grid.getStackInSlot(i);
            ItemFood food = FoodPortion.toFood(ingredient);
            if (food == null) continue;
            if (ingredient.func_77973_b() == VfpObj.Dollop_Muscle_obj) {
                ++muscleBoost;
            }
            if ((ingredientTotal = DeckerSandwiches.getIngredientFoodTotal(food, ingredient)) <= 0) continue;
            foodTotal += ingredientTotal;
            IngredientStats stat = new IngredientStats(ingredient, food);
            stat._foodPoints = ingredientTotal;
            stats.add(stat);
            if (stats.size() == _MAX_INGREDIENTS) break;
        }
        if (foodTotal > 0) {
            if (meta < 0 || meta >= VARIANT_ARRAY.length) {
                meta = 0;
            }
            if (stats.size() > 4) {
                effortBonus = stats.size() - 3;
                foodTotal += effortBonus;
            }
            if (maxValue < 1) {
                maxValue = MAX_TOTAL_FOOD_VALUE_ALLOWED;
            }
            foodTotal = MathHelper.func_76125_a((int)foodTotal, (int)LikeFood.decker.healAmount(), (int)maxValue);
            deckerSandwich = DeckerSandwiches.createMultiuseInstance((Item)INSTANCE, 1, meta, foodTotal + recipeBonus, LikeFood.TYPICAL_FOOD_PORTION.healAmount());
            DeckerSandwiches.addIngredients(deckerSandwich, stats, foodTotal, effortBonus, saturationValue, muscleBoost);
        }
        return deckerSandwich;
    }

    public static final ItemStack create(IItemHandler grid) {
        return DeckerSandwiches.create(grid, 0, 0, -1, 0.0f);
    }

    public static final ItemStack kingme(IItemHandler grid) {
        return DeckerSandwiches.create(grid, 5, 0, LikeFood.TOWERING_MEGAWICH.healAmount(), 0.0f);
    }

    static {
        _MAX_INGREDIENTS = MinecraftGlue.TABLE_CRAFT_GRID_SIZE();
    }

    private static final class IngredientStats
    implements Comparable<IngredientStats> {
        public String _foodDisplayName;
        public int _foodPoints;
        public float _foodSaturation;

        IngredientStats(int foodpoints) {
            this._foodDisplayName = MinecraftGlue.Strings.translate("item.decker.bonus.name");
            this._foodPoints = foodpoints;
            this._foodSaturation = 10.0f / (float)foodpoints;
        }

        IngredientStats(ItemStack stack, ItemFood food) {
            this._foodDisplayName = stack.func_82833_r();
            this._foodSaturation = food.func_150906_h(stack);
        }

        @Override
        public int compareTo(IngredientStats o) {
            if (o == null) {
                throw new NullPointerException();
            }
            return this._foodDisplayName.compareTo(o._foodDisplayName);
        }
    }
}

